/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.sdk.common;

import com.motivewave.common.h;
import com.motivewave.common.ui.UIUtil;
import com.motivewave.platform.common.o;
import com.motivewave.platform.sdk.common.Defaults;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;

public class TextStyle
implements Cloneable {
    private Font font;
    private javafx.scene.text.Font fontFX;
    private Color color;
    private Color bgColor;
    private FontMetrics fontMetrics;
    private String style;

    public TextStyle(Font font) {
        this(font, null, null);
    }

    public TextStyle(Font font, Color color) {
        this(font, color, null, null);
    }

    public TextStyle(Font font, Color color, Color color2) {
        this(font, color, color2, null);
    }

    public TextStyle(float f2) {
        this(o.a((float)f2), null, null, null);
    }

    public TextStyle(float f2, Color color) {
        this(o.a((float)f2), color, null, null);
    }

    public TextStyle(float f2, Color color, Color color2) {
        this(o.a((float)f2), color, color2, null);
    }

    private TextStyle(Font font, Color color, Color color2, FontMetrics fontMetrics) {
        if (font == null) {
            font = o.l();
        }
        this.font = font;
        this.color = color;
        this.bgColor = color2;
        this.fontMetrics = fontMetrics;
    }

    public double strWidth(String string) {
        return UIUtil.a((String)string, (javafx.scene.text.Font)this.getFontFX());
    }

    public Font getFont() {
        return this.font;
    }

    public javafx.scene.text.Font getFontFX() {
        if (this.fontFX != null) {
            return this.fontFX;
        }
        if (this.font == null) {
            this.font = o.l();
        }
        this.fontFX = UIUtil.a((Font)this.font);
        return this.fontFX;
    }

    public Color getColor() {
        return this.color;
    }

    public Color getColor(Defaults defaults) {
        return this.color == null ? defaults.getTextColor() : this.color;
    }

    public Color getBgColor() {
        return this.bgColor;
    }

    public boolean isBold() {
        return this.font == null ? false : (this.font.getStyle() & 1) != 0;
    }

    public boolean isItalic() {
        return this.font == null ? false : (this.font.getStyle() & 2) != 0;
    }

    public boolean isUnderline() {
        return this.font == null ? false : UIUtil.a((Font)this.font);
    }

    public TextStyle withColor(Color color) {
        if (h.a((Object)color, (Object)this.color)) {
            return this;
        }
        TextStyle textStyle = this.clone();
        textStyle.color = color;
        textStyle.style = null;
        return textStyle;
    }

    public TextStyle withBgColor(Color color) {
        if (h.a((Object)color, (Object)this.bgColor)) {
            return this;
        }
        TextStyle textStyle = this.clone();
        textStyle.bgColor = color;
        textStyle.style = null;
        return textStyle;
    }

    public TextStyle withFont(Font font) {
        if (h.a((Object)font, (Object)this.font)) {
            return this;
        }
        TextStyle textStyle = this.clone();
        if (font == null) {
            font = o.l();
        }
        textStyle.font = font;
        textStyle.fontMetrics = null;
        textStyle.style = null;
        return textStyle;
    }

    public TextStyle withStyle(int n) {
        if (this.font.getStyle() == n) {
            return this;
        }
        TextStyle textStyle = this.clone();
        textStyle.font = this.font.deriveFont(n);
        textStyle.fontMetrics = null;
        textStyle.style = null;
        return textStyle;
    }

    public TextStyle withBold(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = (this.font.getStyle() & 1) != 0;
        if (bl2 == bl) {
            return this;
        }
        boolean bl4 = (this.font.getStyle() & 2) != 0;
        int n = 0;
        if (bl && bl4) {
            n = 3;
        } else if (bl4) {
            n = 2;
        } else if (bl) {
            n = 1;
        }
        TextStyle textStyle = this.clone();
        textStyle.font = this.font.deriveFont(n);
        textStyle.fontMetrics = null;
        textStyle.style = null;
        return textStyle;
    }

    public TextStyle withItalic(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = (this.font.getStyle() & 2) != 0;
        if (bl2 == bl) {
            return this;
        }
        boolean bl4 = (this.font.getStyle() & 1) != 0;
        int n = 0;
        n = bl4 && bl ? 3 : (bl ? 2 : 1);
        TextStyle textStyle = this.clone();
        textStyle.font = this.font.deriveFont(n);
        textStyle.fontMetrics = null;
        textStyle.style = null;
        return textStyle;
    }

    public TextStyle withUnderline(boolean bl) {
        boolean bl2 = UIUtil.a((Font)this.font);
        if (bl2 == bl) {
            return this;
        }
        TextStyle textStyle = this.clone();
        textStyle.font = UIUtil.a((Font)this.font, (boolean)bl);
        textStyle.fontMetrics = null;
        textStyle.style = null;
        return textStyle;
    }

    public TextStyle withSize(float f2) {
        if (this.font.getSize2D() == f2) {
            return this;
        }
        TextStyle textStyle = this.clone();
        textStyle.font = this.font.deriveFont(f2);
        textStyle.fontMetrics = null;
        textStyle.style = null;
        return textStyle;
    }

    public FontMetrics getFontMetrics() {
        if (this.fontMetrics != null) {
            return this.fontMetrics;
        }
        if (this.font == null) {
            this.font = o.l();
        }
        this.fontMetrics = UIUtil.a((Font)this.font);
        return this.fontMetrics;
    }

    public int getHeight() {
        return this.getFontMetrics().getHeight();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof TextStyle)) {
            return false;
        }
        TextStyle textStyle = (TextStyle)object;
        return h.a((Object)this.font, (Object)textStyle.font) && h.a((Object)this.color, (Object)textStyle.color) && h.a((Object)this.bgColor, (Object)textStyle.bgColor);
    }

    public int hashCode() {
        if (this.style == null) {
            this.style = TextStyle.writeStyle(this);
        }
        return this.style.hashCode();
    }

    public TextStyle clone() {
        try {
            return (TextStyle)super.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object toJson() {
        return TextStyle.writeStyle(this);
    }

    public static TextStyle fromJson(Object object) {
        String string = "";
        if (object != null) {
            string = object.toString();
        }
        return TextStyle.readStyle(string);
    }

    public static TextStyle readStyle(String string) {
        int n;
        if (string == null || string.equals("") || string.equals("null")) {
            return null;
        }
        String[] stringArray = string.split("\\|");
        String string2 = stringArray.length <= (n = 0) || stringArray[n].equals("") ? null : stringArray[n];
        float f2 = stringArray.length <= ++n || stringArray[n].equals("") ? 12.0f : h.b((String)stringArray[n]);
        String string3 = stringArray.length <= ++n || stringArray[n].equals("") ? "" : stringArray[n];
        boolean bl = h.a((String)string3.toUpperCase(), (String[])new String[]{"B", "W600", "W700", "W800", "W900"});
        boolean bl2 = stringArray.length > ++n && !stringArray[n].equals("");
        Color color = stringArray.length <= ++n || stringArray[n].equals("") ? null : UIUtil.a((String)stringArray[n]);
        Color color2 = stringArray.length <= ++n || stringArray[n].equals("") ? null : UIUtil.a((String)stringArray[n]);
        boolean bl3 = stringArray.length > ++n && !stringArray[n].equals("");
        ++n;
        int n2 = 0;
        if (bl) {
            n2 |= 1;
        }
        if (bl2) {
            n2 |= 2;
        }
        Font font = new Font(string2, n2, (int)f2);
        font = font.deriveFont(f2);
        if (bl3) {
            font = h.a((Font)font, (boolean)true);
        }
        return new TextStyle(font, color, color2);
    }

    public static String writeStyle(TextStyle textStyle) {
        if (textStyle == null) {
            return "";
        }
        Font font = textStyle.font;
        StringBuffer stringBuffer = new StringBuffer();
        String string = UIUtil.a((Font)font);
        if (string != null) {
            stringBuffer.append(string);
        }
        stringBuffer.append("|");
        if (font != null) {
            stringBuffer.append(h.c((float)font.getSize2D(), (int)2));
        }
        stringBuffer.append("|");
        if (font != null && font.isBold()) {
            stringBuffer.append("B");
        }
        stringBuffer.append("|");
        if (font != null && font.isItalic()) {
            stringBuffer.append("I");
        }
        stringBuffer.append("|");
        if (textStyle.color != null) {
            stringBuffer.append(UIUtil.c((Color)textStyle.color));
        }
        stringBuffer.append("|");
        if (textStyle.bgColor != null) {
            stringBuffer.append(UIUtil.c((Color)textStyle.bgColor));
        }
        if (font != null && h.a((Font)font)) {
            stringBuffer.append("|U");
        }
        h.a((StringBuffer)stringBuffer, (char)'|');
        return stringBuffer.toString();
    }
}

