/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.sdk.common;

import cj.h;
import com.motivewave.platform.sdk.common.BaseInfo;
import com.motivewave.platform.sdk.common.TextStyle;
import com.motivewave.platform.sdk.common.Util;
import java.awt.Color;
import java.awt.Font;

public abstract class TagInfo
extends BaseInfo {
    private String tag;
    private boolean showTag;
    private boolean showTagValue;
    private TextStyle style;

    protected TagInfo(String string, boolean bl, boolean bl2, TextStyle textStyle, boolean bl3) {
        super(bl3);
        this.tag = string;
        this.showTag = bl;
        this.showTagValue = bl2;
        this.style = textStyle;
        this.setKey(string + ":" + bl + ":" + bl2 + ":" + String.valueOf(textStyle == null ? "" : textStyle.toJson()) + this.getKey());
    }

    @Override
    protected void updateKey() {
        super.updateKey();
        this.setKey(this.tag + ":" + this.showTag + ":" + this.showTagValue + ":" + String.valueOf(this.style == null ? "" : this.style.toJson()) + this.getKey());
    }

    public Font getTagFont() {
        return this.getTagStyle().getFont();
    }

    public boolean isShowTag() {
        return this.showTag;
    }

    public boolean isShowTagValue() {
        return this.showTagValue;
    }

    public String getTag() {
        return this.tag;
    }

    public Color getTagTextColor() {
        return this.getTagStyle().getColor();
    }

    public Color getTagBgColor() {
        return this.getTagStyle().getBgColor();
    }

    public TextStyle getTagStyle() {
        return this.style == null ? h.c() : this.style;
    }

    public TagInfo setTagStyle(TextStyle textStyle) {
        if (Util.compare(textStyle, this.getTagStyle())) {
            return this;
        }
        TagInfo tagInfo = this.clone();
        tagInfo.style = textStyle;
        tagInfo.updateKey();
        return tagInfo;
    }

    public TagInfo setShowTag(boolean bl) {
        TagInfo tagInfo = this.clone();
        tagInfo.showTag = bl;
        tagInfo.updateKey();
        return tagInfo;
    }

    public TagInfo setShowTagValue(boolean bl) {
        TagInfo tagInfo = this.clone();
        tagInfo.showTagValue = bl;
        tagInfo.updateKey();
        return tagInfo;
    }

    public TagInfo setTag(String string) {
        TagInfo tagInfo = this.clone();
        tagInfo.tag = string;
        tagInfo.updateKey();
        return tagInfo;
    }

    public TagInfo setTagTextColor(Color color) {
        TagInfo tagInfo = this.clone();
        tagInfo.style = this.getTagStyle().withColor(color);
        tagInfo.updateKey();
        return tagInfo;
    }

    public TagInfo setTagBgColor(Color color) {
        TagInfo tagInfo = this.clone();
        tagInfo.style = this.getTagStyle().withBgColor(color);
        tagInfo.updateKey();
        return tagInfo;
    }

    @Override
    public TagInfo clone() {
        try {
            return (TagInfo)super.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

