/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.sdk.common;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.Util;

public class SwingPoint
implements Comparable {
    private boolean top;
    private int strengthLeft;
    private int strengthRight;
    private int index;
    private double value;
    private long time;

    public SwingPoint(boolean bl, int n, long l2, double d, int n2, int n3) {
        this.top = bl;
        this.index = n;
        this.time = l2;
        this.value = d;
        this.strengthLeft = n2;
        this.strengthRight = n3;
    }

    public boolean isTop() {
        return this.top;
    }

    public boolean isBottom() {
        return !this.top;
    }

    public int getStrengthLeft() {
        return this.strengthLeft;
    }

    public int getStrengthRight() {
        return this.strengthRight;
    }

    public int getIndex() {
        return this.index;
    }

    public long getTime() {
        return this.time;
    }

    public double getValue() {
        return this.value;
    }

    public Coordinate getCoordinate() {
        return new Coordinate(this.time, this.value);
    }

    public int getStrength() {
        return Math.min(this.strengthLeft, this.strengthRight);
    }

    public double getAvgStrength() {
        if (this.strengthLeft == 0 || this.strengthRight == 0) {
            return 0.0;
        }
        return (double)(this.strengthLeft + this.strengthRight) / 2.0;
    }

    public int compareTo(SwingPoint swingPoint) {
        if (this.getTime() < swingPoint.getTime()) {
            return -1;
        }
        if (this.getTime() == swingPoint.getTime()) {
            return 0;
        }
        return 1;
    }

    public String toString() {
        return Util.formatMMDDYYYYHHMM(this.time) + " value: " + Util.round(this.value, 6) + " top: " + this.top + " sl: " + this.strengthLeft + " sr: " + this.strengthRight + " index: " + this.index;
    }
}

