/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.sdk.common;

import com.motivewave.common.f;
import com.motivewave.common.h;
import com.motivewave.platform.sdk.common.Util;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

class StringResolver {
    private static String[][] PATTERNS1 = new String[20][];
    private static String[][] PATTERNS2 = new String[20][];
    private String bundleName;
    private Map bundles = new HashMap();
    private static Map cInstances;

    private StringResolver(String string) {
        this.bundleName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringResolver getInstance(String string) {
        StringResolver stringResolver = (StringResolver)cInstances.get(string);
        if (stringResolver != null) {
            return stringResolver;
        }
        Class<StringResolver> clazz = StringResolver.class;
        synchronized (StringResolver.class) {
            cInstances.put(string, new StringResolver(string));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return (StringResolver)cInstances.get(string);
        }
    }

    public String get(String string, Object ... objectArray) {
        return this.get(string, f.a(), objectArray);
    }

    public final String get(String string, Locale locale, Object ... objectArray) {
        String string2 = this.getMessage(string, locale);
        if (string2 == null) {
            return "";
        }
        if (objectArray == null || objectArray.length == 0) {
            return string2.trim();
        }
        if (string2.indexOf("{0}") >= 0) {
            string2 = Util.replaceAll(string2, StringResolver.getPatterns1(objectArray), objectArray);
        } else if (string2.indexOf("%1") >= 0) {
            string2 = Util.replaceAll(string2, StringResolver.getPatterns2(objectArray), objectArray);
        }
        return string2.trim();
    }

    private String getMessage(String string, Locale locale) {
        ResourceBundle resourceBundle = this.getResourceBundle(locale);
        if (resourceBundle == null) {
            return string;
        }
        try {
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }

    private ResourceBundle getResourceBundle(Locale locale) {
        ResourceBundle resourceBundle;
        if (locale == null) {
            locale = f.a();
        }
        if ((resourceBundle = (ResourceBundle)this.bundles.get(locale)) != null) {
            return resourceBundle;
        }
        try {
            resourceBundle = ResourceBundle.getBundle(this.bundleName, locale);
            this.bundles.put(locale, resourceBundle);
        }
        catch (Exception exception) {
            h.a.severe("StringResolver::getResourceBundle() " + exception.getMessage());
        }
        return resourceBundle;
    }

    private static String[] getPatterns1(Object[] objectArray) {
        if (objectArray.length <= 20) {
            return PATTERNS1[objectArray.length - 1];
        }
        String[] stringArray = new String[objectArray.length];
        for (int k = 0; k < stringArray.length; ++k) {
            stringArray[k] = "{" + k + "}";
        }
        return stringArray;
    }

    private static String[] getPatterns2(Object[] objectArray) {
        if (objectArray.length <= 20) {
            return PATTERNS2[objectArray.length - 1];
        }
        String[] stringArray = new String[objectArray.length];
        for (int k = 0; k < stringArray.length; ++k) {
            stringArray[k] = "%" + (k + 1);
        }
        return stringArray;
    }

    static {
        for (int k = 0; k < 20; ++k) {
            int n;
            String[] stringArray = new String[k + 1];
            String[] stringArray2 = new String[k + 1];
            StringResolver.PATTERNS1[k] = stringArray;
            StringResolver.PATTERNS2[k] = stringArray2;
            for (n = 0; n <= k; ++n) {
                stringArray[n] = "{" + n + "}";
            }
            for (n = k; n >= 0; --n) {
                stringArray2[n] = "%" + (n + 1);
            }
        }
        cInstances = new HashMap();
    }
}

