/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.sdk.common;

import com.motivewave.common.util.aa;
import com.motivewave.common.util.ab;
import com.motivewave.common.util.g;
import com.motivewave.platform.sdk.common.BarInfo;
import com.motivewave.platform.sdk.common.BarSize;
import com.motivewave.platform.sdk.common.BarSizeInfo;
import com.motivewave.platform.sdk.common.BaseInfo;
import com.motivewave.platform.sdk.common.ColorInfo;
import com.motivewave.platform.sdk.common.Enums$BarInput;
import com.motivewave.platform.sdk.common.Enums$MAMethod;
import com.motivewave.platform.sdk.common.Enums$OrderType;
import com.motivewave.platform.sdk.common.Enums$PositionType;
import com.motivewave.platform.sdk.common.Enums$TIF;
import com.motivewave.platform.sdk.common.ExitPoint;
import com.motivewave.platform.sdk.common.FileInfo;
import com.motivewave.platform.sdk.common.FontInfo;
import com.motivewave.platform.sdk.common.GuideInfo;
import com.motivewave.platform.sdk.common.IndicatorInfo;
import com.motivewave.platform.sdk.common.InputInfo;
import com.motivewave.platform.sdk.common.InstrInfo;
import com.motivewave.platform.sdk.common.Instrument;
import com.motivewave.platform.sdk.common.MAMethodInfo;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.PathInfo;
import com.motivewave.platform.sdk.common.PriceBarInfo;
import com.motivewave.platform.sdk.common.Settings$TypeFilter;
import com.motivewave.platform.sdk.common.SettingsBase;
import com.motivewave.platform.sdk.common.ShadeInfo;
import com.motivewave.platform.sdk.common.TimeFrame;
import com.motivewave.platform.sdk.common.desc.BooleanDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDesc;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.OrderTypeDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.TifDescriptor;
import com.motivewave.platform.ui.draw.graph.q;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import v.b;
import v.h;
import v.j;

public class Settings
extends SettingsBase {
    private Set instruments;
    private Set barSizes;
    private Set bars;
    private Set colors;
    private Set exitPoints;
    private Set files;
    private Set fonts;
    private Set guides;
    private Set indicators;
    private Set inputs;
    private Set maMethods;
    private Set markers;
    private Set paths;
    private Set priceBars;
    private Set shades;
    private Set timeFrames;
    private g sessions = null;
    private List tbEditorNames = null;
    private boolean barUpdates = com.motivewave.platform.common.b.a().d();
    private boolean useAccountPosition = com.motivewave.platform.common.b.a().e();
    private boolean autoEntry = true;
    private boolean enterOnActivate = false;
    private boolean closeOnDeactivate = true;
    private boolean enterOnSessionStart = false;
    private boolean closeOnSessionEnd = true;
    private boolean triggerOTH = false;
    private Enums$TIF timeInForce = Enums$TIF.GTC;
    private int tradeLots = 1;
    private Enums$PositionType positionType = Enums$PositionType.BOTH;
    private TimeZone timeZone = null;

    public Settings() {
    }

    public Settings(SettingsDescriptor settingsDescriptor) {
        super(settingsDescriptor);
    }

    @Override
    protected void clearSets() {
        this.timeFrames = null;
        this.shades = null;
        this.priceBars = null;
        this.paths = null;
        this.markers = null;
        this.maMethods = null;
        this.inputs = null;
        this.indicators = null;
        this.guides = null;
        this.fonts = null;
        this.files = null;
        this.exitPoints = null;
        this.colors = null;
        this.bars = null;
        this.barSizes = null;
        this.instruments = null;
    }

    public void setPath(String string, PathInfo pathInfo) {
        this.set(string, pathInfo);
    }

    public Set getPaths() {
        if (this.paths != null) {
            return this.paths;
        }
        this.paths = this.getIds((object, settingDescriptor) -> object instanceof PathInfo);
        return this.paths;
    }

    public void setMarker(String string, MarkerInfo markerInfo) {
        this.set(string, markerInfo);
    }

    public Set getMarkers() {
        if (this.markers != null) {
            return this.markers;
        }
        this.markers = this.getIds((object, settingDescriptor) -> object instanceof MarkerInfo);
        return this.markers;
    }

    public void setIndicator(String string, IndicatorInfo indicatorInfo) {
        this.set(string, indicatorInfo);
    }

    public Set getIndicators() {
        if (this.indicators != null) {
            return this.indicators;
        }
        this.indicators = this.getIds((object, settingDescriptor) -> object instanceof IndicatorInfo);
        return this.indicators;
    }

    public void setBars(String string, BarInfo barInfo) {
        this.set(string, barInfo);
    }

    public Set getBars() {
        if (this.bars != null) {
            return this.bars;
        }
        this.bars = this.getIds((object, settingDescriptor) -> object instanceof BarInfo);
        return this.bars;
    }

    public void setPriceBar(String string, PriceBarInfo priceBarInfo) {
        this.set(string, priceBarInfo);
    }

    public Set getPriceBars() {
        if (this.priceBars != null) {
            return this.priceBars;
        }
        this.priceBars = this.getIds((object, settingDescriptor) -> object instanceof PriceBarInfo);
        return this.priceBars;
    }

    public void setShade(String string, ShadeInfo shadeInfo) {
        this.set(string, shadeInfo);
    }

    public Set getShades() {
        if (this.shades != null) {
            return this.shades;
        }
        this.shades = this.getIds((object, settingDescriptor) -> object instanceof ShadeInfo);
        return this.shades;
    }

    public void setGuide(String string, GuideInfo guideInfo) {
        this.set(string, guideInfo);
    }

    public Set getGuides() {
        if (this.guides != null) {
            return this.guides;
        }
        this.guides = this.getIds((object, settingDescriptor) -> object instanceof GuideInfo);
        return this.guides;
    }

    public void setFont(String string, FontInfo fontInfo) {
        this.set(string, fontInfo);
    }

    public Set getFonts() {
        if (this.fonts != null) {
            return this.fonts;
        }
        this.fonts = this.getIds((object, settingDescriptor) -> object instanceof FontInfo);
        return this.fonts;
    }

    public void setFile(String string, File file) {
        this.set(string, new FileInfo(file));
    }

    public Set getFiles() {
        if (this.files != null) {
            return this.files;
        }
        this.files = this.getIds((object, settingDescriptor) -> object instanceof FileInfo || object instanceof File);
        return this.files;
    }

    public void setColor(String string, Color color) {
        this.set(string, new ColorInfo(color, true));
    }

    public void setColor(String string, ColorInfo colorInfo) {
        this.set(string, colorInfo);
    }

    public Set getColors() {
        if (this.colors != null) {
            return this.colors;
        }
        this.colors = this.getIds((object, settingDescriptor) -> object instanceof ColorInfo || object instanceof Color);
        return this.colors;
    }

    public Set getInputs() {
        if (this.inputs != null) {
            return this.inputs;
        }
        this.inputs = this.getIds((object, settingDescriptor) -> {
            if (object instanceof InputInfo || object instanceof Enums$BarInput || object instanceof q) {
                return true;
            }
            if (settingDescriptor == null) {
                return false;
            }
            return settingDescriptor instanceof InputDescriptor || settingDescriptor instanceof InputDesc;
        });
        return this.inputs;
    }

    @Override
    public Enums$MAMethod getMAMethod(String string) {
        return this.getMAMethod(string, Enums$MAMethod.SMA);
    }

    @Override
    public Enums$MAMethod getMAMethod(String string, Enums$MAMethod enums$MAMethod) {
        Object object = this.get(string);
        if (object == null) {
            return enums$MAMethod;
        }
        if (object instanceof Enums$MAMethod) {
            return (Enums$MAMethod)((Object)object);
        }
        if (object instanceof MAMethodInfo) {
            return ((MAMethodInfo)object).getValue();
        }
        return enums$MAMethod;
    }

    @Override
    public void setMAMethod(String string, Enums$MAMethod enums$MAMethod) {
        this.setValue(string, new MAMethodInfo(enums$MAMethod));
    }

    public Set getMAMethods() {
        if (this.maMethods != null) {
            return this.maMethods;
        }
        this.maMethods = this.getIds((object, settingDescriptor) -> object instanceof MAMethodInfo || object instanceof Enums$MAMethod);
        return this.maMethods;
    }

    public Set getBarSizes() {
        if (this.barSizes != null) {
            return this.barSizes;
        }
        this.barSizes = this.getIds((object, settingDescriptor) -> object instanceof BarSize || object instanceof BarSizeInfo);
        return this.barSizes;
    }

    @Override
    public void setInstrument(String string, Instrument instrument) {
        this.setValue(string, new InstrInfo(instrument));
    }

    public Set getInstruments() {
        if (this.instruments != null) {
            return this.instruments;
        }
        this.instruments = this.getIds((object, settingDescriptor) -> object instanceof Instrument || object instanceof InstrInfo);
        return this.instruments;
    }

    public boolean hasInstruments() {
        for (Object v2 : this.values.values()) {
            InstrInfo instrInfo;
            if (v2 instanceof Instrument) {
                return true;
            }
            if (!(v2 instanceof InstrInfo) || !(instrInfo = (InstrInfo)v2).isEnabled() || instrInfo.getValue() == null) continue;
            return true;
        }
        return false;
    }

    public ExitPoint getExitPoint(String string) {
        Object object = this.get(string);
        return object instanceof ExitPoint ? (ExitPoint)object : null;
    }

    public void setExitPoint(String string, ExitPoint exitPoint) {
        this.setValue(string, exitPoint);
    }

    public Set getExitPoints() {
        if (this.exitPoints != null) {
            return this.exitPoints;
        }
        this.exitPoints = this.getIds((object, settingDescriptor) -> object instanceof ExitPoint);
        return this.exitPoints;
    }

    public TimeFrame getTimeFrame(String string) {
        Object object = this.get(string);
        return object instanceof TimeFrame ? (TimeFrame)object : null;
    }

    public void setTimeFrame(String string, TimeFrame timeFrame) {
        this.setValue(string, timeFrame);
    }

    public Set getTimeFrames() {
        if (this.timeFrames != null) {
            return this.timeFrames;
        }
        this.timeFrames = this.getIds((object, settingDescriptor) -> object instanceof TimeFrame);
        return this.timeFrames;
    }

    public Enums$OrderType getOrderType(String string) {
        SettingDescriptor settingDescriptor;
        Object v2 = this.values.get(string);
        if (this.descriptor != null && v2 == null && (settingDescriptor = this.descriptor.getSetting(string)) instanceof OrderTypeDescriptor) {
            return ((OrderTypeDescriptor)settingDescriptor).getDefaultValue();
        }
        if (v2 == null) {
            return null;
        }
        if (v2 instanceof j) {
            return (Enums$OrderType)((j)v2).a();
        }
        return (Enums$OrderType)((Object)v2);
    }

    public void setOrderType(String string, Enums$OrderType enums$OrderType) {
        this.setValue(string, (Object)enums$OrderType);
    }

    public Enums$TIF getTIF(String string) {
        SettingDescriptor settingDescriptor;
        Object v2 = this.values.get(string);
        if (this.descriptor != null && v2 == null && (settingDescriptor = this.descriptor.getSetting(string)) instanceof TifDescriptor) {
            return ((TifDescriptor)settingDescriptor).getDefaultValue();
        }
        if (v2 == null) {
            return null;
        }
        if (v2 instanceof j) {
            return (Enums$TIF)((j)v2).a();
        }
        return (Enums$TIF)v2;
    }

    public void setTIF(String string, Enums$TIF enums$TIF) {
        this.setValue(string, enums$TIF);
    }

    public Set getValues() {
        return new LinkedHashSet(this.values.keySet());
    }

    @Override
    public void setDouble(String string, Double d) {
        this.setValue(string, new h(d.doubleValue()));
    }

    public void setInteger(String string, Integer n) {
        this.setValue(string, n);
    }

    public void setLong(String string, Long l) {
        this.setValue(string, l);
    }

    public Boolean getBoolean(String string) {
        Object v2 = this.values.get(string);
        if (this.descriptor != null && v2 == null) {
            SettingDescriptor settingDescriptor = this.descriptor.getSetting(string);
            if (settingDescriptor instanceof BooleanDescriptor) {
                BooleanDescriptor booleanDescriptor = (BooleanDescriptor)settingDescriptor;
                return booleanDescriptor.getDefaultValue();
            }
            if (settingDescriptor instanceof b) {
                b b2 = (b)settingDescriptor;
                return b2.a();
            }
        }
        return v2 == null ? null : Boolean.valueOf(com.motivewave.common.h.c(v2));
    }

    public boolean getBoolean(String string, boolean bl) {
        return super.is(string, bl);
    }

    public void setBoolean(String string, Boolean bl) {
        this.setValue(string, bl);
    }

    public void setString(String string, String string2) {
        this.setValue(string, string2);
    }

    public Object getSetting(String string) {
        return this.get(string);
    }

    public void update(Settings settings) {
        this.values.clear();
        for (Map.Entry entry : settings.values.entrySet()) {
            Object object = entry.getValue();
            if (object != null) {
                if (object instanceof aa) {
                    aa aa2 = (aa)object;
                    object = aa2.clone();
                } else if (object instanceof BaseInfo) {
                    BaseInfo baseInfo = (BaseInfo)object;
                    object = baseInfo.clone();
                }
            }
            this.values.put((String)entry.getKey(), object);
        }
        this.tbEditorNames = com.motivewave.common.h.b((List)settings.tbEditorNames);
        this.barUpdates = settings.barUpdates;
        this.useAccountPosition = settings.useAccountPosition;
        this.autoEntry = settings.autoEntry;
        this.enterOnActivate = settings.enterOnActivate;
        this.closeOnDeactivate = settings.closeOnDeactivate;
        this.triggerOTH = settings.triggerOTH;
        this.enterOnSessionStart = settings.enterOnSessionStart;
        this.closeOnSessionEnd = settings.closeOnSessionEnd;
        this.tradeLots = settings.tradeLots;
        this.timeInForce = settings.timeInForce;
        this.positionType = settings.positionType;
        this.timeZone = settings.timeZone;
        if (settings.sessions == null) {
            this.sessions = null;
        } else {
            if (this.sessions == null) {
                this.sessions = new g();
            } else {
                this.sessions.b();
            }
            for (int k = 0; k < settings.sessions.a(); ++k) {
                Map.Entry entry;
                entry = (TimeFrame)settings.sessions.a(k);
                this.sessions.a((Object)((TimeFrame)((Object)entry)).clone());
            }
        }
        this.clearSets();
        this.onUpdated();
    }

    public boolean isBarUpdates() {
        return this.barUpdates;
    }

    public void setBarUpdates(boolean bl) {
        this.barUpdates = bl;
        this.notifyProperty(this, "barUpdates", this.barUpdates, this.barUpdates);
    }

    public boolean isUseAccountPosition() {
        return this.useAccountPosition;
    }

    public void setUseAccountPosition(boolean bl) {
        this.useAccountPosition = bl;
        this.notifyProperty(this, "useAccountPosition", this.useAccountPosition, this.useAccountPosition);
    }

    public boolean isAutoEntry() {
        return this.autoEntry;
    }

    public void setAutoEntry(boolean bl) {
        this.autoEntry = bl;
        this.notifyProperty(this, "autoEntry", this.autoEntry, this.autoEntry);
    }

    public Enums$PositionType getPositionType() {
        return this.positionType;
    }

    public void setPositionType(Enums$PositionType enums$PositionType) {
        this.positionType = enums$PositionType;
        this.notifyProperty(this, "positionType", this.positionType, this.positionType);
    }

    public boolean isEnterOnActivate() {
        return this.enterOnActivate;
    }

    public void setEnterOnActivate(boolean bl) {
        this.enterOnActivate = bl;
        this.notifyProperty(this, "enterOnActivate", this.enterOnActivate, this.enterOnActivate);
    }

    public boolean isCloseOnDeactivate() {
        return this.closeOnDeactivate;
    }

    public void setCloseOnDeactivate(boolean bl) {
        this.closeOnDeactivate = bl;
        this.notifyProperty(this, "closeOnDeactivate", this.closeOnDeactivate, this.closeOnDeactivate);
    }

    public void setTimeInForce(Enums$TIF enums$TIF) {
        this.timeInForce = enums$TIF;
        this.notifyProperty(this, "timeInForce", this.timeInForce, this.timeInForce);
    }

    public Enums$TIF getTimeInForce() {
        return this.timeInForce;
    }

    public void setTradeLots(int n) {
        this.tradeLots = n;
        this.notifyProperty(this, "tradeLots", this.tradeLots, this.tradeLots);
    }

    public int getTradeLots() {
        return this.tradeLots;
    }

    public List getSessions() {
        return this.sessions == null ? Collections.EMPTY_LIST : this.sessions.a();
    }

    public void addSession(TimeFrame timeFrame) {
        if (timeFrame == null) {
            return;
        }
        if (this.sessions == null) {
            this.sessions = new g();
        }
        for (TimeFrame timeFrame2 : this.sessions.a()) {
            if (timeFrame2.getStartTime() != timeFrame.getStartTime() || timeFrame2.getEndTime() != timeFrame.getEndTime()) continue;
            this.sessions.a((Object)timeFrame2);
        }
        this.sessions.a((Object)timeFrame);
    }

    public void clearSessions() {
        if (this.sessions != null) {
            this.sessions.b();
        }
    }

    public boolean isEnterOnSessionStart() {
        return this.enterOnSessionStart;
    }

    public void setEnterOnSessionStart(boolean bl) {
        this.enterOnSessionStart = bl;
        this.notifyProperty(this, "enterOnSessionStart", this.enterOnSessionStart, this.enterOnSessionStart);
    }

    public boolean isCloseOnSessionEnd() {
        return this.closeOnSessionEnd;
    }

    public void setCloseOnSessionEnd(boolean bl) {
        this.closeOnSessionEnd = bl;
        this.notifyProperty(this, "closeOnSessionEnd", this.closeOnSessionEnd, this.closeOnSessionEnd);
    }

    public boolean isTriggerOTH() {
        return this.triggerOTH;
    }

    public void setTriggerOTH(boolean bl) {
        this.triggerOTH = bl;
        this.notifyProperty(this, "triggerOTH", this.triggerOTH, this.triggerOTH);
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        this.notifyProperty(this, "timeZone", this.timeZone, this.timeZone);
    }

    public List getTbEditorNames() {
        return this.tbEditorNames == null ? Collections.emptyList() : Collections.unmodifiableList(this.tbEditorNames);
    }

    public void setTbEditorNames(List list) {
        if (com.motivewave.common.h.c((List)list, (List)this.tbEditorNames)) {
            return;
        }
        List list2 = this.tbEditorNames;
        this.tbEditorNames = com.motivewave.common.h.b((List)list);
        this.notifyProperty(this, "tbEditorNames", list2, this.tbEditorNames);
    }

    @Override
    public Settings clone() {
        try {
            Settings settings = (Settings)super.clone();
            settings.tbEditorNames = com.motivewave.common.h.b((List)this.tbEditorNames);
            settings.barUpdates = this.barUpdates;
            settings.useAccountPosition = this.useAccountPosition;
            settings.tradeLots = this.tradeLots;
            settings.autoEntry = this.autoEntry;
            settings.enterOnActivate = this.enterOnActivate;
            settings.closeOnDeactivate = this.closeOnDeactivate;
            settings.triggerOTH = this.triggerOTH;
            settings.timeInForce = this.timeInForce;
            settings.positionType = this.positionType;
            if (this.sessions != null) {
                settings.sessions = new g();
                for (TimeFrame timeFrame : this.sessions.a()) {
                    settings.sessions.a((Object)timeFrame.clone());
                }
            }
            settings.enterOnSessionStart = this.enterOnSessionStart;
            settings.closeOnSessionEnd = this.closeOnSessionEnd;
            settings.timeZone = this.timeZone;
            return settings;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof Settings)) {
            return false;
        }
        Settings settings = (Settings)object;
        if (!com.motivewave.common.h.a((Object)this.timeZone, (Object)settings.timeZone)) {
            return false;
        }
        if (!com.motivewave.common.h.a((Map)this.values, (Map)settings.values)) {
            return false;
        }
        if (!com.motivewave.common.h.c((List)this.tbEditorNames, (List)settings.tbEditorNames)) {
            return false;
        }
        if (this.barUpdates != settings.barUpdates) {
            return false;
        }
        if (this.useAccountPosition != settings.useAccountPosition) {
            return false;
        }
        if (this.autoEntry != settings.autoEntry) {
            return false;
        }
        if (this.enterOnActivate != settings.enterOnActivate) {
            return false;
        }
        if (this.closeOnDeactivate != settings.closeOnDeactivate) {
            return false;
        }
        if (this.timeInForce != settings.timeInForce) {
            return false;
        }
        if (this.tradeLots != settings.tradeLots) {
            return false;
        }
        if (this.positionType != settings.positionType) {
            return false;
        }
        if (this.enterOnSessionStart != settings.enterOnSessionStart) {
            return false;
        }
        if (this.closeOnSessionEnd != settings.closeOnSessionEnd) {
            return false;
        }
        if (this.triggerOTH != settings.triggerOTH) {
            return false;
        }
        if (this.sessions == null && settings.sessions == null) {
            return true;
        }
        if (this.sessions == null && !settings.sessions.a()) {
            return false;
        }
        if (settings.sessions == null && !this.sessions.a()) {
            return false;
        }
        if (this.sessions == null || settings.sessions == null) {
            return false;
        }
        for (int k = 0; k < this.sessions.a(); ++k) {
            TimeFrame timeFrame = (TimeFrame)this.sessions.a(k);
            if (k >= settings.sessions.a()) {
                return false;
            }
            TimeFrame timeFrame2 = (TimeFrame)settings.sessions.a(k);
            if (timeFrame.equals(timeFrame2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Map toJson() {
        Map map = super.toJson();
        ab ab2 = new ab();
        if (this.barUpdates) {
            ab2.put((Object)"bu", (Object)"Y");
        }
        if (this.useAccountPosition) {
            ab2.put((Object)"ap", (Object)"Y");
        }
        if (!this.autoEntry) {
            map.put("ae", "N");
        }
        if (this.enterOnActivate) {
            ab2.put((Object)"ea", (Object)"Y");
        }
        if (!this.closeOnDeactivate) {
            ab2.put((Object)"cd", (Object)"N");
        }
        if (this.enterOnSessionStart) {
            ab2.put((Object)"es", (Object)"Y");
        }
        if (!this.closeOnSessionEnd) {
            ab2.put((Object)"ce", (Object)"N");
        }
        if (this.triggerOTH) {
            ab2.put((Object)"to", (Object)"Y");
        }
        if (this.timeInForce != null && this.timeInForce != Enums$TIF.GTC) {
            ab2.put((Object)"tif", (Object)this.timeInForce.getShortCode());
        }
        if (this.tradeLots != 1) {
            ab2.put((Object)"lots", (Object)this.tradeLots);
        }
        if (this.positionType != null && this.positionType != Enums$PositionType.BOTH) {
            ab2.put((Object)"pt", (Object)this.positionType.getShortCode());
        }
        if (this.timeZone != null) {
            ab2.put((Object)"tz", (Object)this.timeZone.getID());
        }
        if (!com.motivewave.common.h.a((Collection)this.tbEditorNames)) {
            ab2.put((Object)"tb", (Object)this.tbEditorNames);
        }
        if (!com.motivewave.common.h.b((Object)this.sessions)) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (TimeFrame timeFrame : this.sessions.a()) {
                if (timeFrame == null || !timeFrame.isEnabled()) continue;
                arrayList.add(timeFrame.toJson());
            }
            if (!arrayList.isEmpty()) {
                ab2.put((Object)"sessions", arrayList);
            }
        }
        if (!ab2.isEmpty()) {
            map.put("_s_", ab2);
        }
        return map;
    }

    @Override
    public void fromJson(Map map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        if (map.containsKey("_s_") && map.get("_s_") instanceof Map) {
            ab ab2 = new ab((Map)map.get("_s_"));
            this.barUpdates = ab2.a((Object)"bu", false);
            if (ab2.a(new Object[]{"ap"})) {
                this.useAccountPosition = ab2.a((Object)"ap");
            }
            if (ab2.a(new Object[]{"ae"})) {
                this.autoEntry = ab2.a((Object)"ae");
            }
            if (ab2.a(new Object[]{"ea"})) {
                this.enterOnActivate = ab2.a((Object)"ea");
            }
            if (ab2.a(new Object[]{"cd"})) {
                this.closeOnDeactivate = ab2.a((Object)"cd");
            }
            if (ab2.a(new Object[]{"es"})) {
                this.enterOnSessionStart = ab2.a((Object)"es");
            }
            if (ab2.a(new Object[]{"ce"})) {
                this.closeOnSessionEnd = ab2.a((Object)"ce");
            }
            if (ab2.a(new Object[]{"to"})) {
                this.triggerOTH = ab2.a((Object)"to");
            }
            if (ab2.a(new Object[]{"tif"})) {
                this.timeInForce = Enums$TIF.fromCode(ab2.a(new Object[]{"tif"}));
            }
            if (ab2.a(new Object[]{"pt"})) {
                this.positionType = Enums$PositionType.fromCode(ab2.a(new Object[]{"tif"}));
            }
            if (ab2.a(new Object[]{"tb"})) {
                this.tbEditorNames = ab2.a((Object)"tb");
            }
            if (ab2.a(new Object[]{"sessions"})) {
                this.sessions = new g();
                for (Object e : ab2.b((Object)"sessions")) {
                    TimeFrame timeFrame = TimeFrame.fromJson(e, null);
                    if (timeFrame == null) continue;
                    this.sessions.a((Object)timeFrame);
                }
            }
        }
        super.fromJson(map);
    }

    private Set getIds(Settings$TypeFilter settings$TypeFilter) {
        Map map = this.values;
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        SettingsDescriptor settingsDescriptor = this.descriptor;
        if (settingsDescriptor != null) {
            for (SettingDescriptor object : settingsDescriptor.getSettings()) {
                Object object2 = this.get(object.getId());
                if (!settings$TypeFilter.is(object2, settingsDescriptor.getSetting(object.getId()))) continue;
                linkedHashSet.add(object.getId());
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            if (!settings$TypeFilter.is(entry.getValue(), null)) continue;
            linkedHashSet.add((String)entry.getKey());
        }
        return linkedHashSet;
    }
}

