/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.sdk.common;

import com.motivewave.common.h;
import com.motivewave.common.ui.UIUtil;
import com.motivewave.platform.common.a;
import com.motivewave.platform.sdk.common.BaseInfo;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums$ColorPolicy;
import com.motivewave.platform.sdk.common.PriceBarInfo;
import com.motivewave.platform.sdk.common.TagInfo;
import com.motivewave.platform.sdk.common.TextStyle;
import java.awt.Color;
import java.awt.Stroke;

public abstract class SeriesInfo
extends TagInfo {
    private Color color;
    private Color color2;
    private Color color3;
    private Color color4;
    private float[] dash;
    private float strokeWidth = 1.0f;
    private double fixedWidth;
    private double gradientCenter;
    private boolean continuous;
    private int maxPoints;
    private int barCenter;
    private Enums$ColorPolicy colorPolicy;
    private Stroke stroke = null;
    private Stroke selectedStroke = null;

    protected SeriesInfo(Color color, Color color2, Color color3, Color color4, float[] fArray, float f2, double d, double d2, boolean bl, int n, int n2, Enums$ColorPolicy enums$ColorPolicy, String string, boolean bl2, boolean bl3, TextStyle textStyle, boolean bl4) {
        super(string, bl2, bl3, textStyle, bl4);
        this.color = color;
        this.color2 = color2;
        this.color3 = color3;
        this.color4 = color4;
        if (fArray != null && fArray.length == 1) {
            fArray = null;
        }
        this.dash = fArray;
        this.strokeWidth = f2;
        this.fixedWidth = d;
        this.gradientCenter = d2;
        this.continuous = bl;
        this.maxPoints = n;
        this.barCenter = n2;
        this.colorPolicy = enums$ColorPolicy;
        h.a((float[])fArray);
        this._updateKey();
    }

    private void _updateKey() {
        String string;
        String string2;
        String string3;
        String string4 = UIUtil.c((Color)this.color);
        if (string4 == null) {
            string4 = "";
        }
        if ((string3 = UIUtil.c((Color)this.color2)) == null) {
            string3 = "";
        }
        if ((string2 = UIUtil.c((Color)this.color3)) == null) {
            string2 = "";
        }
        if ((string = UIUtil.c((Color)this.color4)) == null) {
            string = "";
        }
        this.setKey(string4 + ":" + string3 + ":" + string2 + ":" + string + ":" + h.a((float[])this.dash) + ":" + this.strokeWidth + ":" + this.fixedWidth + ":" + this.gradientCenter + ":" + this.continuous + ":" + this.maxPoints + ":" + this.barCenter + ":" + String.valueOf(this.colorPolicy) + ":" + this.getKey());
    }

    @Override
    protected void updateKey() {
        super.updateKey();
        this._updateKey();
    }

    public Color getColor() {
        return this.color;
    }

    public Color getColor(Defaults defaults) {
        return this.color == null ? defaults.getLineColor() : this.color;
    }

    public SeriesInfo setColor(Color color) {
        SeriesInfo seriesInfo = this.clone();
        seriesInfo.color = color;
        seriesInfo.updateKey();
        return seriesInfo;
    }

    public Color getColor2() {
        return this.color2;
    }

    public Color getColor2(Defaults defaults) {
        if (this.color2 != null) {
            return this.color2;
        }
        return this instanceof PriceBarInfo ? defaults.getBarDownColor() : defaults.getRedLine();
    }

    public Color getColor3() {
        return this.color3;
    }

    public Color getColor4() {
        return this.color4;
    }

    public float[] getDash() {
        return this.dash;
    }

    public SeriesInfo setDash(float[] fArray) {
        SeriesInfo seriesInfo = this.clone();
        seriesInfo.dash = fArray;
        seriesInfo.updateKey();
        return seriesInfo;
    }

    @Deprecated
    public float getWidth() {
        return this.strokeWidth;
    }

    public float getStrokeWidth() {
        return this.strokeWidth;
    }

    public Stroke getStroke() {
        if (this.stroke == null) {
            this.stroke = UIUtil.a((float)this.getStrokeWidth(), (float[])this.getDash());
        }
        return this.stroke;
    }

    public Stroke getSelectedStroke() {
        if (this.selectedStroke == null) {
            this.selectedStroke = UIUtil.a((float)(this.getStrokeWidth() + 1.0f), (float[])this.getDash());
        }
        return this.selectedStroke;
    }

    @Deprecated
    public SeriesInfo setWidth(float f2) {
        return this.setStrokeWidth(f2);
    }

    public SeriesInfo setStrokeWidth(float f2) {
        SeriesInfo seriesInfo = this.clone();
        seriesInfo.strokeWidth = f2;
        seriesInfo.updateKey();
        return seriesInfo;
    }

    public int getMaxPoints() {
        return this.maxPoints;
    }

    public boolean isShowAllPoints() {
        return this.maxPoints <= 0;
    }

    public boolean isContinuous() {
        return this.continuous;
    }

    public Enums$ColorPolicy getColorPolicy() {
        return this.colorPolicy;
    }

    @Deprecated
    public boolean isGradient() {
        return this.colorPolicy == Enums$ColorPolicy.GRADIENT;
    }

    public Double getGradientCenter() {
        if (Double.isNaN(this.gradientCenter)) {
            return null;
        }
        return this.gradientCenter;
    }

    public int getBarCenter() {
        return this.barCenter;
    }

    public Integer getFixedWidth() {
        int n = (int)this.fixedWidth;
        if (n == -1) {
            return null;
        }
        return n;
    }

    public double getFixedWidthDouble() {
        return this.fixedWidth;
    }

    @Override
    public SeriesInfo clone() {
        try {
            return (SeriesInfo)super.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Object toJson(BaseInfo baseInfo) {
        SeriesInfo seriesInfo = null;
        if (baseInfo != null) {
            seriesInfo = (SeriesInfo)baseInfo;
        }
        if (this.equals(seriesInfo)) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.isEnabled() ? "Y" : "N");
        stringBuffer.append(",");
        if (seriesInfo == null || !h.a((Object)this.color, (Object)seriesInfo.color)) {
            stringBuffer.append(UIUtil.c((Color)this.color));
        }
        stringBuffer.append(",");
        if (seriesInfo == null || !h.a((Object)this.color2, (Object)seriesInfo.color2)) {
            stringBuffer.append(UIUtil.c((Color)this.color2));
        }
        stringBuffer.append(",");
        if (seriesInfo == null || !h.a((Object)this.color3, (Object)seriesInfo.color3)) {
            stringBuffer.append(UIUtil.c((Color)this.color3));
        }
        stringBuffer.append(",");
        if (seriesInfo == null || !h.a((Object)this.color4, (Object)seriesInfo.color4)) {
            stringBuffer.append(UIUtil.c((Color)this.color4));
        }
        stringBuffer.append(",");
        if (seriesInfo == null || this.strokeWidth != seriesInfo.strokeWidth) {
            stringBuffer.append(h.c((float)this.strokeWidth, (int)4));
        }
        stringBuffer.append(",");
        if (seriesInfo == null || !h.a((float[])this.dash, (float[])seriesInfo.dash)) {
            stringBuffer.append(h.b((float[])this.dash));
        }
        stringBuffer.append(",");
        if (seriesInfo == null || this.isShowTag() != seriesInfo.isShowTag()) {
            stringBuffer.append(this.isShowTag() ? "Y" : "N");
        }
        stringBuffer.append(",");
        if (seriesInfo == null || !h.a((Object)this.getTag(), (Object)seriesInfo.getTag())) {
            stringBuffer.append(a.a((String)this.getTag()));
        }
        stringBuffer.append(",");
        if (seriesInfo == null || !h.a((Object)this.getTagStyle(), (Object)seriesInfo.getTagStyle())) {
            stringBuffer.append(this.getTagStyle() == null ? "" : this.getTagStyle().toJson());
        }
        stringBuffer.append(",");
        if (seriesInfo == null || this.isShowTagValue() != seriesInfo.isShowTagValue()) {
            stringBuffer.append(this.isShowTagValue() ? "Y" : "N");
        }
        stringBuffer.append(",");
        if (seriesInfo == null || this.fixedWidth != seriesInfo.fixedWidth) {
            stringBuffer.append(h.d((double)this.fixedWidth, (int)4));
        }
        stringBuffer.append(",");
        if (seriesInfo == null || this.colorPolicy != seriesInfo.colorPolicy) {
            stringBuffer.append(this.colorPolicy == null ? "" : this.colorPolicy.getShortCode());
        }
        stringBuffer.append(",");
        if (seriesInfo == null || this.gradientCenter != seriesInfo.gradientCenter) {
            stringBuffer.append(h.d((double)this.gradientCenter, (int)4));
        }
        stringBuffer.append(",");
        if (seriesInfo == null || this.continuous != seriesInfo.continuous) {
            stringBuffer.append(this.continuous ? "Y" : "N");
        }
        stringBuffer.append(",");
        if (seriesInfo == null || this.maxPoints != seriesInfo.maxPoints) {
            stringBuffer.append(this.maxPoints);
        }
        stringBuffer.append(",");
        if (seriesInfo == null || this.barCenter != seriesInfo.barCenter) {
            stringBuffer.append(this.barCenter);
        }
        return stringBuffer.toString();
    }
}

