/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.sdk.common;

import com.motivewave.common.h;
import com.motivewave.common.ui.UIUtil;
import com.motivewave.platform.common.a;
import com.motivewave.platform.common.themes.ChartTheme;
import com.motivewave.platform.sdk.common.BaseInfo;
import com.motivewave.platform.sdk.common.Defaults;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.util.List;

public class LineInfo
extends BaseInfo {
    private double value;
    private Color lineColor;
    private float[] dash;
    private float width = 1.0f;
    private Stroke stroke = null;
    private Stroke selectedStroke = null;

    public LineInfo() {
        this(true);
    }

    public LineInfo(boolean bl) {
        this(0.0, null, 1.0f, null, bl);
    }

    public LineInfo(float[] fArray) {
        this(0.0, null, 1.0f, fArray, true);
    }

    public LineInfo(Color color) {
        this(0.0, color, 1.0f, null, true);
    }

    public LineInfo(Color color, boolean bl) {
        this(0.0, color, 1.0f, null, bl);
    }

    public LineInfo(Color color, float f2, boolean bl) {
        this(0.0, color, f2, null, bl);
    }

    public LineInfo(double d, Color color, float f2, float[] fArray) {
        this(d, color, f2, fArray, true);
    }

    public LineInfo(double d, Color color, float f2, float[] fArray, boolean bl) {
        super(bl);
        this.value = d;
        this.lineColor = color;
        this.width = f2;
        this.dash = fArray;
        h.a((float[])fArray);
        this._updateKey();
    }

    public LineInfo(Color color, float f2, float[] fArray, boolean bl) {
        this(0.0, color, f2, fArray, bl);
    }

    private void _updateKey() {
        this.setKey(this.value + ":" + this.width + ":" + h.b((Object)this.dash) + ":" + UIUtil.c((Color)this.lineColor) + this.getKey());
    }

    @Override
    protected void updateKey() {
        super.updateKey();
        this._updateKey();
    }

    public double getValue() {
        return this.value;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public Color getLineColor(Defaults defaults) {
        return this.lineColor == null ? (defaults == null ? null : defaults.getLineColor()) : this.lineColor;
    }

    public float[] getDash() {
        return this.dash;
    }

    public float getWidth() {
        return this.width;
    }

    public Stroke getStroke(boolean bl) {
        return bl ? this.getSelectedStroke() : this.getStroke();
    }

    public Stroke getStroke() {
        if (this.stroke == null) {
            this.stroke = UIUtil.a((float)this.getWidth(), (float[])this.getDash());
        }
        return this.stroke;
    }

    public Stroke getSelectedStroke() {
        if (this.selectedStroke == null) {
            this.selectedStroke = UIUtil.a((float)(this.getWidth() + 1.0f), (float[])this.getDash());
        }
        return this.selectedStroke;
    }

    public LineInfo withWidth(float f2) {
        if (f2 == this.width) {
            return this;
        }
        return new LineInfo(this.value, this.lineColor, f2, this.dash, this.isEnabled());
    }

    public LineInfo withLineColor(Color color) {
        if (h.a((Object)color, (Object)this.lineColor)) {
            return this;
        }
        return new LineInfo(this.value, color, this.width, this.dash, this.isEnabled());
    }

    public LineInfo withDash(float[] fArray) {
        if (h.a((float[])fArray, (float[])this.dash)) {
            return this;
        }
        return new LineInfo(this.value, this.lineColor, this.width, fArray, this.isEnabled());
    }

    public LineInfo withValue(double d) {
        if (d == this.value) {
            return this;
        }
        return new LineInfo(d, this.lineColor, this.width, this.dash, this.isEnabled());
    }

    public LineInfo withEnabled(boolean bl) {
        if (this.value == this.value) {
            return this;
        }
        return new LineInfo(this.value, this.lineColor, this.width, this.dash, bl);
    }

    @Override
    public LineInfo clone() {
        try {
            return (LineInfo)super.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void apply(Graphics2D graphics2D) {
        if (!this.isEnabled()) {
            return;
        }
        Color color = this.lineColor;
        if (color == null) {
            color = ChartTheme.getTheme().LINE;
        }
        graphics2D.setColor(color);
        graphics2D.setStroke(this.getStroke());
    }

    @Override
    public String toString() {
        return this.getKey();
    }

    @Override
    public Object toJson(BaseInfo baseInfo) {
        LineInfo lineInfo = null;
        if (baseInfo != null) {
            lineInfo = (LineInfo)baseInfo;
        }
        if (this.equals(lineInfo)) {
            return null;
        }
        if (!this.isEnabled() && lineInfo != null && this.width == lineInfo.width && h.a((float[])this.dash, (float[])lineInfo.dash) && this.value == lineInfo.value && h.a((Object)this.lineColor, (Object)lineInfo.lineColor)) {
            return "N";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.isEnabled()) {
            stringBuffer.append("N,");
        }
        if (lineInfo == null || this.width != lineInfo.width) {
            stringBuffer.append(h.d((double)this.width, (int)4));
        }
        stringBuffer.append(",");
        if (lineInfo == null || !h.a((float[])this.dash, (float[])lineInfo.dash)) {
            stringBuffer.append(h.b((float[])this.dash));
        }
        stringBuffer.append(",");
        if (lineInfo == null || !h.a((Object)this.lineColor, (Object)lineInfo.lineColor)) {
            stringBuffer.append(this.lineColor == null ? "" : UIUtil.c((Color)this.lineColor));
        }
        stringBuffer.append(",");
        if (lineInfo == null && this.value != 0.0) {
            stringBuffer.append(h.d((double)this.value, (int)10));
        } else if (lineInfo == null || this.value != lineInfo.value) {
            stringBuffer.append(h.d((double)this.value, (int)10));
        }
        h.a((StringBuffer)stringBuffer, (char)',');
        String string = stringBuffer.toString();
        if (h.g((String)string)) {
            return ",";
        }
        return string;
    }

    public static LineInfo fromJson(Object object, LineInfo lineInfo) {
        Color color;
        float[] fArray;
        float f2;
        boolean bl;
        String string = "";
        if (object != null) {
            string = object.toString();
        }
        if (h.a((Object)string, (Object)"N") && lineInfo != null) {
            return new LineInfo(lineInfo.value, lineInfo.lineColor, lineInfo.width, lineInfo.dash, false);
        }
        boolean bl2 = bl = !string.startsWith("N,");
        if (!bl) {
            string = string.substring(2);
        }
        List list = a.a((String)string);
        int n = 0;
        float f3 = list.size() <= n || h.a(list.get(n), (Object)"") ? (lineInfo == null ? 1.0f : lineInfo.width) : (f2 = h.b((String)((String)list.get(n))));
        float[] fArray2 = list.size() <= ++n || h.a(list.get(n), (Object)"") ? (lineInfo == null ? null : lineInfo.dash) : (fArray = h.b((String)((String)list.get(n))));
        Color color2 = list.size() <= ++n || h.a((String)((String)list.get(n)), (String[])new String[]{"", "null"}) ? (lineInfo == null ? null : lineInfo.lineColor) : (color = UIUtil.a((String)((String)list.get(n))));
        double d = list.size() <= ++n || h.a(list.get(n), (Object)"") ? (lineInfo == null ? 0.0 : lineInfo.value) : h.a((String)((String)list.get(n)));
        ++n;
        return new LineInfo(d, color, f2, fArray, bl);
    }
}

