/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.sdk.common;

import com.motivewave.platform.databean.LiveTicker;
import com.motivewave.platform.databean.MWInstrument;
import com.motivewave.platform.databean.Ticker;
import com.motivewave.platform.sdk.common.BaseInfo;
import com.motivewave.platform.sdk.common.Instrument;

public class InstrInfo
extends BaseInfo {
    private Instrument value;

    public InstrInfo(Instrument instrument) {
        this(instrument, true);
    }

    public InstrInfo(Instrument instrument, boolean bl) {
        super(bl);
        this.value = instrument;
        this._updateKey();
    }

    private void _updateKey() {
        this.setKey((String)(this.value == null ? "null" : ((Ticker)this.value).getKey() + this.getKey()));
    }

    @Override
    protected void updateKey() {
        super.updateKey();
        this._updateKey();
    }

    public Instrument getValue() {
        return this.value;
    }

    @Override
    public Object toJson(BaseInfo baseInfo) {
        if (this.equals(baseInfo)) {
            return null;
        }
        if (!this.isEnabled() && baseInfo != null && ((InstrInfo)baseInfo).getValue() == this.value) {
            return "N";
        }
        String string = this.value == null ? "null" : ((Ticker)this.value).getKey();
        return this.isEnabled() ? string : "N," + string;
    }

    public static InstrInfo fromJson(Object object, InstrInfo instrInfo) {
        boolean bl;
        String string = "";
        if (object != null) {
            string = object.toString();
        }
        if (string.equals("")) {
            return instrInfo;
        }
        if (string.equals("N") && instrInfo != null) {
            return new InstrInfo(instrInfo.value, false);
        }
        boolean bl2 = bl = !string.startsWith("N,");
        if (!bl) {
            string = string.substring(2);
        }
        if (string.toUpperCase().equals("NULL")) {
            return new InstrInfo(null, bl);
        }
        Object object2 = LiveTicker.get((MWInstrument)MWInstrument.byKey((String)string));
        if (object2 == null && instrInfo != null) {
            object2 = instrInfo.getValue();
        }
        return new InstrInfo((Instrument)object2, bl);
    }
}

