/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.sdk.common;

import com.motivewave.common.h;
import com.motivewave.common.ui.UIUtil;
import com.motivewave.platform.sdk.common.BaseInfo;
import com.motivewave.platform.sdk.common.TextStyle;
import java.awt.Color;
import java.awt.Font;

public class FontInfo
extends BaseInfo {
    private TextStyle value;

    public FontInfo(Font font, Color color) {
        this(font, color, true);
    }

    public FontInfo(Font font, Color color, boolean bl) {
        this(font, color, null, bl);
    }

    public FontInfo(Font font, Color color, Color color2, boolean bl) {
        this(new TextStyle(font, color, color2), bl);
    }

    public FontInfo(TextStyle textStyle, boolean bl) {
        super(bl);
        this.value = textStyle;
        this._updateKey();
    }

    private void _updateKey() {
        this.setKey(String.valueOf(this.value == null ? "" : this.value.toJson()) + this.getKey());
    }

    @Override
    protected void updateKey() {
        super.updateKey();
        this._updateKey();
    }

    public TextStyle getValue() {
        return this.value;
    }

    public double strWidth(String string) {
        return this.value == null ? UIUtil.a((String)string, (Font)cj.h.h()) : this.value.strWidth(string);
    }

    public Font getFont() {
        return this.value == null ? null : this.value.getFont();
    }

    public Color getColor() {
        return this.value == null ? null : this.value.getColor();
    }

    public Color getBgColor() {
        return this.value == null ? null : this.value.getBgColor();
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof FontInfo)) {
            return false;
        }
        FontInfo fontInfo = (FontInfo)object;
        return h.a((Object)this.value, (Object)fontInfo.value) && this.isEnabled() == fontInfo.isEnabled();
    }

    @Override
    public FontInfo clone() {
        try {
            return (FontInfo)super.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Object toJson(BaseInfo baseInfo) {
        Object object;
        if (this.equals(baseInfo)) {
            return null;
        }
        if (baseInfo != null) {
            object = (FontInfo)baseInfo;
            if (h.a((Object)this.value, (Object)((FontInfo)object).value)) {
                return this.isEnabled() ? "Y" : "N";
            }
        }
        object = this.value.toJson();
        return this.isEnabled() ? object : "N," + String.valueOf(object);
    }

    public static FontInfo fromJson(Object object, FontInfo fontInfo) {
        boolean bl;
        String string = "";
        if (object != null) {
            string = object.toString();
        }
        if (string.equals("")) {
            return fontInfo;
        }
        if (string.equals("N") || string.equals("Y")) {
            return new FontInfo(fontInfo == null ? null : fontInfo.value, string.equals("Y"));
        }
        boolean bl2 = bl = !string.startsWith("N,");
        if (!bl) {
            string = string.substring(2);
        }
        return new FontInfo(TextStyle.readStyle(string), bl);
    }
}

