/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.sdk.common;

import com.motivewave.common.ui.UIUtil;
import com.motivewave.platform.sdk.common.BaseInfo;
import com.motivewave.platform.sdk.common.Util;
import javafx.scene.paint.Color;

public class ColorInfo
extends BaseInfo {
    private java.awt.Color color;
    private Color colorFX;

    public ColorInfo(java.awt.Color color) {
        this(color, true);
    }

    public ColorInfo(Color color) {
        this(color, true);
    }

    public ColorInfo(java.awt.Color color, boolean bl) {
        super(bl);
        this.color = color;
        this.colorFX = UIUtil.a((java.awt.Color)color);
        this._updateKey();
    }

    public ColorInfo(Color color, boolean bl) {
        super(bl);
        this.color = UIUtil.a((Color)color);
        this.colorFX = color;
        this._updateKey();
    }

    private void _updateKey() {
        this.setKey(UIUtil.c((java.awt.Color)this.color) + super.getKey());
    }

    @Override
    protected void updateKey() {
        super.updateKey();
        this._updateKey();
    }

    public java.awt.Color getColor() {
        return this.color;
    }

    public java.awt.Color getValue() {
        return this.color;
    }

    public Color getColorFX() {
        return this.colorFX;
    }

    @Override
    public ColorInfo clone() {
        try {
            return (ColorInfo)super.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Object toJson(BaseInfo baseInfo) {
        if (this.equals(baseInfo)) {
            return null;
        }
        if (!this.isEnabled() && baseInfo != null && Util.compare(this.color, ((ColorInfo)baseInfo).color)) {
            return "N";
        }
        String string = this.color == null ? "null" : UIUtil.c((java.awt.Color)this.color);
        return this.isEnabled() ? string : "N," + string;
    }

    public static ColorInfo fromJson(Object object, ColorInfo colorInfo) {
        boolean bl;
        String string = "";
        if (object != null) {
            string = object.toString();
        }
        if (string.equals("")) {
            return colorInfo;
        }
        if (string.equals("N") && colorInfo != null) {
            return new ColorInfo(colorInfo.getColor(), false);
        }
        boolean bl2 = bl = !string.startsWith("N,");
        if (!bl) {
            string = string.substring(2);
        }
        return new ColorInfo(UIUtil.a((String)string), bl);
    }
}

