/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.sdk.common;

import com.motivewave.common.h;
import com.motivewave.platform.common.ab;
import com.motivewave.platform.common.b;
import com.motivewave.platform.sdk.common.Enums$BarSizeType;
import com.motivewave.platform.sdk.common.Enums$IntervalType;
import com.motivewave.platform.sdk.common.Util;
import java.util.HashMap;
import java.util.Map;

public class BarSize
implements Comparable {
    private int interval;
    private int reverseInterval;
    private long sizeMillis = -1L;
    private boolean intervalPoints = b.a().isIntervalPoints();
    private Enums$BarSizeType type;
    private Enums$IntervalType intervalType = Enums$IntervalType.MINUTE;
    private String key;
    static Map key2BarSize = new HashMap();

    private BarSize(Enums$BarSizeType enums$BarSizeType, Enums$IntervalType enums$IntervalType, int n, int n2, boolean bl) {
        this.type = enums$BarSizeType;
        this.intervalType = enums$IntervalType;
        this.interval = n;
        this.reverseInterval = n2;
        this.intervalPoints = bl;
        long l = n;
        if (this.isLinear() || enums$BarSizeType == Enums$BarSizeType.OFA_LINEAR) {
            this.sizeMillis = enums$IntervalType == Enums$IntervalType.MONTH ? l * 86400000L * 30L : (enums$IntervalType == Enums$IntervalType.WEEK ? l * 86400000L * 7L : (enums$IntervalType == Enums$IntervalType.DAY ? l * 86400000L : (enums$IntervalType == Enums$IntervalType.HOUR ? l * 3600000L : (enums$IntervalType == Enums$IntervalType.SECOND ? l * 1000L : (enums$IntervalType == Enums$IntervalType.MILLISECOND ? l : l * 60000L)))));
        }
        this.key = BarSize._genKey(enums$BarSizeType, enums$IntervalType, n, n2);
    }

    public int getIntervalMinutes() {
        if (!this.isFixedSize()) {
            return 0;
        }
        if (this.intervalType == null || this.intervalType == Enums$IntervalType.MINUTE) {
            return this.interval;
        }
        if (this.intervalType == Enums$IntervalType.MILLISECOND) {
            return this.interval / 60000;
        }
        if (this.intervalType == Enums$IntervalType.SECOND) {
            return this.interval / 60;
        }
        if (this.intervalType == Enums$IntervalType.HOUR) {
            return this.interval * 60;
        }
        if (this.intervalType == Enums$IntervalType.DAY) {
            return this.interval * 1440;
        }
        if (this.intervalType == Enums$IntervalType.WEEK) {
            return this.interval * 1440 * 7;
        }
        if (this.intervalType == Enums$IntervalType.MONTH) {
            return this.interval * 1440 * 30;
        }
        return this.interval;
    }

    public int getIntervalSeconds() {
        if (!this.isFixedSize()) {
            return 0;
        }
        if (this.intervalType == null || this.intervalType == Enums$IntervalType.SECOND) {
            return this.interval;
        }
        if (this.intervalType == Enums$IntervalType.MILLISECOND) {
            return this.interval / 1000;
        }
        if (this.intervalType == Enums$IntervalType.MINUTE) {
            return this.interval * 60;
        }
        if (this.intervalType == Enums$IntervalType.HOUR) {
            return this.interval * 60 * 60;
        }
        if (this.intervalType == Enums$IntervalType.DAY) {
            return this.interval * 1440 * 60;
        }
        if (this.intervalType == Enums$IntervalType.WEEK) {
            return this.interval * 1440 * 7 * 60;
        }
        if (this.intervalType == Enums$IntervalType.MONTH) {
            return this.interval * 1440 * 30 * 60;
        }
        return this.interval;
    }

    public long getIntervalMillis() {
        if (!this.isFixedSize()) {
            return 0L;
        }
        if (this.intervalType == null || this.intervalType == Enums$IntervalType.MILLISECOND) {
            return this.interval;
        }
        if (this.intervalType == Enums$IntervalType.SECOND) {
            return (long)this.interval * 1000L;
        }
        if (this.intervalType == Enums$IntervalType.MINUTE) {
            return (long)(this.interval * 60) * 1000L;
        }
        if (this.intervalType == Enums$IntervalType.HOUR) {
            return (long)(this.interval * 60 * 60) * 1000L;
        }
        if (this.intervalType == Enums$IntervalType.DAY) {
            return (long)(this.interval * 1440 * 60) * 1000L;
        }
        if (this.intervalType == Enums$IntervalType.WEEK) {
            return (long)(this.interval * 1440 * 7 * 60) * 1000L;
        }
        if (this.intervalType == Enums$IntervalType.MONTH) {
            return (long)(this.interval * 1440 * 30 * 60) * 1000L;
        }
        return this.interval;
    }

    public int getInterval() {
        return this.interval;
    }

    public int getReverseInterval() {
        return this.reverseInterval;
    }

    public long getSizeMillis() {
        return this.sizeMillis;
    }

    public boolean isLinear() {
        return this.type == Enums$BarSizeType.LINEAR;
    }

    public boolean isFixedSize() {
        return this.type == Enums$BarSizeType.LINEAR || this.type == Enums$BarSizeType.OFA_LINEAR;
    }

    public boolean isIntraday() {
        if (!this.isLinear() && this.type != Enums$BarSizeType.OFA_LINEAR) {
            return true;
        }
        if (this.intervalType == Enums$IntervalType.MINUTE) {
            return this.interval < 1440;
        }
        if (this.intervalType == Enums$IntervalType.HOUR) {
            return this.interval < 24;
        }
        if (this.intervalType == Enums$IntervalType.SECOND) {
            return this.interval < 86400;
        }
        if (this.intervalType == Enums$IntervalType.MILLISECOND) {
            return this.interval < 86400000;
        }
        return false;
    }

    public Enums$IntervalType getIntervalType() {
        return this.intervalType;
    }

    public Enums$BarSizeType getType() {
        return this.type;
    }

    public boolean isRenko() {
        return this.type == Enums$BarSizeType.RENKO;
    }

    public boolean isPointAndFigure() {
        return this.type == Enums$BarSizeType.POINT_AND_FIGURE;
    }

    public boolean isReversal() {
        return this.type == Enums$BarSizeType.REVERSAL;
    }

    public boolean isRange() {
        return this.type == Enums$BarSizeType.RANGE;
    }

    public boolean isConstantVolume() {
        return this.type == Enums$BarSizeType.CONSTANT_VOLUME;
    }

    public boolean isTick() {
        return this.type == Enums$BarSizeType.TICK;
    }

    public boolean isIntervalPoints() {
        return this.intervalPoints;
    }

    public boolean isBidAsk() {
        return this.type == Enums$BarSizeType.BID_ASK;
    }

    public boolean isHybridRenko() {
        return this.type == Enums$BarSizeType.HYBRID_RENKO;
    }

    public boolean isOFAProbe() {
        return this.type == Enums$BarSizeType.OFA;
    }

    public boolean isOFALinear() {
        return this.type == Enums$BarSizeType.OFA_LINEAR;
    }

    public boolean isOFA() {
        return this.type == Enums$BarSizeType.OFA_LINEAR || this.type == Enums$BarSizeType.OFA;
    }

    public String getKey() {
        return this.key;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        try {
            BarSize barSize = (BarSize)object;
            if (barSize.getType() != this.getType()) {
                return false;
            }
            if (this.isFixedSize()) {
                return this.getSizeMillis() == barSize.getSizeMillis();
            }
            return this.type == barSize.type && this.interval == barSize.interval && this.intervalPoints == barSize.intervalPoints && this.reverseInterval == barSize.reverseInterval;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getName() {
        switch (this.type) {
            case BID_ASK: {
                return BarSize.get("BID_ASK_LINES", new Object[0]);
            }
            case CONSTANT_VOLUME: {
                return this.interval == -1 ? BarSize.get("CONSTANT_VOLUME", new Object[0]) : BarSize.get("CONSTANT_VOLUME_VAL", ab.c((long)this.interval));
            }
            case TICK: {
                return this.interval == -1 ? BarSize.get("TICK", new Object[0]) : BarSize.get("TICK_VAL", ab.c((long)this.interval));
            }
            case RANGE: {
                return this.interval == -1 ? BarSize.get("RANGE", new Object[0]) : BarSize.get("RANGE_VAL", ab.c((long)this.interval));
            }
            case RENKO: {
                return this.interval == -1 ? BarSize.get("RENKO", new Object[0]) : BarSize.get("RENKO_VAL", ab.c((long)this.interval));
            }
            case LINE_BREAK: {
                return this.interval == -1 ? BarSize.get("LINE_BREAK", new Object[0]) : BarSize.get("LINE_BREAK_VAL", this.interval);
            }
            case KAGI: {
                return this.interval == -1 ? BarSize.get("KAGI", new Object[0]) : BarSize.get("KAGI", this.interval);
            }
            case NT_RENKO: {
                return this.interval == -1 ? BarSize.get("NT_RENKO", new Object[0]) : BarSize.get("NT_RENKO_VAL", ab.c((long)this.interval));
            }
            case OFA: {
                return this.interval == -1 ? BarSize.get("OFA_BARS", new Object[0]) : BarSize.get("OFA_BARS_VAL", ab.c((long)this.interval), ab.c((long)this.reverseInterval));
            }
            case OFA_LINEAR: {
                return "OFA\u00ae " + this.getLinearName();
            }
            case HYBRID_RENKO: {
                return this.interval == -1 ? BarSize.get("HYBRID_RENKO", new Object[0]) : BarSize.get("HYBRID_RENKO_VAL", ab.c((long)this.interval), ab.c((long)this.reverseInterval));
            }
            case POINT_AND_FIGURE: {
                return this.interval == -1 ? BarSize.get("POINT_AND_FIGURE", new Object[0]) : BarSize.get("POINT_AND_FIGURE_VAL", ab.c((long)this.interval), ab.c((long)this.reverseInterval));
            }
            case REVERSAL: {
                return this.interval == -1 ? BarSize.get("REVERSAL", new Object[0]) : BarSize.get("REVERSAL_VAL", ab.c((long)this.reverseInterval), ab.c((long)this.interval));
            }
        }
        return this.getLinearName();
    }

    private String getLinearName() {
        int n = 0;
        if (this.intervalType == Enums$IntervalType.MONTH) {
            if (this.interval % 12 == 0) {
                return BarSize.get("LBL_YEAR", "" + this.interval / 12);
            }
            return BarSize.get("LBL_MONTH", this.interval);
        }
        if (this.intervalType == Enums$IntervalType.WEEK) {
            return BarSize.get("LBL_WEEK", this.interval);
        }
        if (this.intervalType == Enums$IntervalType.HOUR) {
            if (this.interval < 24) {
                return BarSize.get("LBL_HOUR", this.interval);
            }
            if (this.interval % 24 != 0) {
                return BarSize.get("LBL_DAYS", h.c((double)((double)this.interval / 24.0), (int)2));
            }
            n = this.interval / 24;
        } else if (this.intervalType == Enums$IntervalType.MINUTE) {
            if (this.interval < 1440 && this.interval % 60 != 0) {
                return BarSize.get("LBL_MIN", this.interval);
            }
            if (this.interval < 1440 && this.interval % 60 == 0) {
                return BarSize.get("LBL_HOUR", this.interval / 60);
            }
            if (this.interval % 1440 != 0) {
                return BarSize.get("LBL_DAYS", h.c((double)((double)this.interval / 1440.0), (int)2));
            }
            n = this.interval / 1440;
        } else if (this.intervalType == Enums$IntervalType.SECOND) {
            if (this.interval % 60 != 0) {
                return BarSize.get("LBL_SECOND", this.interval);
            }
            if (this.interval < 86400 && this.interval >= 3600 && this.interval % 3600 == 0) {
                return BarSize.get("LBL_HOUR", this.interval / 3660);
            }
            if (this.interval < 86400 && this.interval >= 60 && this.interval % 60 == 0) {
                return BarSize.get("LBL_MIN", this.interval / 60);
            }
            if (this.interval > 86400 && this.interval % 86400 != 0) {
                return BarSize.get("LBL_DAYS", h.c((double)((double)this.interval / 86400.0), (int)2));
            }
            n = this.interval / 86400;
        } else if (this.intervalType == Enums$IntervalType.MILLISECOND) {
            if (this.interval % 1000 != 0) {
                return BarSize.get("LBL_MILLISECOND", this.interval);
            }
            if (this.interval % 60 * 1000 != 0) {
                return BarSize.get("LBL_SECOND", this.interval / 1000);
            }
            if (this.interval < 86400000 && this.interval >= 3600000 && this.interval % 3600 * 1000 == 0) {
                return BarSize.get("LBL_HOUR", this.interval / 3660000);
            }
            if (this.interval < 86400000 && this.interval >= 60000 && this.interval % 60 * 1000 == 0) {
                return BarSize.get("LBL_MIN", this.interval / 60000);
            }
            if (this.interval > 86400000 && this.interval % 86400000 != 0) {
                return BarSize.get("LBL_DAYS", h.c((double)((double)this.interval / 8.64E7), (int)2));
            }
            n = this.interval / 86400000;
        } else {
            n = this.interval;
        }
        if (n % 360 == 0) {
            return BarSize.get("LBL_YEAR", "" + n / 360);
        }
        if (n % 30 == 0) {
            return BarSize.get("LBL_MONTH", "" + n / 30);
        }
        if (n % 7 == 0) {
            return BarSize.get("LBL_WEEK", "" + n / 7);
        }
        return BarSize.get("LBL_DAY", n);
    }

    public String getShortName() {
        switch (this.type) {
            case BID_ASK: {
                return BarSize.get("BID_ASK_LINES", new Object[0]);
            }
            case CONSTANT_VOLUME: {
                return this.interval == -1 ? "VOL" : ab.c((long)this.interval) + "V";
            }
            case TICK: {
                return this.interval == -1 ? "TICK" : ab.c((long)this.interval) + "T";
            }
            case RANGE: {
                return this.interval == -1 ? "RG" : this.interval + "RG";
            }
            case RENKO: {
                return this.interval == -1 ? "RK" : this.interval + "RK";
            }
            case LINE_BREAK: {
                return this.interval == -1 ? "LB" : this.interval + "LB";
            }
            case KAGI: {
                return this.interval == -1 ? "K" : this.interval + "K";
            }
            case NT_RENKO: {
                return this.interval == -1 ? "NTRK" : this.interval + "NTRK";
            }
            case OFA: {
                return this.interval == -1 ? "OFA\u00ae" : "OFA\u00ae" + this.interval + "," + this.reverseInterval;
            }
            case OFA_LINEAR: {
                return "OFA\u00ae" + BarSize.printInterval(this.interval, this.intervalType);
            }
            case HYBRID_RENKO: {
                return this.interval == -1 ? "HRK" : this.interval + "," + this.reverseInterval + "HRK";
            }
            case POINT_AND_FIGURE: {
                return this.interval == -1 ? "PF" : this.interval + "," + this.reverseInterval + " PF";
            }
            case REVERSAL: {
                return this.interval == -1 ? "REV" : this.reverseInterval + "," + this.interval + " REV";
            }
        }
        return BarSize.printInterval(this.interval, this.intervalType);
    }

    private static String printInterval(int n, Enums$IntervalType enums$IntervalType) {
        int n2 = 0;
        if (enums$IntervalType == Enums$IntervalType.MONTH) {
            if (n % 12 == 0) {
                return n / 12 + "Y";
            }
            return n + "M";
        }
        if (enums$IntervalType == Enums$IntervalType.WEEK) {
            return n + "W";
        }
        if (enums$IntervalType == Enums$IntervalType.HOUR) {
            if (n < 24) {
                return n + "h";
            }
            if (n % 24 != 0) {
                return h.c((double)((double)n / 24.0), (int)2) + "D";
            }
            n2 = n / 24;
        } else if (enums$IntervalType == Enums$IntervalType.MINUTE) {
            if (n < 1440 && n % 60 != 0) {
                return n + "m";
            }
            if (n < 1440 && n % 60 == 0) {
                return n / 60 + "h";
            }
            if (n % 1440 != 0) {
                return h.c((double)((double)n / 1440.0), (int)2) + "D";
            }
            n2 = n / 1440;
        } else if (enums$IntervalType == Enums$IntervalType.SECOND) {
            if (n < 86400 && n % 60 != 0) {
                return n + "s";
            }
            if (n < 86400 && n >= 3660 && n % 3660 == 0) {
                return n / 3660 + "h";
            }
            if (n < 86400 && n >= 60 && n % 60 == 0) {
                return n / 60 + "m";
            }
            if (n % 86400 != 0) {
                return h.c((double)((double)n / 86400.0), (int)2) + "D";
            }
            n2 = n / 86400;
        } else if (enums$IntervalType == Enums$IntervalType.MILLISECOND) {
            if (n < 86400000 && n % 1000 != 0) {
                return n + "ms";
            }
            if (n < 86400000 && n % 60 * 1000 != 0) {
                return n / 1000 + "s";
            }
            if (n < 86400000 && n >= 3660000 && n % 3660 * 1000 == 0) {
                return n / 3660000 + "h";
            }
            if (n < 86400000 && n >= 60000 && n % 60 * 1000 == 0) {
                return n / 60000 + "m";
            }
            if (n % 86400000 != 0) {
                return h.c((double)((double)n / 8.64E7), (int)2) + "D";
            }
            n2 = n / 86400000;
        } else {
            n2 = n;
        }
        if (n2 % 360 == 0) {
            return n2 / 360 + "Y";
        }
        if (n2 % 30 == 0) {
            return n2 / 30 + "M";
        }
        if (n2 % 7 == 0) {
            return n2 / 7 + "W";
        }
        return n2 + "D";
    }

    public String toString() {
        return this.getName();
    }

    public int compareTo(BarSize barSize) {
        if (barSize == null) {
            return 1;
        }
        if (barSize == this) {
            return 0;
        }
        if (this.getType() == barSize.getType()) {
            if (this.getSizeMillis() < barSize.getSizeMillis()) {
                return -1;
            }
            if (this.getSizeMillis() > barSize.getSizeMillis()) {
                return 1;
            }
            if (this.isHybridRenko() || this.isOFAProbe()) {
                if (this.getReverseInterval() < barSize.getReverseInterval()) {
                    return -1;
                }
                if (this.getReverseInterval() > barSize.getReverseInterval()) {
                    return 1;
                }
                if (this.getIntervalMinutes() < barSize.getIntervalMinutes()) {
                    return -1;
                }
                if (this.getIntervalMinutes() > barSize.getIntervalMinutes()) {
                    return 1;
                }
            }
            if (this.isPointAndFigure()) {
                if (this.getReverseInterval() < barSize.getReverseInterval()) {
                    return -1;
                }
                if (this.getReverseInterval() > barSize.getReverseInterval()) {
                    return 1;
                }
                if (this.getIntervalMinutes() < barSize.getIntervalMinutes()) {
                    return -1;
                }
                if (this.getIntervalMinutes() > barSize.getIntervalMinutes()) {
                    return 1;
                }
            }
            if (this.isReversal()) {
                if (this.getReverseInterval() < barSize.getReverseInterval()) {
                    return -1;
                }
                if (this.getReverseInterval() > barSize.getReverseInterval()) {
                    return 1;
                }
                if (this.interval < barSize.interval) {
                    return -1;
                }
                if (this.interval > barSize.interval) {
                    return 1;
                }
            }
        } else {
            if (this.getType() == Enums$BarSizeType.LINEAR) {
                return 1;
            }
            if (barSize.getType() == Enums$BarSizeType.LINEAR) {
                return -1;
            }
        }
        return 0;
    }

    public static BarSize getBarSize(int n) {
        return BarSize.getBarSize(Enums$BarSizeType.LINEAR, n);
    }

    public static BarSize getBarSize(Enums$BarSizeType enums$BarSizeType, int n) {
        return BarSize.getBarSize(enums$BarSizeType, n, n);
    }

    public static BarSize getBarSize(Enums$BarSizeType enums$BarSizeType, int n, boolean bl) {
        return BarSize.getBarSize(enums$BarSizeType, n, n, bl);
    }

    public static BarSize getBarSize(Enums$BarSizeType enums$BarSizeType, Enums$IntervalType enums$IntervalType, int n) {
        return BarSize.getBarSize(enums$BarSizeType, enums$IntervalType, n, n);
    }

    public static BarSize getBarSize(Enums$BarSizeType enums$BarSizeType, Enums$IntervalType enums$IntervalType, int n, boolean bl) {
        int n2 = 0;
        if (h.a((Object)enums$BarSizeType, (Object[])new Object[]{Enums$BarSizeType.HYBRID_RENKO, Enums$BarSizeType.OFA})) {
            n2 = n;
        }
        return BarSize.getBarSize(enums$BarSizeType, enums$IntervalType, n, n2, bl);
    }

    public static BarSize getBarSize(Enums$BarSizeType enums$BarSizeType, int n, int n2) {
        return BarSize.getBarSize(enums$BarSizeType, n, n2, b.a().isIntervalPoints());
    }

    public static BarSize getBarSize(Enums$BarSizeType enums$BarSizeType, int n, int n2, boolean bl) {
        Enums$IntervalType enums$IntervalType = Enums$IntervalType.MINUTE;
        enums$IntervalType = enums$BarSizeType == Enums$BarSizeType.LINEAR ? Enums$IntervalType.MINUTE : (enums$BarSizeType == Enums$BarSizeType.CONSTANT_VOLUME ? Enums$IntervalType.VOLUME : (enums$BarSizeType == Enums$BarSizeType.TICK ? Enums$IntervalType.TICK : (bl ? Enums$IntervalType.POINT : Enums$IntervalType.TICK)));
        return BarSize.getBarSize(enums$BarSizeType, enums$IntervalType, n, n2, bl);
    }

    public static BarSize getBarSize(Enums$BarSizeType enums$BarSizeType, Enums$IntervalType enums$IntervalType, int n, int n2) {
        return BarSize.getBarSize(enums$BarSizeType, enums$IntervalType, n, n2, b.a().isIntervalPoints());
    }

    public static BarSize getBarSize(Enums$BarSizeType enums$BarSizeType, Enums$IntervalType enums$IntervalType, int n, int n2, boolean bl) {
        return BarSize._from(enums$BarSizeType, enums$IntervalType, n, n2, bl);
    }

    private static String get(String string, Object ... objectArray) {
        return Util.strings.get(string, objectArray);
    }

    private static String _genKey(Enums$BarSizeType enums$BarSizeType, Enums$IntervalType enums$IntervalType, int n, int n2) {
        if (enums$BarSizeType == Enums$BarSizeType.LINEAR) {
            if (enums$IntervalType == Enums$IntervalType.MINUTE && n % 1440 == 0) {
                n /= 1440;
                enums$IntervalType = Enums$IntervalType.DAY;
            } else if (enums$IntervalType == Enums$IntervalType.MINUTE && n % 60 == 0) {
                n /= 60;
                enums$IntervalType = Enums$IntervalType.HOUR;
            } else if (enums$IntervalType == Enums$IntervalType.SECOND && n % 60 == 0) {
                n /= 60;
                enums$IntervalType = Enums$IntervalType.MINUTE;
            } else if (enums$IntervalType == Enums$IntervalType.MILLISECOND && n % 1000 == 0) {
                n /= 1000;
                enums$IntervalType = Enums$IntervalType.SECOND;
            } else if (enums$IntervalType == Enums$IntervalType.MILLISECOND && n % 60000 == 0) {
                n /= 60000;
                enums$IntervalType = Enums$IntervalType.MINUTE;
            }
            return enums$BarSizeType.getShortCode() + ":" + enums$IntervalType.getShortCode() + ":" + n;
        }
        if (n2 > 0) {
            return enums$BarSizeType.getShortCode() + ":" + n + ":" + n2;
        }
        return enums$BarSizeType.getShortCode() + ":" + n;
    }

    static BarSize _from(Enums$BarSizeType enums$BarSizeType, Enums$IntervalType enums$IntervalType, int n, int n2) {
        return BarSize._from(enums$BarSizeType, enums$IntervalType, n, n2, false);
    }

    static BarSize _from(Enums$BarSizeType enums$BarSizeType, Enums$IntervalType enums$IntervalType, int n, int n2, boolean bl) {
        String string;
        BarSize barSize;
        if (!h.a((Object)enums$BarSizeType, (Object[])new Object[]{Enums$BarSizeType.HYBRID_RENKO, Enums$BarSizeType.OFA, Enums$BarSizeType.POINT_AND_FIGURE, Enums$BarSizeType.REVERSAL})) {
            n2 = 0;
        }
        if (h.a((Object)enums$BarSizeType, (Object[])new Object[]{Enums$BarSizeType.OFA, Enums$BarSizeType.OFA_LINEAR})) {
            return BarSize.minute(15);
        }
        if (enums$BarSizeType == Enums$BarSizeType.LINEAR && n <= 0) {
            n = 1;
        }
        if ((barSize = (BarSize)key2BarSize.get(string = BarSize._genKey(enums$BarSizeType, enums$IntervalType, n, n2))) == null) {
            barSize = new BarSize(enums$BarSizeType, enums$IntervalType, n, n2, bl);
            key2BarSize.put(string, barSize);
        }
        return barSize;
    }

    static BarSize fromLinear(Enums$IntervalType enums$IntervalType) {
        return BarSize.fromLinear(enums$IntervalType, -1);
    }

    static BarSize fromLinear(Enums$IntervalType enums$IntervalType, int n) {
        switch (enums$IntervalType) {
            case YEAR: {
                return BarSize.year(h.c((int)n, (int)1));
            }
            case MONTH: {
                return BarSize.month(h.c((int)n, (int)1));
            }
            case WEEK: {
                return BarSize.week(h.c((int)n, (int)1));
            }
            case DAY: {
                return BarSize.day(h.c((int)n, (int)1));
            }
            case HOUR: {
                return BarSize.hour(h.c((int)n, (int)1));
            }
            case MINUTE: {
                return BarSize.minute(n <= 0 ? 5 : n);
            }
            case SECOND: {
                return BarSize.second(n <= 0 ? 30 : n);
            }
            case MILLISECOND: {
                return BarSize.millisecond(n <= 0 ? 500 : n);
            }
        }
        return BarSize.minute(n <= 0 ? 5 : n);
    }

    static BarSize fromType(Enums$BarSizeType enums$BarSizeType) {
        return BarSize.fromType(enums$BarSizeType, -1, -1);
    }

    static BarSize fromType(Enums$BarSizeType enums$BarSizeType, int n) {
        return BarSize.fromType(enums$BarSizeType, n, -1);
    }

    static BarSize fromType(Enums$BarSizeType enums$BarSizeType, int n, int n2) {
        if (enums$BarSizeType == Enums$BarSizeType.LINEAR) {
            return BarSize.fromLinear(Enums$IntervalType.DAY, n <= 0 ? 1 : n);
        }
        int n3 = 1;
        int n4 = -1;
        switch (enums$BarSizeType) {
            case TICK: {
                n3 = 100;
                break;
            }
            case CONSTANT_VOLUME: {
                n3 = 100;
                break;
            }
            case REVERSAL: {
                n3 = 0;
                n4 = 4;
                break;
            }
            case RANGE: 
            case RENKO: {
                n3 = 4;
                break;
            }
            case HYBRID_RENKO: {
                n3 = 3;
                n4 = 8;
                break;
            }
            case POINT_AND_FIGURE: {
                n3 = 5;
                n4 = 3;
                break;
            }
            case LINE_BREAK: {
                n3 = 3;
                break;
            }
        }
        if (n <= 0) {
            n = n3;
        }
        if (n2 <= 0) {
            n2 = n4;
        }
        return BarSize._from(enums$BarSizeType, Enums$IntervalType.MILLISECOND, n, n2);
    }

    public static BarSize hour(int n) {
        if (n % 24 == 0) {
            return BarSize.day(n / 24);
        }
        return BarSize._from(Enums$BarSizeType.LINEAR, Enums$IntervalType.HOUR, n, -1);
    }

    public static BarSize minute(int n) {
        if (n % 525600 == 0) {
            return BarSize.year(n / 525600);
        }
        if (n % 43200 == 0) {
            return BarSize.month(n / 43200);
        }
        if (n % 10080 == 0) {
            return BarSize.week(n / 10080);
        }
        if (n % 1440 == 0) {
            return BarSize.day(n / 1440);
        }
        if (n % 60 == 0) {
            return BarSize.hour(n / 60);
        }
        return BarSize._from(Enums$BarSizeType.LINEAR, Enums$IntervalType.MINUTE, n, -1);
    }

    public static BarSize second(int n) {
        if (n % 60 == 0) {
            return BarSize.minute(n / 60);
        }
        return BarSize._from(Enums$BarSizeType.LINEAR, Enums$IntervalType.SECOND, n, -1);
    }

    public static BarSize millisecond(int n) {
        if (n % 1000 == 0) {
            return BarSize.second(n / 1000);
        }
        return BarSize._from(Enums$BarSizeType.LINEAR, Enums$IntervalType.MILLISECOND, n, -1);
    }

    public static BarSize day(int n) {
        if (n % 30 == 0) {
            return BarSize.week(n / 30);
        }
        if (n % 7 == 0) {
            return BarSize.week(n / 7);
        }
        return BarSize._from(Enums$BarSizeType.LINEAR, Enums$IntervalType.DAY, n, -1);
    }

    public static BarSize week(int n) {
        return BarSize._from(Enums$BarSizeType.LINEAR, Enums$IntervalType.WEEK, n, -1);
    }

    public static BarSize month(int n) {
        if (n % 12 == 0) {
            return BarSize.year(n / 12);
        }
        return BarSize._from(Enums$BarSizeType.LINEAR, Enums$IntervalType.MONTH, n, -1);
    }

    public static BarSize year(int n) {
        return BarSize._from(Enums$BarSizeType.LINEAR, Enums$IntervalType.YEAR, n, -1);
    }

    public static BarSize fromKey(String string) {
        String[] stringArray;
        BarSize barSize = (BarSize)key2BarSize.get(string);
        if (barSize != null) {
            return barSize;
        }
        if (string.indexOf(124) > 0) {
            string = h.a((String)string, (String)"|", (String)":");
        }
        if ((stringArray = string.split(":")).length < 2 || stringArray.length > 3) {
            h.a.warning("BarSize::fromKey() unknown bar size: " + string);
            h.c();
            return BarSize.minute(15);
        }
        Enums$BarSizeType enums$BarSizeType = Enums$BarSizeType.fromCode(stringArray[0]);
        if (enums$BarSizeType == Enums$BarSizeType.LINEAR) {
            if (stringArray.length != 3) {
                h.a.warning("BarSize::fromKey() unknown linear bar size: " + string);
                return BarSize.minute(15);
            }
            int n = h.b((String)stringArray[2]);
            if (n == 0) {
                System.err.println("0 interval!");
            }
            if (n <= 0) {
                n = 1;
            }
            return BarSize.fromLinear(Enums$IntervalType.fromShortCode(stringArray[1]), n);
        }
        return BarSize.fromType(enums$BarSizeType, h.b((String)stringArray[1]), stringArray.length == 3 ? h.b((String)stringArray[2]) : -1);
    }
}

