/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.sdk.common;

import com.motivewave.platform.sdk.common.AggregateFilter$1;
import com.motivewave.platform.sdk.common.AggregateFilter$2;
import com.motivewave.platform.sdk.common.Tick;
import com.motivewave.platform.sdk.common.TickOperation;

public class AggregateFilter
implements TickOperation,
Cloneable {
    private TickOperation aggByOrderOp;
    private TickOperation aggByPeriodOp;
    protected TickOperation op;
    protected long aggPeriod;
    protected long endTime = 0L;
    protected boolean aggregate = false;
    protected boolean checkMax = false;
    protected float minSize;
    protected float maxSize;
    private boolean aggregateByOrder = false;
    private boolean cancelled = false;
    protected TickOperation filterOp;
    protected Tick aggTick = null;
    protected long tickStart = 0L;

    public AggregateFilter(boolean bl, long l, float f, float f2, TickOperation tickOperation) {
        this.aggregateByOrder = bl;
        this.aggregate = l > 0L;
        this.minSize = f;
        this.maxSize = f2;
        this.aggPeriod = l;
        this.op = tickOperation;
        this.checkMax = f2 > 0.0f;
        this.reset();
    }

    public AggregateFilter withOp(TickOperation tickOperation) {
        AggregateFilter aggregateFilter = this.clone();
        aggregateFilter.setOperation(tickOperation);
        return aggregateFilter;
    }

    @Override
    public void onTick(Tick tick) {
        if (this.cancelled || this.endTime != 0L && tick.getTime() > this.endTime) {
            return;
        }
        if (this.aggregateByOrder) {
            this.aggByOrderOp.onTick(tick);
        } else {
            this.aggByPeriodOp.onTick(tick);
        }
    }

    public void setOperation(TickOperation tickOperation) {
        this.op = tickOperation;
    }

    public void reset() {
        this.aggByOrderOp = this.aggregateByOrder ? new AggregateFilter$1(this) : tick -> this.aggByPeriodOp.onTick(tick);
        this.aggByPeriodOp = this.aggPeriod > 0L ? new AggregateFilter$2(this) : tick -> this.filterOp.onTick(tick);
        this.filterOp = this.minSize > 0.0f || this.maxSize > 0.0f ? tick -> {
            float f = tick.getVolumeAsFloat();
            if (f >= this.minSize && (!this.checkMax || f <= this.maxSize)) {
                this.op.onTick(tick);
            }
        } : tick -> this.op.onTick(tick);
        this.tickStart = 0L;
        this.aggTick = null;
    }

    public AggregateFilter clone() {
        try {
            AggregateFilter aggregateFilter = (AggregateFilter)super.clone();
            aggregateFilter.reset();
            return aggregateFilter;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setCancelled(boolean bl) {
        this.cancelled = bl;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long l) {
        this.endTime = l;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        try {
            AggregateFilter aggregateFilter = (AggregateFilter)object;
            return this.aggPeriod == aggregateFilter.aggPeriod && this.aggregate == aggregateFilter.aggregate && this.minSize == aggregateFilter.minSize && this.maxSize == aggregateFilter.maxSize && this.aggregateByOrder == aggregateFilter.aggregateByOrder && this.endTime == aggregateFilter.endTime;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

