/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.ls_proxy;

import com.lightstreamer.ls_client.ExtendedTableInfo;
import com.lightstreamer.ls_client.SubscrException;
import com.lightstreamer.ls_proxy.Item;
import java.util.Arrays;

class SubscriptionInfo {
    private Item[] items;
    private String[] fields;

    SubscriptionInfo(Item[] items, String[] fields) {
        this.items = items;
        this.fields = fields;
    }

    Item[] getItems() {
        return this.items;
    }

    protected Item getItem(int i) {
        return this.items[i];
    }

    String getMode() {
        return this.items[0].getMode();
    }

    boolean isUnfiltered() {
        return this.items[0].isUnfiltered();
    }

    ExtendedTableInfo getInfo() {
        ExtendedTableInfo info;
        String[] names = new String[this.items.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.items[i].getName();
        }
        boolean snap = false;
        int snapLen = 0;
        String mode = this.getMode();
        if (mode == "MERGE" || mode == "COMMAND" && !this.isUnfiltered()) {
            snap = true;
        } else if (mode == "RAW" || mode == "COMMAND" && this.isUnfiltered()) {
            snap = false;
        } else if (mode == "DISTINCT") {
            snapLen = this.items[0].getDistinctSnapshotLength();
            snap = snapLen > 0;
        }
        try {
            info = new ExtendedTableInfo(names, mode, this.fields, snap);
            if (this.items[0].getSelector() != null) {
                info.setSelector(this.items[0].getSelector());
            }
            if (this.items[0].getDataAdapter() != null) {
                info.setDataAdapter(this.items[0].getDataAdapter());
            }
            if (this.items[0].isUnfiltered()) {
                info.requestUnfilteredDispatching();
            } else {
                Double maxFrequency;
                Integer bufferSize = this.items[0].getBufferSize();
                if (bufferSize != null) {
                    info.setRequestedBufferSize(bufferSize);
                }
                if ((maxFrequency = this.items[0].getMaxFrequency()) != null) {
                    info.setRequestedMaxFrequency(maxFrequency);
                }
            }
            if (snapLen > 0) {
                info.setRequestedDistinctSnapshotLength(snapLen);
            }
        }
        catch (SubscrException e) {
            return null;
        }
        return info;
    }

    String toFullString() {
        return this.getMode() + " items " + Arrays.asList(this.items) + " with fields " + Arrays.asList(this.fields);
    }

    public String toString() {
        return this.getMode() + " items " + Arrays.asList(this.items);
    }
}

