/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.ls_proxy;

import com.lightstreamer.ls_client.ConnectionConstraints;
import com.lightstreamer.ls_client.HandyTableListener;
import com.lightstreamer.ls_client.LSClient;
import com.lightstreamer.ls_client.PushConnException;
import com.lightstreamer.ls_client.PushServerException;
import com.lightstreamer.ls_client.PushUserException;
import com.lightstreamer.ls_client.SubscrException;
import com.lightstreamer.ls_client.SubscribedTableKey;
import com.lightstreamer.ls_client.UpdateInfo;
import com.lightstreamer.ls_proxy.Item;
import com.lightstreamer.ls_proxy.PushEvent;
import com.lightstreamer.ls_proxy.PushException;
import com.lightstreamer.ls_proxy.PushListener;
import com.lightstreamer.ls_proxy.SubscriptionInfo;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

class SubscrHandler {
    private final PushListener eventsListener;
    private final int phase;
    private final LSClient pushServerClient;
    private final LinkedList<ConnectionConstraints> constrainRequests = new LinkedList();
    private final Object constrainMutex = new Object();
    private static Logger subscrLogger = Logger.getLogger("com.lightstreamer.ls_proxy.subscriptions");

    SubscrHandler(int phase, LSClient pushServerClient, PushListener listener) {
        this.phase = phase;
        this.pushServerClient = pushServerClient;
        this.eventsListener = listener;
    }

    private boolean isConnected() {
        return this.pushServerClient != null;
    }

    void prepareBatch() {
        if (this.isConnected()) {
            subscrLogger.finer("Preparing for a requests batch");
            this.declareBatch();
        }
    }

    void completeBatch() {
        if (this.isConnected()) {
            subscrLogger.finer("Completing a requests batch");
            this.pushServerClient.unbatchRequest();
        }
    }

    private void declareBatch() {
        try {
            this.pushServerClient.batchRequests(1);
        }
        catch (SubscrException e) {
            subscrLogger.finer("Connection closed while batching a request");
        }
    }

    void doSubscr(Item[] items, String[] fields) {
        final SubscriptionInfo info = new SubscriptionInfo(items, fields);
        if (this.isConnected()) {
            this.declareBatch();
            ServerThread tmpThread = new ServerThread(){

                public void run() {
                    if (subscrLogger.isLoggable(Level.FINE)) {
                        subscrLogger.fine("subscribing " + info.toFullString());
                    }
                    this.subscr(info);
                }
            };
            tmpThread.start();
        } else {
            ServerThread tmpThread = new ServerThread(){

                public void run() {
                    this.ask(info);
                }
            };
            tmpThread.start();
        }
    }

    void doResubscr(final Item[] items, final SubscribedTableKey[] tableKeys, String[] fields) throws TableKeyException {
        final SubscriptionInfo info = new SubscriptionInfo(items, fields);
        if (this.isConnected()) {
            this.declareBatch();
            ServerThread tmpThread = new ServerThread(){

                public void run() {
                    if (subscrLogger.isLoggable(Level.FINE)) {
                        subscrLogger.fine("changing subscription for " + info.toFullString());
                    }
                    this.subscr(info);
                    SubscribedTableKey[] subscribedKeys = SubscrHandler.this.filterTableKeys(tableKeys);
                    if (subscrLogger.isLoggable(Level.FINE)) {
                        subscrLogger.fine("removing old subscription for " + info);
                        if (subscribedKeys != tableKeys) {
                            subscrLogger.fine("found items with failed subscription");
                        }
                    }
                    this.delete(items, subscribedKeys, false);
                }
            };
            tmpThread.start();
        } else {
            this.checkTableKeys(tableKeys);
            ServerThread tmpThread = new ServerThread(){

                public void run() {
                    this.ask(info);
                }
            };
            tmpThread.start();
        }
    }

    void doDelete(final Item[] items, final SubscribedTableKey[] tableKeys) throws TableKeyException {
        if (this.isConnected()) {
            this.declareBatch();
            ServerThread tmpThread = new ServerThread(){

                public void run() {
                    SubscribedTableKey[] subscribedKeys = SubscrHandler.this.filterTableKeys(tableKeys);
                    if (subscrLogger.isLoggable(Level.FINE)) {
                        subscrLogger.fine("removing subscription for " + new SubscriptionInfo(items, null));
                        if (subscribedKeys != tableKeys) {
                            subscrLogger.fine("found items with failed subscription");
                        }
                    }
                    this.delete(items, subscribedKeys, true);
                }
            };
            tmpThread.start();
        } else {
            this.checkTableKeys(tableKeys);
            ServerThread tmpThread = new ServerThread(){

                public void run() {
                    this.delete(items, null, true);
                }
            };
            tmpThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doConstrain(ConnectionConstraints constraints) {
        if (this.isConnected()) {
            LinkedList<ConnectionConstraints> linkedList = this.constrainRequests;
            synchronized (linkedList) {
                this.constrainRequests.addLast(constraints);
            }
            ServerThread tmpThread = new ServerThread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object = SubscrHandler.this.constrainMutex;
                    synchronized (object) {
                        ConnectionConstraints nextConstraints;
                        LinkedList linkedList = SubscrHandler.this.constrainRequests;
                        synchronized (linkedList) {
                            nextConstraints = (ConnectionConstraints)SubscrHandler.this.constrainRequests.removeFirst();
                        }
                        if (subscrLogger.isLoggable(Level.FINE)) {
                            subscrLogger.fine("applying constraints " + nextConstraints);
                        }
                        this.constrain(nextConstraints);
                    }
                }
            };
            tmpThread.start();
        }
    }

    private SubscribedTableKey[] filterTableKeys(SubscribedTableKey[] keys) {
        if (keys == null) {
            return keys;
        }
        int failed = 0;
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i] != null) continue;
            ++failed;
        }
        if (failed == 0) {
            return keys;
        }
        if (failed == keys.length) {
            return null;
        }
        SubscribedTableKey[] subscribedKeys = new SubscribedTableKey[keys.length - failed];
        int subscribed = 0;
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i] == null) continue;
            subscribedKeys[subscribed] = keys[i];
            ++subscribed;
        }
        return subscribedKeys;
    }

    private void checkTableKeys(SubscribedTableKey[] keys) throws TableKeyException {
        if (keys != null) {
            for (int i = 0; i < keys.length; ++i) {
                if (keys[i] == null) continue;
                throw new TableKeyException("key not allowed");
            }
        }
    }

    static class TableKeyException
    extends Exception {
        public TableKeyException(String msg) {
            super(msg);
        }
    }

    private abstract class ServerThread
    extends Thread {
        public ServerThread() {
            super("ServerThread");
        }

        protected void ask(SubscriptionInfo items) {
            SubscrHandler.this.eventsListener.onSubscr(SubscrHandler.this.phase, items.getItems(), null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void subscr(final SubscriptionInfo items) {
            HandyTableListener listener;
            int num = items.getItems().length;
            final SubscribedTableKey[] tableKeys = new SubscribedTableKey[num];
            HandyTableListener handyTableListener = listener = new HandyTableListener(){

                public synchronized void onUpdate(int itemPos, String itemName, UpdateInfo update) {
                    Item item = items.getItem(itemPos - 1);
                    PushEvent event = new PushEvent(item, update);
                    event.setSubscrKey(tableKeys[itemPos - 1]);
                    if (subscrLogger.isLoggable(Level.FINEST)) {
                        subscrLogger.finest("Received " + event);
                    }
                    SubscrHandler.this.eventsListener.onValues(SubscrHandler.this.phase, event);
                }

                public synchronized void onSnapshotEnd(int itemPos, String itemName) {
                    Item item = items.getItem(itemPos - 1);
                    PushEvent event = new PushEvent(item);
                    event.setSubscrKey(tableKeys[itemPos - 1]);
                    if (subscrLogger.isLoggable(Level.FINEST)) {
                        subscrLogger.finest("Received end of snapshot marker for " + item);
                    }
                    SubscrHandler.this.eventsListener.onSnapshotEnd(SubscrHandler.this.phase, event);
                }

                public synchronized void onRawUpdatesLost(int itemPos, String itemName, int lostUpdates) {
                    Item item = items.getItem(itemPos - 1);
                    PushEvent lostUpdatesEvent = new PushEvent(item, lostUpdates);
                    lostUpdatesEvent.setSubscrKey(tableKeys[itemPos - 1]);
                    if (subscrLogger.isLoggable(Level.FINEST)) {
                        subscrLogger.finest("Received lost update warning for " + item.toFullString());
                    }
                    SubscrHandler.this.eventsListener.onUpdatesLost(SubscrHandler.this.phase, lostUpdatesEvent);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onUnsubscr(int itemPos, String itemName) {
                    if (subscrLogger.isLoggable(Level.FINEST)) {
                        1 var3_3 = this;
                        synchronized (var3_3) {
                            subscrLogger.finest("Received unsubscription notify for " + items.getItem(itemPos - 1).toFullString());
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onUnsubscrAll() {
                    if (subscrLogger.isLoggable(Level.FINEST)) {
                        1 var1_1 = this;
                        synchronized (var1_1) {
                            subscrLogger.finest("Received unsubscription notify for all items");
                        }
                    }
                }
            };
            synchronized (handyTableListener) {
                PushException pushError = null;
                try {
                    SubscribedTableKey[] keys = SubscrHandler.this.pushServerClient.subscribeItems(items.getInfo(), listener);
                    System.arraycopy(keys, 0, tableKeys, 0, num);
                }
                catch (SubscrException e) {
                    subscrLogger.fine("Connection closed while trying a subscription");
                }
                catch (PushServerException e) {
                    pushError = new PushException(e);
                }
                catch (PushUserException e) {
                    pushError = new PushException(e);
                }
                catch (PushConnException e) {
                    pushError = new PushException(e);
                }
                if (pushError == null) {
                    subscrLogger.fine("Subscription request successful");
                    SubscrHandler.this.eventsListener.onSubscr(SubscrHandler.this.phase, items.getItems(), tableKeys);
                } else {
                    subscrLogger.log(Level.FINER, "Subscription request unsuccessful", pushError);
                    SubscrHandler.this.eventsListener.onSubscrError(SubscrHandler.this.phase, items.getItems(), pushError);
                }
            }
        }

        protected void delete(Item[] items, SubscribedTableKey[] tableKeys, boolean notify) {
            try {
                if (tableKeys != null) {
                    SubscrHandler.this.pushServerClient.unsubscribeTables(tableKeys);
                }
            }
            catch (SubscrException e) {
                subscrLogger.fine("Connection closed while trying an unsubscription");
            }
            catch (PushServerException e) {
                subscrLogger.log(Level.FINER, "Unsubscription request unsuccessful; trying recovery", e);
                for (int i = 0; i < tableKeys.length; ++i) {
                    try {
                        SubscrHandler.this.pushServerClient.forceUnsubscribeTable(tableKeys[i]);
                        continue;
                    }
                    catch (Exception e1) {
                        subscrLogger.log(Level.FINER, "Recovery attemp failed", e);
                    }
                }
            }
            catch (PushConnException e) {
                subscrLogger.log(Level.FINER, "Unsubscription request unsuccessful; possible garbage subscriptions left if the Server is still alive", e);
            }
            if (notify) {
                SubscrHandler.this.eventsListener.onDelete(SubscrHandler.this.phase, items);
            }
        }

        void constrain(ConnectionConstraints constraints) {
            PushException pushError = null;
            try {
                SubscrHandler.this.pushServerClient.changeConstraints(constraints);
            }
            catch (PushServerException e) {
                pushError = new PushException(e);
            }
            catch (PushConnException e) {
                pushError = new PushException(e);
            }
            if (pushError == null) {
                subscrLogger.fine("Constraints request successful");
            } else {
                subscrLogger.log(Level.FINER, "Constraints request unsuccessful", pushError);
            }
        }
    }
}

