/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.ls_proxy;

import com.lightstreamer.ls_proxy.FieldData;
import com.lightstreamer.ls_proxy.Item;
import com.lightstreamer.ls_proxy.ItemUpdateEvent;
import com.lightstreamer.ls_proxy.PushEvent;
import com.lightstreamer.ls_proxy.PushException;
import com.lightstreamer.ls_proxy.PushUpdateException;
import com.lightstreamer.ls_proxy.RequestException;
import com.lightstreamer.ls_proxy.SchemaData;
import com.lightstreamer.ls_proxy.UpdateEvent;
import com.lightstreamer.ls_proxy.UpdateListener;
import java.util.Iterator;

class SchemaRawData
extends SchemaData {
    private boolean subscrNeeded = false;

    SchemaRawData() {
    }

    protected FieldData createNewFieldData(String fieldName) {
        return new FieldData(fieldName);
    }

    boolean canExtract() {
        return false;
    }

    boolean canRestart() {
        return false;
    }

    void addListenerToFields(UpdateListener listener, String[] schema) throws RequestException {
        super.addListenerToFields(listener, schema);
        for (int i = 0; i < schema.length; ++i) {
            FieldData field = (FieldData)this.fields.get(schema[i]);
            if (field.isSynched()) continue;
            this.subscrNeeded = true;
            break;
        }
    }

    void removeListenerFromFields(UpdateListener listener, String[] schema) throws RequestException {
        super.removeListenerFromFields(listener, schema);
    }

    boolean isSynched() {
        return super.isSynched() || !this.subscrNeeded;
    }

    boolean confirmSubscr() {
        this.subscrNeeded = false;
        return super.confirmSubscr();
    }

    void clearSubscr() {
        super.clearSubscr();
        for (FieldData field : this.fields.values()) {
            if (field.isSynched()) continue;
            this.subscrNeeded = true;
            break;
        }
    }

    UpdateEvent[] update(Item item, PushEvent serverEvent) {
        ItemUpdateEvent listenersEvent = new ItemUpdateEvent(item);
        SchemaData.PushingFieldsIterator currValues = new SchemaData.PushingFieldsIterator();
        Iterator<String> newValues = serverEvent.getIterator();
        boolean empty = true;
        while (currValues.hasNext()) {
            FieldData field = currValues.next();
            String newValue = newValues.next();
            String fieldName = field.getName();
            if (newValue == serverEvent.getUnchangedSignal()) {
                listenersEvent.setUnchanged(fieldName, field.getValue());
                continue;
            }
            boolean changed = field.update(newValue);
            if (changed) {
                listenersEvent.setChanged(fieldName, newValue);
                empty = false;
                continue;
            }
            listenersEvent.setUnchanged(fieldName, newValue);
        }
        if (empty) {
            return noEvents;
        }
        return new UpdateEvent[]{listenersEvent};
    }

    UpdateEvent[] endOfSnapshot(Item item) throws PushException {
        throw new PushException(new PushUpdateException(4));
    }

    UpdateEvent[] getSnapshot(Item item) {
        return noEvents;
    }
}

