/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.ls_proxy;

import com.lightstreamer.ls_proxy.FieldData;
import com.lightstreamer.ls_proxy.Item;
import com.lightstreamer.ls_proxy.ItemUpdateEvent;
import com.lightstreamer.ls_proxy.PushEvent;
import com.lightstreamer.ls_proxy.PushException;
import com.lightstreamer.ls_proxy.PushUpdateException;
import com.lightstreamer.ls_proxy.SchemaData;
import com.lightstreamer.ls_proxy.SnapshotEvent;
import com.lightstreamer.ls_proxy.UpdateEvent;
import java.util.Iterator;

class SchemaMergeData
extends SchemaData {
    private boolean unfiltered;

    SchemaMergeData(boolean unfiltered) {
        this.unfiltered = unfiltered;
    }

    protected FieldData createNewFieldData(String fieldName) {
        return new FieldData(fieldName);
    }

    boolean canExtract() {
        return !this.unfiltered;
    }

    boolean canRestart() {
        return !this.unfiltered;
    }

    UpdateEvent[] update(Item item, PushEvent serverEvent) throws PushException {
        ItemUpdateEvent listenersEvent = new ItemUpdateEvent(item);
        SchemaData.PushingFieldsIterator currValues = new SchemaData.PushingFieldsIterator();
        Iterator<String> newValues = serverEvent.getIterator();
        boolean empty = true;
        while (currValues.hasNext()) {
            FieldData field = currValues.next();
            String newValue = newValues.next();
            String fieldName = field.getName();
            if (newValue == serverEvent.getUnchangedSignal()) {
                listenersEvent.setUnchanged(fieldName, field.getValue());
                continue;
            }
            boolean changed = field.update(newValue);
            if (changed) {
                listenersEvent.setChanged(fieldName, newValue);
                empty = false;
                continue;
            }
            listenersEvent.setUnchanged(fieldName, newValue);
        }
        if (empty) {
            return noEvents;
        }
        return new UpdateEvent[]{listenersEvent};
    }

    UpdateEvent[] endOfSnapshot(Item item) throws PushException {
        throw new PushException(new PushUpdateException(4));
    }

    UpdateEvent[] getSnapshot(Item item) {
        SnapshotEvent listenersEvent = new SnapshotEvent(item);
        SchemaData.PushingFieldsIterator currValues = new SchemaData.PushingFieldsIterator();
        boolean empty = true;
        while (currValues.hasNext()) {
            FieldData field = currValues.next();
            String value = field.getValue();
            if (value != null) {
                empty = false;
            }
            listenersEvent.add(field.getName(), value);
        }
        if (empty) {
            return noEvents;
        }
        return new UpdateEvent[]{listenersEvent};
    }
}

