/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.ls_proxy;

import com.lightstreamer.ls_proxy.FieldData;
import com.lightstreamer.ls_proxy.Item;
import com.lightstreamer.ls_proxy.PushEvent;
import com.lightstreamer.ls_proxy.PushException;
import com.lightstreamer.ls_proxy.PushUpdateException;
import com.lightstreamer.ls_proxy.SchemaData;
import com.lightstreamer.ls_proxy.SnapshotEvent;
import com.lightstreamer.ls_proxy.UpdateEvent;
import java.util.ArrayList;
import java.util.Iterator;

class SchemaDistinctData
extends SchemaData {
    private int bufferDim;
    private boolean unfiltered;
    protected int historyDim;

    SchemaDistinctData(int bufferDim, boolean unfiltered) {
        this.bufferDim = bufferDim;
        this.unfiltered = unfiltered;
        this.historyDim = 0;
    }

    boolean canExtract() {
        return false;
    }

    boolean canRestart() {
        return !this.unfiltered;
    }

    protected FieldData createNewFieldData(String fieldName) {
        return new FieldDataWithHistory(fieldName, this.historyDim);
    }

    UpdateEvent[] update(Item item, PushEvent serverEvent) {
        this.cacheValues(serverEvent);
        this.appendCachedValues();
        SnapshotEvent listenersEvent = new SnapshotEvent(item);
        this.extractRow(this.historyDim - 1, listenersEvent);
        if (this.historyDim > this.bufferDim) {
            this.deleteRow(0);
        }
        return new UpdateEvent[]{listenersEvent};
    }

    protected void cacheValues(PushEvent serverEvent) {
        SchemaData.PushingFieldsIterator currValues = new SchemaData.PushingFieldsIterator();
        Iterator<String> newValues = serverEvent.getIterator();
        while (currValues.hasNext()) {
            FieldData field = currValues.next();
            String newValue = newValues.next();
            if (newValue == serverEvent.getUnchangedSignal()) continue;
            field.update(newValue);
        }
    }

    protected void appendCachedValues() {
        for (FieldDataWithHistory field : this.fields.values()) {
            ArrayList history = field.getHistory();
            if (field.isActive(false)) {
                history.add(field.getValue());
                continue;
            }
            history.add(null);
        }
        ++this.historyDim;
    }

    protected void deleteRow(int row) {
        for (FieldDataWithHistory field : this.fields.values()) {
            ArrayList history = field.getHistory();
            history.remove(row);
        }
        --this.historyDim;
    }

    UpdateEvent[] getSnapshot(Item item) {
        UpdateEvent[] events = new SnapshotEvent[this.historyDim];
        for (int i = 0; i < this.historyDim; ++i) {
            SnapshotEvent listenersEvent = new SnapshotEvent(item);
            this.extractRow(i, listenersEvent);
            events[i] = listenersEvent;
        }
        return events;
    }

    private void extractRow(int pos, SnapshotEvent listenersEvent) {
        SchemaData.PushingFieldsIterator currValues = new SchemaData.PushingFieldsIterator();
        while (currValues.hasNext()) {
            FieldDataWithHistory field = (FieldDataWithHistory)currValues.next();
            ArrayList history = field.getHistory();
            String value = (String)history.get(pos);
            listenersEvent.add(field.getName(), value);
        }
    }

    void onRestart(Item item) throws PushException {
        super.onRestart(item);
        if (this.bufferDim == 0) {
            throw new PushException(new PushUpdateException(2, item.getName()));
        }
        throw new PushException(new PushUpdateException(3, item.getName()));
    }

    protected static class FieldDataWithHistory
    extends FieldData {
        private ArrayList history = new ArrayList();

        public FieldDataWithHistory(String fieldName, int actualDim) {
            super(fieldName);
            for (int i = 0; i < actualDim; ++i) {
                this.history.add(null);
            }
        }

        public ArrayList getHistory() {
            return this.history;
        }
    }
}

