/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.ls_proxy;

import com.lightstreamer.ls_proxy.FieldData;
import com.lightstreamer.ls_proxy.Item;
import com.lightstreamer.ls_proxy.PushEvent;
import com.lightstreamer.ls_proxy.PushException;
import com.lightstreamer.ls_proxy.PushUpdateException;
import com.lightstreamer.ls_proxy.RequestException;
import com.lightstreamer.ls_proxy.SnapshotEvent;
import com.lightstreamer.ls_proxy.UpdateEvent;
import com.lightstreamer.ls_proxy.UpdateListener;
import java.text.CollationKey;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;

abstract class SchemaData {
    private static Collator collator = Collator.getInstance();
    private CollationKey[] usedFieldsBuf = null;
    protected TreeMap fields = new TreeMap();
    protected static final UpdateEvent[] noEvents = new UpdateEvent[0];
    private int unsynchedFields = 0;
    private boolean snapshotCompleted = false;
    protected static final UpdateEvent EOS_EVENT = new SnapshotEvent(null);

    SchemaData() {
    }

    abstract FieldData createNewFieldData(String var1);

    abstract boolean canExtract();

    abstract boolean canRestart();

    void addListenerToFields(UpdateListener listener, String[] schema) throws RequestException {
        for (int i = 0; i < schema.length; ++i) {
            FieldData field = (FieldData)this.fields.get(schema[i]);
            if (field == null) {
                field = this.createNewFieldData(schema[i]);
                this.fields.put(schema[i], field);
            }
            this.unsynchedFields -= field.isSynched() ? 0 : 1;
            field.addListener(listener);
            this.unsynchedFields += field.isSynched() ? 0 : 1;
        }
    }

    void removeListenerFromFields(UpdateListener listener, String[] schema) throws RequestException {
        for (int i = 0; i < schema.length; ++i) {
            FieldData field = (FieldData)this.fields.get(schema[i]);
            if (field == null || !field.isUsed()) {
                throw new RequestException(3);
            }
            this.unsynchedFields -= field.isSynched() ? 0 : 1;
            field.removeListener(listener);
            this.unsynchedFields += field.isSynched() ? 0 : 1;
        }
    }

    boolean isSynched() {
        return this.unsynchedFields == 0;
    }

    boolean confirmSubscr() {
        boolean pushing = false;
        this.unsynchedFields = 0;
        for (FieldData field : this.fields.values()) {
            field.confirmSubscr();
            this.unsynchedFields += field.isSynched() ? 0 : 1;
            if (!field.isActive(false)) continue;
            pushing = true;
        }
        return pushing;
    }

    void clearSubscr() {
        this.unsynchedFields = 0;
        for (FieldData field : this.fields.values()) {
            field.clearSubscr();
            this.unsynchedFields += field.isSynched() ? 0 : 1;
        }
    }

    final boolean isEmpty(boolean alsoPotentially) {
        for (FieldData field : this.fields.values()) {
            if (field == null || !field.isActive(alsoPotentially)) continue;
            return false;
        }
        return true;
    }

    final boolean isSubset(String[] schema, boolean alsoPotentially) {
        for (int i = 0; i < schema.length; ++i) {
            FieldData field = (FieldData)this.fields.get(schema[i]);
            if (field != null && field.isActive(alsoPotentially)) continue;
            return false;
        }
        return true;
    }

    final boolean isInters(String[] schema, boolean alsoPotentially) {
        for (int i = 0; i < schema.length; ++i) {
            FieldData field = (FieldData)this.fields.get(schema[i]);
            if (field == null || !field.isActive(alsoPotentially)) continue;
            return true;
        }
        return false;
    }

    final void prepareForSubscr() {
        ArrayList<CollationKey> buf = new ArrayList<CollationKey>(this.fields.size());
        for (FieldData field : this.fields.values()) {
            field.prepareForSubscr();
            if (!field.isUsed()) continue;
            CollationKey key = collator.getCollationKey(field.getName());
            buf.add(key);
        }
        this.usedFieldsBuf = buf.toArray(new CollationKey[buf.size()]);
    }

    final void doneSubscr() {
        this.usedFieldsBuf = null;
    }

    abstract UpdateEvent[] update(Item var1, PushEvent var2) throws PushException;

    UpdateEvent[] endOfSnapshot(Item item) throws PushException {
        if (this.snapshotCompleted) {
            return noEvents;
        }
        this.snapshotCompleted = true;
        return new UpdateEvent[]{EOS_EVENT};
    }

    boolean isSnapshotCompleted() {
        return this.snapshotCompleted;
    }

    abstract UpdateEvent[] getSnapshot(Item var1);

    void onRestart(Item item) throws PushException {
        if (!this.canRestart()) {
            throw new PushException(new PushUpdateException(2, item.getName()));
        }
    }

    final boolean needsSubscr() {
        return this.usedFieldsBuf.length > 0;
    }

    final String[] getUsedFields() {
        String[] result = new String[this.usedFieldsBuf.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.usedFieldsBuf[i].getSourceString();
        }
        return result;
    }

    static final int compare(SchemaData s1, SchemaData s2) {
        CollationKey[] a1 = s1.usedFieldsBuf;
        CollationKey[] a2 = s2.usedFieldsBuf;
        int sizeDiff = a1.length - a2.length;
        if (sizeDiff != 0) {
            return sizeDiff;
        }
        for (int i = 0; i < a1.length; ++i) {
            int elemDiff = a1[i].compareTo(a2[i]);
            if (elemDiff == 0) continue;
            return elemDiff;
        }
        return 0;
    }

    protected final class PushingFieldsIterator {
        private Iterator fieldsIterator;
        private FieldData nextData;

        public PushingFieldsIterator() {
            this.fieldsIterator = SchemaData.this.fields.values().iterator();
            this.nextData = this.getNext();
        }

        public boolean hasNext() {
            return this.nextData != null;
        }

        public FieldData next() {
            FieldData tmp = this.nextData;
            this.nextData = this.getNext();
            return tmp;
        }

        private FieldData getNext() {
            while (this.fieldsIterator.hasNext()) {
                FieldData data = (FieldData)this.fieldsIterator.next();
                if (!data.isActive(false)) continue;
                return data;
            }
            return null;
        }
    }
}

