/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.ls_proxy;

import com.lightstreamer.ls_proxy.FieldData;
import com.lightstreamer.ls_proxy.Item;
import com.lightstreamer.ls_proxy.ItemUpdateEvent;
import com.lightstreamer.ls_proxy.PushEvent;
import com.lightstreamer.ls_proxy.PushException;
import com.lightstreamer.ls_proxy.PushUpdateException;
import com.lightstreamer.ls_proxy.RequestException;
import com.lightstreamer.ls_proxy.SchemaData;
import com.lightstreamer.ls_proxy.SnapshotEvent;
import com.lightstreamer.ls_proxy.UpdateEvent;
import com.lightstreamer.ls_proxy.UpdateListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

class SchemaCommandMatchData
extends SchemaData {
    protected HashMap keys = new HashMap();
    private long prog = 0L;
    private ArrayList deferredDeletes = null;
    private Long deferredDeletesProg = null;
    private static Logger eventsLogger = Logger.getLogger("com.lightstreamer.ls_proxy.events");

    SchemaCommandMatchData() {
    }

    private Long getNewProg() {
        ++this.prog;
        return new Long(this.prog);
    }

    boolean canExtract() {
        return false;
    }

    boolean canRestart() {
        return true;
    }

    protected FieldData createNewFieldData(String fieldName) {
        return new FieldDataWithKeys(fieldName);
    }

    private void checkMandatoryFields() throws RequestException {
        FieldData opData = (FieldData)this.fields.get("command");
        FieldData keyData = (FieldData)this.fields.get("key");
        if (opData != null && opData.isUsed() && keyData != null && keyData.isUsed()) {
            return;
        }
        boolean used = false;
        for (FieldData field : this.fields.values()) {
            if (!field.isUsed()) continue;
            used = true;
            break;
        }
        if (used) {
            if (opData == null || !opData.isUsed()) {
                throw new RequestException(7, "command");
            }
            throw new RequestException(7, "key");
        }
    }

    void addListenerToFields(UpdateListener listener, String[] schema) throws RequestException {
        super.addListenerToFields(listener, schema);
        this.checkMandatoryFields();
    }

    void removeListenerFromFields(UpdateListener listener, String[] schema) throws RequestException {
        super.removeListenerFromFields(listener, schema);
        this.checkMandatoryFields();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UpdateEvent[] update(Item item, PushEvent serverEvent) throws PushException {
        HashMap hashMap = this.keys;
        synchronized (hashMap) {
            this.cacheValues(serverEvent);
            FieldData opData = (FieldData)this.fields.get("command");
            FieldData keyData = (FieldData)this.fields.get("key");
            String op = opData.getValue();
            String key = keyData.getValue();
            if (op == null) {
                throw new PushException(new PushUpdateException(1, "null command"));
            }
            if (key == null) {
                throw new PushException(new PushUpdateException(1, "null key"));
            }
            UpdateEvent listenersEvent = this.mergeCachedValues(key, op, item);
            if (listenersEvent != null) {
                return new UpdateEvent[]{listenersEvent};
            }
            return noEvents;
        }
    }

    protected void cacheValues(PushEvent serverEvent) {
        SchemaData.PushingFieldsIterator currValues = new SchemaData.PushingFieldsIterator(this);
        Iterator<String> newValues = serverEvent.getIterator();
        while (currValues.hasNext()) {
            FieldData field = currValues.next();
            String newValue = newValues.next();
            if (newValue == serverEvent.getUnchangedSignal()) continue;
            field.update(newValue);
        }
    }

    protected UpdateEvent mergeCachedValues(String key, String op, Item item) {
        if (op.equals("DELETE")) {
            if (this.keys.containsKey(key)) {
                this.keys.remove(key);
                this.removeKey(key);
                SnapshotEvent event = new SnapshotEvent(item);
                event.add("key", key);
                event.add("command", "DELETE");
                return event;
            }
            return null;
        }
        FieldData opData = (FieldData)this.fields.get("command");
        opData.update("ADD");
        if (this.keys.containsKey(key)) {
            this.keys.put(key, this.getNewProg());
            ItemUpdateEvent event = new ItemUpdateEvent(item);
            if (this.updateCachedValues(key, event)) {
                event.setChanged("key", key);
                event.setChanged("command", "UPDATE");
                return event;
            }
            return null;
        }
        this.keys.put(key, this.getNewProg());
        SnapshotEvent event = new SnapshotEvent(item);
        this.addCachedValues(key, event);
        return event;
    }

    private void addCachedValues(String key, SnapshotEvent listenersEvent) {
        SchemaData.PushingFieldsIterator currValues = new SchemaData.PushingFieldsIterator(this);
        while (currValues.hasNext()) {
            FieldDataWithKeys field = (FieldDataWithKeys)currValues.next();
            HashMap keyData = field.getKeysData();
            keyData.put(key, field.getValue());
            listenersEvent.add(field.getName(), field.getValue());
        }
    }

    private boolean updateCachedValues(String key, ItemUpdateEvent listenersEvent) {
        SchemaData.PushingFieldsIterator currValues = new SchemaData.PushingFieldsIterator(this);
        boolean somethingChanged = false;
        while (currValues.hasNext()) {
            boolean changed;
            FieldDataWithKeys field = (FieldDataWithKeys)currValues.next();
            HashMap keyData = field.getKeysData();
            String oldValue = (String)keyData.get(key);
            String newValue = field.getValue();
            if (oldValue == null || newValue == null) {
                changed = oldValue != null || newValue != null;
            } else {
                boolean bl = changed = !oldValue.equals(newValue);
            }
            if (changed) {
                keyData.put(key, newValue);
                listenersEvent.setChanged(field.getName(), newValue);
                somethingChanged = true;
                continue;
            }
            listenersEvent.setUnchanged(field.getName(), newValue);
        }
        return somethingChanged;
    }

    private void removeKey(String key) {
        for (FieldDataWithKeys field : this.fields.values()) {
            HashMap keyData = field.getKeysData();
            keyData.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UpdateEvent[] getSnapshot(Item item) {
        HashMap hashMap = this.keys;
        synchronized (hashMap) {
            UpdateEvent[] events = new SnapshotEvent[this.keys.size()];
            Iterator iter = this.keys.keySet().iterator();
            int i = 0;
            while (iter.hasNext()) {
                String key = (String)iter.next();
                SnapshotEvent listenersEvent = new SnapshotEvent(item);
                SchemaData.PushingFieldsIterator currValues = new SchemaData.PushingFieldsIterator(this);
                while (currValues.hasNext()) {
                    FieldDataWithKeys field = (FieldDataWithKeys)currValues.next();
                    HashMap keyData = field.getKeysData();
                    String value = (String)keyData.get(key);
                    listenersEvent.add(field.getName(), value);
                }
                events[i] = listenersEvent;
                ++i;
            }
            return events;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onRestart(Item item) throws PushException {
        HashMap hashMap = this.keys;
        synchronized (hashMap) {
            this.deferredDeletes = new ArrayList();
            this.deferredDeletes.addAll(this.keys.keySet());
            this.deferredDeletesProg = this.getNewProg();
            if (eventsLogger.isLoggable(Level.FINER)) {
                eventsLogger.finer("About to receive a new snapshot for filtered COMMAND item " + item.toFullString());
            }
            if (eventsLogger.isLoggable(Level.FINER)) {
                eventsLogger.finer("Setting deferred deletion of old keys for " + item.toFullString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UpdateEvent[] endOfSnapshot(Item item) throws PushException {
        ArrayList<UpdateEvent> events = new ArrayList<UpdateEvent>();
        HashMap hashMap = this.keys;
        synchronized (hashMap) {
            if (this.deferredDeletes != null) {
                if (eventsLogger.isLoggable(Level.FINER)) {
                    eventsLogger.finer("Performing deferred deletion of old keys for " + item.toFullString());
                }
                for (String key : this.deferredDeletes) {
                    Long lastProg = (Long)this.keys.get(key);
                    if (lastProg == null || lastProg > this.deferredDeletesProg) continue;
                    this.keys.remove(key);
                    this.removeKey(key);
                    SnapshotEvent event = new SnapshotEvent(item);
                    event.add("key", key);
                    event.add("command", "DELETE");
                    events.add(event);
                }
                this.deferredDeletes = null;
                this.deferredDeletesProg = null;
            }
        }
        UpdateEvent[] base = super.endOfSnapshot(item);
        for (int i = 0; i < base.length; ++i) {
            events.add(base[i]);
        }
        return events.toArray(new UpdateEvent[events.size()]);
    }

    protected static class FieldDataWithKeys
    extends FieldData {
        private HashMap keysData = new HashMap();

        public FieldDataWithKeys(String fieldName) {
            super(fieldName);
        }

        public HashMap getKeysData() {
            return this.keysData;
        }
    }
}

