/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.ls_proxy;

import com.lightstreamer.ls_client.SubscribedTableKey;
import com.lightstreamer.ls_proxy.ConnectionHandler;
import com.lightstreamer.ls_proxy.Item;
import com.lightstreamer.ls_proxy.ItemData;
import com.lightstreamer.ls_proxy.SchemaData;
import com.lightstreamer.ls_proxy.SubscrHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

class ResubscrManager {
    private final ConnectionHandler connHandler;
    private final HashMap unsynchedItems = new HashMap();
    private static final SchemaComparator schemaComparator = new SchemaComparator();
    private static Logger stateLogger = Logger.getLogger("com.lightstreamer.ls_proxy.state");

    ResubscrManager(ConnectionHandler subscrHandler) {
        this.connHandler = subscrHandler;
    }

    void checkItem(ItemData itemData) {
        if (itemData.isChanging()) {
            if (stateLogger.isLoggable(Level.FINEST)) {
                stateLogger.finest(itemData.getItem().toFullString() + " currently in subscription; storing change request");
            }
            return;
        }
        Item item = itemData.getItem();
        boolean present = this.unsynchedItems.containsKey(item);
        boolean synched = itemData.isSynched();
        if (synched && present) {
            if (stateLogger.isLoggable(Level.FINEST)) {
                stateLogger.finest(itemData.getItem().toFullString() + " no longer to be changed");
            }
            this.unsynchedItems.remove(item);
        } else if (!synched && !present) {
            if (stateLogger.isLoggable(Level.FINEST)) {
                stateLogger.finest(itemData.getItem().toFullString() + " waiting to be changed");
            }
            this.unsynchedItems.put(item, itemData);
        } else if (stateLogger.isLoggable(Level.FINEST)) {
            if (present) {
                stateLogger.finest(itemData.getItem().toFullString() + " still waiting to be changed");
            } else {
                stateLogger.finest(itemData.getItem().toFullString() + " need not to be changed");
            }
        }
    }

    void removeItem(ItemData itemData) {
        Item item = itemData.getItem();
        Object val = this.unsynchedItems.remove(item);
        if (val != null && stateLogger.isLoggable(Level.FINEST)) {
            stateLogger.finest(itemData.getItem().toFullString() + " removed from items to be changed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doSubscr() {
        int maxSize = this.unsynchedItems.size();
        if (maxSize == 0) {
            return;
        }
        ArrayList<ItemData> itemsToDelete = new ArrayList<ItemData>(maxSize);
        ArrayList<ItemData> itemsToInsert = new ArrayList<ItemData>(maxSize);
        ArrayList<ItemData> itemsToChange = new ArrayList<ItemData>(maxSize);
        for (ItemData item : this.unsynchedItems.values()) {
            item.prepareForSubscr();
            if (!item.isActive()) {
                if (stateLogger.isLoggable(Level.FINEST)) {
                    stateLogger.finest("preparing subscription for " + item.getItem().toFullString());
                }
                itemsToInsert.add(item);
                continue;
            }
            if (item.getSchema().needsSubscr()) {
                if (stateLogger.isLoggable(Level.FINEST)) {
                    stateLogger.finest("preparing resubscription for " + item.getItem().toFullString());
                }
                itemsToChange.add(item);
                continue;
            }
            if (stateLogger.isLoggable(Level.FINEST)) {
                stateLogger.finest("preparing unsubscription for " + item.getItem().toFullString());
            }
            itemsToDelete.add(item);
        }
        this.connHandler.prepareBatch();
        try {
            this.sendBatch(itemsToDelete, itemsToInsert, itemsToChange);
        }
        finally {
            this.connHandler.completeBatch();
        }
        for (ItemData item : this.unsynchedItems.values()) {
            item.doneSubscr();
        }
        this.unsynchedItems.clear();
    }

    private void sendBatch(ArrayList itemsToDelete, ArrayList itemsToInsert, ArrayList itemsToChange) {
        int size;
        if (itemsToInsert.size() > 0) {
            MyCollector collectorI = new MyCollector(itemsToInsert);
            while (collectorI.hasNext()) {
                this.connHandler.doSubscr(collectorI.getItems(), collectorI.getUsedSchema());
            }
        }
        if (itemsToChange.size() > 0) {
            MyCollector collectorC = new MyCollector(itemsToChange);
            while (collectorC.hasNext()) {
                try {
                    this.connHandler.doResubscr(collectorC.getItems(), collectorC.getSubscrKeys(), collectorC.getUsedSchema());
                }
                catch (SubscrHandler.TableKeyException e) {
                    stateLogger.severe("Unexpected error in subscription preparation");
                    stateLogger.log(Level.FINER, "Unexpected error in subscription preparation", e);
                }
            }
        }
        if ((size = itemsToDelete.size()) > 0) {
            try {
                this.connHandler.doDelete(this.getItems(itemsToDelete, 0, size), this.getSubscrKeys(itemsToDelete, 0, size));
            }
            catch (SubscrHandler.TableKeyException e) {
                stateLogger.severe("Unexpected error in unsubscription preparation");
                stateLogger.log(Level.FINER, "Unexpected error in unsubscription preparation", e);
            }
        }
    }

    private Item[] getItems(ArrayList list, int start, int end) {
        Item[] results = new Item[end - start];
        for (int i = start; i < end; ++i) {
            ItemData item = (ItemData)list.get(i);
            results[i - start] = item.getItem();
        }
        return results;
    }

    private SubscribedTableKey[] getSubscrKeys(ArrayList list, int start, int end) {
        SubscribedTableKey[] results = new SubscribedTableKey[end - start];
        for (int i = start; i < end; ++i) {
            ItemData item = (ItemData)list.get(i);
            results[i - start] = item.getSubscrKey();
        }
        return results;
    }

    private static class SchemaComparator
    implements Comparator {
        private SchemaComparator() {
        }

        public int compare(Object o1, Object o2) {
            Item i2;
            SchemaData s1 = ((ItemData)o1).getSchema();
            SchemaData s2 = ((ItemData)o2).getSchema();
            Item i1 = ((ItemData)o1).getItem();
            int modeDiff = Item.compareModes(i1, i2 = ((ItemData)o2).getItem());
            if (modeDiff != 0) {
                return modeDiff;
            }
            return SchemaData.compare(s1, s2);
        }
    }

    private class MyCollector {
        private ArrayList orderedList;
        private int start = 0;
        private int end = 0;

        public MyCollector(ArrayList list) {
            Collections.sort(list, schemaComparator);
            this.orderedList = list;
        }

        public boolean hasNext() {
            this.start = this.end++;
            if (this.start >= this.orderedList.size()) {
                return false;
            }
            ItemData firstItem = (ItemData)this.orderedList.get(this.start);
            while (this.end < this.orderedList.size()) {
                ItemData item = (ItemData)this.orderedList.get(this.end);
                if (schemaComparator.compare(firstItem, item) != 0) break;
                ++this.end;
            }
            return true;
        }

        public Item[] getItems() {
            return ResubscrManager.this.getItems(this.orderedList, this.start, this.end);
        }

        public SubscribedTableKey[] getSubscrKeys() {
            return ResubscrManager.this.getSubscrKeys(this.orderedList, this.start, this.end);
        }

        public String[] getUsedSchema() {
            ItemData firstItem = (ItemData)this.orderedList.get(this.start);
            return firstItem.getSchema().getUsedFields();
        }
    }
}

