/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.ls_proxy;

public class RequestException
extends Exception {
    public static final int REENTRANCE = 1;
    public static final int EXTENSION_NOT_ALLOWED = 2;
    public static final int FIELD_NOT_FOUND = 3;
    public static final int LISTENER_NOT_FOUND = 4;
    public static final int SCHEMA_ERROR = 5;
    public static final int ITEM_NOT_FOUND = 6;
    public static final int REQUIRED_FIELD_MISSING = 7;
    private static final String[] defaultMsgs = new String[]{"Unspecified error", "Reentrant request not allowed", "Subscription schema extension not allowed for the Item", "Field not currently subscribed", "Listener not currenty used", "Subscription schema not currently subscribed", "Item not currently subscribed to the supplied listener", "Required Field not currently subscribed"};
    private int errorCode;

    public RequestException(int errorCode) {
        super(RequestException.getMsg(errorCode, null));
        this.errorCode = errorCode;
    }

    public RequestException(int errorCode, String extraMsg) {
        super(RequestException.getMsg(errorCode, extraMsg));
        this.errorCode = errorCode;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    private static String getMsg(int errorCode, String extraMsg) {
        String msg = defaultMsgs[0];
        if (errorCode > 0 && errorCode < defaultMsgs.length) {
            msg = defaultMsgs[errorCode];
        }
        if (extraMsg != null) {
            msg = msg + ": " + extraMsg;
        }
        return msg;
    }
}

