/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.ls_proxy;

import com.lightstreamer.ls_client.SubscribedTableKey;
import com.lightstreamer.ls_proxy.ConnectionStateManager;
import com.lightstreamer.ls_proxy.Item;
import com.lightstreamer.ls_proxy.ItemsManager;
import com.lightstreamer.ls_proxy.PushEvent;
import com.lightstreamer.ls_proxy.PushException;
import com.lightstreamer.ls_proxy.UpdateListener;

class PushStateManager {
    private final ConnectionStateManager connState;
    private final ItemsManager itemsManager;

    PushStateManager(ConnectionStateManager connState, ItemsManager itemsManager) {
        this.connState = connState;
        this.itemsManager = itemsManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startTran() {
        ConnectionStateManager connectionStateManager = this.connState;
        synchronized (connectionStateManager) {
            this.itemsManager.startTran();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void endTran() {
        ConnectionStateManager connectionStateManager = this.connState;
        synchronized (connectionStateManager) {
            this.itemsManager.endTran();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TransStatus suspendTrans() {
        ConnectionStateManager connectionStateManager = this.connState;
        synchronized (connectionStateManager) {
            int trans = this.itemsManager.endTrans();
            return new TransStatus(trans);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyNewConnection() {
        ConnectionStateManager connectionStateManager = this.connState;
        synchronized (connectionStateManager) {
            this.itemsManager.startTran();
            try {
                this.itemsManager.redoSubscriptions();
            }
            finally {
                this.itemsManager.endTran();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyNewDisconnection() {
        ConnectionStateManager connectionStateManager = this.connState;
        synchronized (connectionStateManager) {
            this.itemsManager.startTran();
            try {
                this.itemsManager.redoSubscriptions();
            }
            finally {
                this.itemsManager.endTran();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addItems(UpdateListener itemListener, Item[] items, String[] schema) {
        ConnectionStateManager connectionStateManager = this.connState;
        synchronized (connectionStateManager) {
            this.itemsManager.startTran();
            try {
                for (int i = 0; i < items.length; ++i) {
                    this.itemsManager.addListener(itemListener, items[i], schema);
                }
            }
            finally {
                this.itemsManager.endTran();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeItems(UpdateListener itemListener, Item[] items, String[] schema) {
        ConnectionStateManager connectionStateManager = this.connState;
        synchronized (connectionStateManager) {
            this.itemsManager.startTran();
            try {
                for (int i = 0; i < items.length; ++i) {
                    this.itemsManager.removeListener(itemListener, items[i], schema);
                }
            }
            finally {
                this.itemsManager.endTran();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearItems() {
        ConnectionStateManager connectionStateManager = this.connState;
        synchronized (connectionStateManager) {
            this.itemsManager.startTran();
            try {
                this.itemsManager.clearSubscriptions();
            }
            finally {
                this.itemsManager.endTran();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifySubscr(int phase, Item[] items, SubscribedTableKey[] subscrKeys) {
        ConnectionStateManager connectionStateManager = this.connState;
        synchronized (connectionStateManager) {
            int i;
            if (!this.connState.checkPhase(phase)) {
                return;
            }
            for (i = 0; i < items.length; ++i) {
                if (subscrKeys == null) {
                    this.itemsManager.onSnapshot(items[i], null);
                    continue;
                }
                this.itemsManager.onSnapshot(items[i], subscrKeys[i]);
            }
            this.itemsManager.startTran();
            try {
                for (i = 0; i < items.length; ++i) {
                    this.itemsManager.onConfirm(items[i]);
                }
            }
            finally {
                this.itemsManager.endTran();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifySubscrError(int phase, Item[] items, PushException e) {
        ConnectionStateManager connectionStateManager = this.connState;
        synchronized (connectionStateManager) {
            if (!this.connState.checkPhase(phase)) {
                return;
            }
            this.notifySubscr(phase, items, null);
            for (int i = 0; i < items.length; ++i) {
                this.itemsManager.onSubscrError(items[i], e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendValues(int phase, PushEvent itemEvent) {
        ConnectionStateManager connectionStateManager = this.connState;
        synchronized (connectionStateManager) {
            if (!this.connState.checkPhase(phase)) {
                return;
            }
            this.itemsManager.onValues(itemEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifySnapshotEnd(int phase, PushEvent eosEvent) {
        ConnectionStateManager connectionStateManager = this.connState;
        synchronized (connectionStateManager) {
            if (!this.connState.checkPhase(phase)) {
                return;
            }
            this.itemsManager.onSnapshotEnd(eosEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyUpdatesLost(int phase, PushEvent lostUpdatesEvent) {
        ConnectionStateManager connectionStateManager = this.connState;
        synchronized (connectionStateManager) {
            if (!this.connState.checkPhase(phase)) {
                return;
            }
            this.itemsManager.onUpdatesLost(lostUpdatesEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyDelete(int phase, Item[] items) {
        ConnectionStateManager connectionStateManager = this.connState;
        synchronized (connectionStateManager) {
            if (!this.connState.checkPhase(phase)) {
                return;
            }
            this.itemsManager.startTran();
            try {
                for (int i = 0; i < items.length; ++i) {
                    this.itemsManager.onSnapshot(items[i], null);
                    this.itemsManager.onConfirm(items[i]);
                }
            }
            finally {
                this.itemsManager.endTran();
            }
        }
    }

    class TransStatus {
        private int trans;

        public TransStatus(int trans) {
            this.trans = trans;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resumeTrans() {
            if (this.trans != 0) {
                ConnectionStateManager connectionStateManager = PushStateManager.this.connState;
                synchronized (connectionStateManager) {
                    PushStateManager.this.itemsManager.startTrans(this.trans);
                }
            }
        }

        public void leaveTrans() {
            if (this.trans != 0) {
                // empty if block
            }
        }
    }
}

