/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.ls_proxy;

import com.lightstreamer.ls_client.SubscribedTableKey;
import com.lightstreamer.ls_client.UpdateInfo;
import com.lightstreamer.ls_proxy.Item;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PushEvent {
    static final String UNCHANGED = new String("UNCHANGED");
    private Item item = null;
    private SubscribedTableKey subscrKey;
    private ArrayList<String> values;
    private int lostUpdates;

    PushEvent(Item item, UpdateInfo values) {
        this.item = item;
        this.values = new ArrayList(values.getNumFields());
        for (int i = 1; i <= values.getNumFields(); ++i) {
            if (values.isValueChanged(i)) {
                this.values.add(values.getNewValue(i));
                continue;
            }
            this.values.add(UNCHANGED);
        }
    }

    PushEvent(Item item) {
        this.item = item;
    }

    PushEvent(Item item, int lostUpdates) {
        this.item = item;
        this.lostUpdates = lostUpdates;
    }

    void setSubscrKey(SubscribedTableKey subscrKey) {
        this.subscrKey = subscrKey;
    }

    Item getItem() {
        return this.item;
    }

    SubscribedTableKey getSubscrKey() {
        return this.subscrKey;
    }

    String getUnchangedSignal() {
        return UNCHANGED;
    }

    int getLostUpdates() {
        return this.lostUpdates;
    }

    int getSize() {
        return this.values.size();
    }

    Iterator<String> getIterator() {
        return this.values.iterator();
    }

    String getValue(int pos) {
        return this.values.get(pos);
    }

    boolean isEmpty() {
        return this.values.isEmpty();
    }

    public String toString() {
        return "event for item " + this.item + " with values " + this.values;
    }
}

