/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.ls_proxy;

import com.lightstreamer.ls_client.ConnectionConstraints;
import com.lightstreamer.ls_client.ConnectionInfo;
import com.lightstreamer.ls_client.SubscribedTableKey;
import com.lightstreamer.ls_proxy.BWMonitor;
import com.lightstreamer.ls_proxy.BandwidthListener;
import com.lightstreamer.ls_proxy.ConnectException;
import com.lightstreamer.ls_proxy.ConnectionHandler;
import com.lightstreamer.ls_proxy.ConnectionStateManager;
import com.lightstreamer.ls_proxy.ConnectionStrategyManager;
import com.lightstreamer.ls_proxy.Item;
import com.lightstreamer.ls_proxy.ItemsManager;
import com.lightstreamer.ls_proxy.ProxyInfo;
import com.lightstreamer.ls_proxy.PushErrorListener;
import com.lightstreamer.ls_proxy.PushEvent;
import com.lightstreamer.ls_proxy.PushException;
import com.lightstreamer.ls_proxy.PushListener;
import com.lightstreamer.ls_proxy.PushStateManager;
import com.lightstreamer.ls_proxy.PushStatusListener;
import com.lightstreamer.ls_proxy.UpdateListener;

public final class LSProxy {
    private final PushStateManager pushManager;
    private final ConnectionStateManager connManager;
    private final ConnectionStrategyManager strategyManager;
    private final BWMonitor bwMonitor;

    public LSProxy(ProxyInfo info, PushErrorListener errorListener, final PushStatusListener statusListener) {
        PushListener pushListener = new PushListener(){

            public void onSubscr(int phase, Item[] items, SubscribedTableKey[] subscrKeys) {
                LSProxy.this.pushManager.notifySubscr(phase, items, subscrKeys);
            }

            public void onSubscrError(int phase, Item[] items, PushException e) {
                LSProxy.this.pushManager.notifySubscrError(phase, items, e);
            }

            public void onValues(int phase, PushEvent itemEvent) {
                LSProxy.this.pushManager.sendValues(phase, itemEvent);
            }

            public void onSnapshotEnd(int phase, PushEvent eosEvent) {
                LSProxy.this.pushManager.notifySnapshotEnd(phase, eosEvent);
            }

            public void onUpdatesLost(int phase, PushEvent lostUpdatesEvent) {
                LSProxy.this.pushManager.notifyUpdatesLost(phase, lostUpdatesEvent);
            }

            public void onDelete(int phase, Item[] items) {
                LSProxy.this.pushManager.notifyDelete(phase, items);
            }

            public void onNewBytes(long bytes) {
                LSProxy.this.bwMonitor.addBytes(bytes);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onActivityWarning(int phase, boolean warningOn) {
                ConnectionStateManager connectionStateManager = LSProxy.this.connManager;
                synchronized (connectionStateManager) {
                    if (!LSProxy.this.connManager.checkPhase(phase)) {
                        return;
                    }
                    try {
                        if (warningOn) {
                            statusListener.onStalled();
                        } else if (LSProxy.this.connManager.isPolling()) {
                            statusListener.onPolling();
                        } else {
                            statusListener.onStreaming();
                        }
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
            }

            public void onPushEnd(int phase, int cause) {
                LSProxy.this.strategyManager.onPushEnd(phase, cause);
            }

            public void onPushFailure(int phase, PushException e1) {
                LSProxy.this.strategyManager.onPushFailure(phase, e1);
            }
        };
        ConnectionHandler connHandler = new ConnectionHandler(pushListener, info.connectionTimeoutMillis);
        this.connManager = new ConnectionStateManager(connHandler, statusListener);
        ItemsManager itemsManager = new ItemsManager(connHandler);
        this.pushManager = new PushStateManager(this.connManager, itemsManager);
        this.bwMonitor = new BWMonitor(info.bwMonitorTimeoutMillis, connHandler);
        this.strategyManager = new ConnectionStrategyManager(this, info, errorListener, this.connManager);
    }

    public void startPushConnection(ConnectionInfo info) throws PushException {
        this.bwMonitor.ensureRunning();
        try {
            this.internalStartPushConnection(info);
        }
        catch (ConnectException e) {
            this.strategyManager.onConnectionFailure(e, info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalStartPushConnection(ConnectionInfo info) throws ConnectException {
        class MyConnectionListener
        implements ConnectionStateManager.ConnectionListener {
            public boolean newConnection = false;
            public PushStateManager.TransStatus transPending = null;

            MyConnectionListener() {
            }

            public void onNewConnection() {
                this.newConnection = true;
                this.transPending = LSProxy.this.pushManager.suspendTrans();
            }
        }
        MyConnectionListener listener = new MyConnectionListener();
        ConnectionStateManager connectionStateManager = this.connManager;
        synchronized (connectionStateManager) {
            if (!this.connManager.allowsConnection(info)) {
                this.stopPushConnection();
            }
            this.connManager.connect(info, listener);
            if (listener.newConnection) {
                this.pushManager.notifyNewConnection();
                listener.transPending.resumeTrans();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopPushConnection() {
        ConnectionStateManager connectionStateManager = this.connManager;
        synchronized (connectionStateManager) {
            PushStateManager.TransStatus transStatus = this.pushManager.suspendTrans();
            this.connManager.disconnect();
            this.pushManager.notifyNewDisconnection();
            transStatus.leaveTrans();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearConnection() {
        ConnectionStateManager connectionStateManager = this.connManager;
        synchronized (connectionStateManager) {
            PushStateManager.TransStatus transStatus = this.pushManager.suspendTrans();
            this.connManager.disconnect();
            this.pushManager.clearItems();
            transStatus.leaveTrans();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPushing() {
        ConnectionStateManager connectionStateManager = this.connManager;
        synchronized (connectionStateManager) {
            return this.connManager.isConnected();
        }
    }

    public void setConnectionConstraints(ConnectionConstraints constraints) {
        this.connManager.changeConnectionConstraints(constraints);
    }

    public ConnectionConstraints getConnectionConstraints() {
        ConnectionInfo info = this.connManager.getCurrConnInfo();
        if (info != null) {
            return (ConnectionConstraints)info.constraints.clone();
        }
        return null;
    }

    public void subscribeBandwidth(BandwidthListener bwListener) {
        this.bwMonitor.addListener(bwListener);
    }

    public void unsubscribeBandwidth(BandwidthListener bwListener) {
        this.bwMonitor.removeListener(bwListener);
    }

    public void startTran() {
        this.pushManager.startTran();
    }

    public void endTran() {
        this.pushManager.endTran();
    }

    public void subscribeItem(UpdateListener itemListener, Item item, String[] schema) {
        this.pushManager.addItems(itemListener, new Item[]{item}, schema);
    }

    public void unsubscribeItem(UpdateListener itemListener, Item item, String[] schema) {
        this.pushManager.removeItems(itemListener, new Item[]{item}, schema);
    }

    public void subscribeItems(UpdateListener itemListener, Item[] items, String[] schema) {
        this.pushManager.addItems(itemListener, items, schema);
    }

    public void unsubscribeItems(UpdateListener itemListener, Item[] items, String[] schema) {
        this.pushManager.removeItems(itemListener, items, schema);
    }
}

