/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.ls_proxy;

import com.lightstreamer.ls_client.SubscribedTableKey;
import com.lightstreamer.ls_proxy.ConnectionHandler;
import com.lightstreamer.ls_proxy.Item;
import com.lightstreamer.ls_proxy.ItemData;
import com.lightstreamer.ls_proxy.PushEvent;
import com.lightstreamer.ls_proxy.PushException;
import com.lightstreamer.ls_proxy.RequestException;
import com.lightstreamer.ls_proxy.ResubscrManager;
import com.lightstreamer.ls_proxy.UpdateEvent;
import com.lightstreamer.ls_proxy.UpdateListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

class ItemsManager {
    private int tranLevel = 0;
    private final HashMap cache = new HashMap();
    private final ResubscrManager resubscrManager;
    private static Logger stateLogger = Logger.getLogger("com.lightstreamer.ls_proxy.state");

    ItemsManager(ConnectionHandler subscrHandler) {
        this.resubscrManager = new ResubscrManager(subscrHandler);
    }

    void addListener(UpdateListener itemListener, Item item, String[] schema) {
        ItemData itemData = (ItemData)this.cache.get(item);
        if (itemData == null) {
            if (stateLogger.isLoggable(Level.FINE)) {
                stateLogger.fine("Adding " + item.toFullString() + " with fields " + Arrays.asList(schema));
            }
            itemData = new ItemData(item);
            this.cache.put(item, itemData);
        } else if (stateLogger.isLoggable(Level.FINE)) {
            stateLogger.fine("Adding to " + item.toFullString() + "; new fields " + Arrays.asList(schema));
        }
        int inters = itemData.checkAddListener(schema);
        if (inters == 4) {
            stateLogger.severe("Fields " + Arrays.asList(schema) + " could not be added to " + item.toFullString() + " - A different item should be used.");
            RequestException error = new RequestException(2);
            try {
                itemListener.onException(item, error);
            }
            catch (Throwable t) {
                // empty catch block
            }
            return;
        }
        if (inters == 3) {
            stateLogger.severe("Fields " + Arrays.asList(schema) + " could not be added to " + item.toFullString() + " - A different item should be used.");
            RequestException error = new RequestException(2);
            try {
                itemListener.onException(item, error);
            }
            catch (Throwable t) {
                // empty catch block
            }
            return;
        }
        try {
            itemData.addListener(itemListener, schema);
        }
        catch (RequestException e) {
            stateLogger.severe("Unexpected error while adding fields for " + item.toFullString() + "; Item state may be inconsistent");
            try {
                itemListener.onException(item, e);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        this.resubscrManager.checkItem(itemData);
        if (inters == 1) {
            if (stateLogger.isLoggable(Level.FINEST)) {
                stateLogger.finest("Sending internal snapshot data for " + item.toFullString());
            }
            itemData.sendSnapshot(itemListener);
        }
    }

    void removeListener(UpdateListener itemListener, Item item, String[] schema) {
        ItemData itemData = (ItemData)this.cache.get(item);
        if (itemData == null) {
            RequestException e = new RequestException(6);
            try {
                itemListener.onException(item, e);
            }
            catch (Throwable t) {
                // empty catch block
            }
            return;
        }
        try {
            if (stateLogger.isLoggable(Level.FINE)) {
                stateLogger.fine("Removing fields " + Arrays.asList(schema) + " from " + item.toFullString());
            }
            itemData.removeListener(itemListener, schema);
        }
        catch (RequestException e) {
            stateLogger.severe("Unexpected error while removing fields for " + item.toFullString() + "; Item state may be inconsistent");
            try {
                itemListener.onException(item, e);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        this.resubscrManager.checkItem(itemData);
    }

    void startTran() {
        if (this.tranLevel == 0) {
            // empty if block
        }
        ++this.tranLevel;
        stateLogger.finer("Starting transaction; " + this.tranLevel + " active transactions");
    }

    void endTran() {
        if (this.tranLevel == 0) {
            return;
        }
        --this.tranLevel;
        if (this.tranLevel == 0) {
            stateLogger.finer("Completing last active transaction");
            this.resubscrManager.doSubscr();
        } else {
            stateLogger.finer("Completing transaction; " + this.tranLevel + " active transactions");
        }
    }

    void startTrans(int trans) {
        if (this.tranLevel == 0) {
            // empty if block
        }
        this.tranLevel += trans;
        stateLogger.finer("Restoring " + trans + " transactions; " + this.tranLevel + " active transactions");
    }

    int endTrans() {
        if (this.tranLevel == 0) {
            return 0;
        }
        int trans = this.tranLevel;
        this.tranLevel = 0;
        stateLogger.finer("Completing all active transactions");
        this.resubscrManager.doSubscr();
        return trans;
    }

    void onSnapshot(Item item, SubscribedTableKey key) {
        ItemData itemData = (ItemData)this.cache.get(item);
        if (itemData == null) {
            if (stateLogger.isLoggable(Level.FINEST)) {
                stateLogger.finest("Got out of date subscription confirmation for " + item.toFullString());
            }
            return;
        }
        if (stateLogger.isLoggable(Level.FINEST)) {
            stateLogger.finest("Got subscription confirmation for " + item.toFullString());
        }
        itemData.setSubscrKey(key);
        itemData.confirmFields();
    }

    void onConfirm(Item item) {
        ItemData itemData = (ItemData)this.cache.get(item);
        if (itemData == null) {
            return;
        }
        if (stateLogger.isLoggable(Level.FINEST)) {
            stateLogger.finest("Checking pending changes for " + item.toFullString());
        }
        itemData.confirmSubscr();
        if (itemData.isEmpty()) {
            this.resubscrManager.removeItem(itemData);
            this.cache.remove(item);
        } else {
            this.resubscrManager.checkItem(itemData);
        }
    }

    void onValues(PushEvent itemEvent) {
        SubscribedTableKey eventKey;
        ItemData itemData = (ItemData)this.cache.get(itemEvent.getItem());
        boolean outofdate = true;
        if (itemData != null && (eventKey = itemEvent.getSubscrKey()) == itemData.getSubscrKey()) {
            outofdate = false;
            if (stateLogger.isLoggable(Level.FINEST)) {
                stateLogger.finest("Got a new update for " + itemEvent.getItem().toFullString());
            }
            UpdateEvent[] newEvents = itemData.update(itemEvent);
            for (int i = 0; i < newEvents.length; ++i) {
                itemData.sendEvent(newEvents[i]);
            }
        }
        if (outofdate && stateLogger.isLoggable(Level.FINEST)) {
            stateLogger.finest("Got an out of date update for " + itemEvent.getItem().toFullString());
        }
    }

    void onSnapshotEnd(PushEvent eosEvent) {
        SubscribedTableKey eventKey;
        ItemData itemData = (ItemData)this.cache.get(eosEvent.getItem());
        boolean outofdate = true;
        if (itemData != null && (eventKey = eosEvent.getSubscrKey()) == itemData.getSubscrKey()) {
            outofdate = false;
            if (stateLogger.isLoggable(Level.FINEST)) {
                stateLogger.finest("Got an end of snapshot marker for " + eosEvent.getItem().toFullString());
            }
            UpdateEvent[] newEvents = itemData.endOfSnapshot();
            for (int i = 0; i < newEvents.length; ++i) {
                itemData.sendEvent(newEvents[i]);
            }
        }
        if (outofdate && stateLogger.isLoggable(Level.FINEST)) {
            stateLogger.finest("Got an out of date end of snapshot marker for " + eosEvent.getItem().toFullString());
        }
    }

    void onUpdatesLost(PushEvent lostUpdatesEvent) {
        SubscribedTableKey eventKey;
        ItemData itemData = (ItemData)this.cache.get(lostUpdatesEvent.getItem());
        boolean outofdate = true;
        if (itemData != null && (eventKey = lostUpdatesEvent.getSubscrKey()) == itemData.getSubscrKey()) {
            outofdate = false;
            stateLogger.severe("Got an update lost alert for " + lostUpdatesEvent.getItem().toFullString());
            itemData.sendLostUpdatesError(lostUpdatesEvent.getLostUpdates());
        }
        if (outofdate && stateLogger.isLoggable(Level.FINEST)) {
            stateLogger.finest("Got an out of date update lost alert for " + lostUpdatesEvent.getItem().toFullString());
        }
    }

    void onSubscrError(Item item, PushException e) {
        ItemData itemData = (ItemData)this.cache.get(item);
        if (itemData == null) {
            if (stateLogger.isLoggable(Level.FINEST)) {
                stateLogger.finest("Got an out of date subscription error alert for " + item.toFullString());
            }
            return;
        }
        stateLogger.severe("Subscription error for " + item.toFullString());
        stateLogger.log(Level.FINER, "Subscription error for " + item.toFullString(), e);
        itemData.setSubscrKey(null);
        itemData.sendError(e);
    }

    void onPushError(Item item, Object subscrKey, PushException e) {
        ItemData itemData = (ItemData)this.cache.get(item);
        boolean outofdate = true;
        if (itemData != null && subscrKey == itemData.getSubscrKey()) {
            outofdate = false;
            stateLogger.severe("Push error for " + item.toFullString());
            stateLogger.log(Level.FINER, "Push error for " + item.toFullString(), e);
            itemData.sendError(e);
        }
        if (outofdate && stateLogger.isLoggable(Level.FINEST)) {
            stateLogger.finest("Got an out of date push error alert for " + item.toFullString());
        }
    }

    void redoSubscriptions() {
        stateLogger.fine("Reviewing all subscriptions");
        for (ItemData itemData : this.cache.values()) {
            itemData.clearSubscr();
            this.resubscrManager.checkItem(itemData);
        }
    }

    void clearSubscriptions() {
        stateLogger.fine("Removing all subscriptions");
        this.cache.clear();
    }
}

