/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.ls_proxy;

import com.lightstreamer.ls_proxy.Item;
import com.lightstreamer.ls_proxy.UpdateEvent;
import java.util.HashMap;

class ItemUpdateEvent
implements UpdateEvent {
    private final Item item;
    private HashMap values = new HashMap();

    ItemUpdateEvent(Item item) {
        this.item = item;
    }

    void setChanged(String fieldName, String value) {
        this.values.put(fieldName, new UpdateData(value, true));
    }

    void setUnchanged(String fieldName, String value) {
        this.values.put(fieldName, new UpdateData(value, false));
    }

    public Item getItem() {
        return this.item;
    }

    public String getValue(String fieldName) {
        UpdateData data = (UpdateData)this.values.get(fieldName);
        if (data == null) {
            return null;
        }
        return data.value;
    }

    public String getUpdatedValue(String fieldName) {
        UpdateData data = (UpdateData)this.values.get(fieldName);
        if (data == null) {
            return null;
        }
        return data.updatedValue;
    }

    public String[] getFieldNames() {
        return this.values.keySet().toArray(new String[0]);
    }

    public String toString() {
        return "update for " + this.getItem() + " with values " + this.values;
    }

    private static class UpdateData {
        public String value;
        public String updatedValue;

        public UpdateData(String value, boolean changed) {
            this.value = value;
            this.updatedValue = changed ? value : null;
        }

        public String toString() {
            if (this.updatedValue != null) {
                return this.updatedValue;
            }
            return "(" + this.value + ")";
        }
    }
}

