/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.ls_proxy;

import com.lightstreamer.ls_client.SubscribedTableKey;
import com.lightstreamer.ls_proxy.Item;
import com.lightstreamer.ls_proxy.ListenerData;
import com.lightstreamer.ls_proxy.MiniMap;
import com.lightstreamer.ls_proxy.PushEvent;
import com.lightstreamer.ls_proxy.PushException;
import com.lightstreamer.ls_proxy.PushUpdateException;
import com.lightstreamer.ls_proxy.RequestException;
import com.lightstreamer.ls_proxy.SchemaData;
import com.lightstreamer.ls_proxy.UpdateEvent;
import com.lightstreamer.ls_proxy.UpdateListener;
import java.util.logging.Level;
import java.util.logging.Logger;

class ItemData {
    static final int INTERS_OK = 1;
    static final int INTERS_EMPTY = 2;
    static final int INTERS_UNUSABLE = 3;
    static final int INTERS_NOT_POSSIBLE = 4;
    private Item item;
    private MiniMap listeners = new MiniMap();
    private SchemaData fields;
    private boolean listenersLocked = false;
    private boolean active = false;
    private boolean changing = false;
    private SubscribedTableKey subscrKey = null;
    private boolean holePending = false;
    private static Logger eventsLogger = Logger.getLogger("com.lightstreamer.ls_proxy.events");

    ItemData(Item item) {
        this.item = item;
        this.fields = item.getNewSchemaData();
    }

    Item getItem() {
        return this.item;
    }

    SubscribedTableKey getSubscrKey() {
        return this.subscrKey;
    }

    void setSubscrKey(SubscribedTableKey key) {
        this.subscrKey = key;
    }

    SchemaData getSchema() {
        return this.fields;
    }

    int checkAddListener(String[] schema) {
        if (this.fields.isEmpty(true)) {
            return 2;
        }
        if (!this.fields.isSubset(schema, true)) {
            if (!this.fields.canRestart()) {
                return 4;
            }
            if (!this.fields.canExtract()) {
                return 3;
            }
        }
        if (this.fields.isInters(schema, true)) {
            return 1;
        }
        return 2;
    }

    void addListener(UpdateListener listener, String[] schema) throws RequestException {
        if (this.listenersLocked) {
            throw new RequestException(1);
        }
        this.addFieldsToListener(listener, schema);
        this.fields.addListenerToFields(listener, schema);
    }

    void removeListener(UpdateListener listener, String[] schema) throws RequestException {
        if (this.listenersLocked) {
            throw new RequestException(1);
        }
        this.removeFieldsFromListener(listener, schema);
        this.fields.removeListenerFromFields(listener, schema);
    }

    private void addFieldsToListener(UpdateListener listener, String[] schema) {
        ListenerData data = (ListenerData)this.listeners.get(listener);
        if (data == null) {
            data = new ListenerData(listener);
            this.listeners.put(listener, data);
        }
        data.addSchema(schema);
    }

    private void removeFieldsFromListener(UpdateListener listener, String[] schema) throws RequestException {
        ListenerData data = (ListenerData)this.listeners.get(listener);
        if (data == null) {
            throw new RequestException(4);
        }
        data.removeSchema(schema);
        if (!data.isActive()) {
            this.listeners.remove(listener);
        }
    }

    boolean isSynched() {
        return this.fields.isSynched();
    }

    void prepareForSubscr() {
        this.fields.prepareForSubscr();
        this.changing = true;
    }

    void doneSubscr() {
        this.fields.doneSubscr();
    }

    boolean isChanging() {
        return this.changing;
    }

    void confirmFields() {
        if (!this.fields.isEmpty(false)) {
            this.holePending = true;
            eventsLogger.fine("Events flow interrupted for " + this.item);
        }
        this.active = this.fields.confirmSubscr();
    }

    void confirmSubscr() {
        this.changing = false;
    }

    void clearSubscr() {
        if (!this.fields.isEmpty(false)) {
            this.holePending = true;
            eventsLogger.fine("Events flow interrupted for " + this.item);
        }
        this.fields.clearSubscr();
        this.active = false;
        this.subscrKey = null;
        this.changing = false;
    }

    boolean isActive() {
        return this.active;
    }

    boolean isEmpty() {
        return !this.isChanging() && !this.isActive() && this.isSynched();
    }

    UpdateEvent[] update(PushEvent serverEvent) {
        if (this.holePending) {
            eventsLogger.fine("Got event after an interruption for " + this.item);
            try {
                this.fields.onRestart(this.item);
                eventsLogger.fine("Holes allowed for " + this.item);
            }
            catch (PushException e1) {
                try {
                    e1.rethrow();
                }
                catch (PushUpdateException e2) {
                    int code = e2.getErrorCode();
                    if (code == 2) {
                        eventsLogger.warning("Possible loss of events for " + this.item);
                        this.sendLostUpdatesError(0);
                    } else if (code == 3) {
                        eventsLogger.warning("Possible duplication or loss of events for " + this.item);
                        this.sendLostUpdatesError(-1);
                    } else {
                        this.sendError(e1);
                    }
                }
                catch (Exception e2) {
                    this.sendError(e1);
                }
            }
        }
        this.holePending = false;
        try {
            if (eventsLogger.isLoggable(Level.FINEST)) {
                eventsLogger.finest("Integrating " + serverEvent);
            }
            return this.fields.update(this.item, serverEvent);
        }
        catch (PushException e) {
            eventsLogger.severe("Error integrating " + serverEvent);
            eventsLogger.log(Level.FINER, "Error integrating " + serverEvent, e);
            this.sendError(e);
            return new UpdateEvent[0];
        }
    }

    UpdateEvent[] endOfSnapshot() {
        try {
            if (eventsLogger.isLoggable(Level.FINEST)) {
                eventsLogger.finest("Managing end of snapshot notification for " + this.item);
            }
            return this.fields.endOfSnapshot(this.item);
        }
        catch (PushException e) {
            eventsLogger.severe("Error managing end of snapshot notification for " + this.item);
            eventsLogger.log(Level.FINER, "Error managing end of snapshot notification for " + this.item, e);
            this.sendError(e);
            return new UpdateEvent[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendEvent(UpdateEvent event) {
        this.listenersLocked = true;
        try {
            for (ListenerData data : this.listeners.values()) {
                if (event == SchemaData.EOS_EVENT) {
                    if (eventsLogger.isLoggable(Level.FINEST)) {
                        eventsLogger.finest("Sending end of snapshot notification for " + this.item.toFullString() + " to the listeners");
                    }
                    try {
                        data.getListener().onSnapshotEnd(this.item);
                    }
                    catch (Throwable t) {}
                    continue;
                }
                if (eventsLogger.isLoggable(Level.FINEST)) {
                    eventsLogger.finest("Sending " + event + " to the listeners");
                }
                try {
                    data.getListener().update(event);
                }
                catch (Throwable t) {}
            }
        }
        finally {
            this.listenersLocked = false;
        }
    }

    void sendSnapshot(UpdateListener newListener) {
        UpdateEvent[] newEvents = this.fields.getSnapshot(this.item);
        for (int i = 0; i < newEvents.length; ++i) {
            if (eventsLogger.isLoggable(Level.FINEST)) {
                eventsLogger.finest("Sending " + newEvents[i] + " as snapshot");
            }
            try {
                newListener.update(newEvents[i]);
                continue;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (this.fields.isSnapshotCompleted()) {
            try {
                newListener.onSnapshotEnd(this.item);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendError(PushException e) {
        this.listenersLocked = true;
        if (eventsLogger.isLoggable(Level.FINEST)) {
            eventsLogger.finest("Sending error " + e.getMessage() + " for " + this.item + " to the listeners");
        }
        try {
            for (ListenerData data : this.listeners.values()) {
                try {
                    data.getListener().onException(this.item, e);
                }
                catch (Throwable t) {}
            }
        }
        finally {
            this.listenersLocked = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendLostUpdatesError(int lostUpdates) {
        this.listenersLocked = true;
        if (eventsLogger.isLoggable(Level.FINEST)) {
            eventsLogger.finest("Sending lost updates alert for " + this.item.toFullString() + " to the listeners");
        }
        try {
            for (ListenerData data : this.listeners.values()) {
                try {
                    data.getListener().onLostUpdates(this.item, lostUpdates);
                }
                catch (Throwable t) {}
            }
        }
        finally {
            this.listenersLocked = false;
        }
    }
}

