/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.ls_proxy;

import com.lightstreamer.ls_proxy.ItemException;
import com.lightstreamer.ls_proxy.SchemaCommandMatchData;
import com.lightstreamer.ls_proxy.SchemaData;
import com.lightstreamer.ls_proxy.SchemaDistinctData;
import com.lightstreamer.ls_proxy.SchemaMergeData;
import com.lightstreamer.ls_proxy.SchemaRawData;

public final class Item {
    public static final String MERGE = "MERGE";
    public static final String DISTINCT = "DISTINCT";
    public static final String RAW = "RAW";
    public static final String COMMAND = "COMMAND";
    public static final String KEY_FIELD = "key";
    public static final String COMMAND_FIELD = "command";
    public static final String ADD_COMMAND = "ADD";
    public static final String UPDATE_COMMAND = "UPDATE";
    public static final String DELETE_COMMAND = "DELETE";
    private static int lastId = 0;
    private final String name;
    private final String dataAdapter;
    private final String mode;
    private int uniqueId = 0;
    private String selector = null;
    private Integer bufferSize = null;
    private Double maxFrequency = null;
    private boolean unfiltered = false;
    private int distinctSnapshotLength = 0;

    private static int getModeKey(String mode) {
        return mode.length();
    }

    public Item(String name, String mode) throws ItemException {
        this(name, null, mode);
    }

    public Item(String name, String dataAdapter, String mode) throws ItemException {
        if (name == null) {
            throw new ItemException(5);
        }
        if (mode == null) {
            throw new ItemException(6);
        }
        this.name = name;
        String string = this.dataAdapter = dataAdapter == null ? "DEFAULT" : dataAdapter;
        if (mode.equals(MERGE)) {
            this.mode = MERGE;
        } else if (mode.equals(DISTINCT)) {
            this.mode = DISTINCT;
        } else if (mode.equals(COMMAND)) {
            this.mode = COMMAND;
        } else if (mode.equals(RAW)) {
            this.mode = RAW;
        } else {
            throw new ItemException(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUnique() {
        Class<Item> clazz = Item.class;
        synchronized (Item.class) {
            this.uniqueId = ++lastId;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }

    public void setRequestedBufferSize(int bufferSize) throws ItemException {
        if (this.mode == MERGE || this.mode == DISTINCT) {
            if (bufferSize >= 0) {
                this.bufferSize = new Integer(bufferSize);
            }
        } else {
            throw new ItemException(2);
        }
    }

    public void setRequestedMaxFrequency(double maxFrequency) throws ItemException {
        if (this.mode == MERGE || this.mode == DISTINCT || this.mode == COMMAND) {
            if (maxFrequency >= 0.0) {
                this.maxFrequency = new Double(maxFrequency);
            }
        } else {
            throw new ItemException(3);
        }
    }

    public void requestUnfilteredDispatching() throws ItemException {
        if (this.mode != MERGE && this.mode != DISTINCT && this.mode != COMMAND) {
            throw new ItemException(8);
        }
        this.unfiltered = true;
    }

    public void setDistinctSnapshotLength(int length) throws ItemException {
        if (this.mode == DISTINCT) {
            if (length >= 0) {
                this.distinctSnapshotLength = length;
            }
        } else {
            throw new ItemException(4);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDataAdapter() {
        return this.dataAdapter.equals("DEFAULT") ? null : this.dataAdapter;
    }

    public String getMode() {
        return this.mode;
    }

    public String getSelector() {
        return this.selector;
    }

    public Integer getBufferSize() {
        return this.bufferSize;
    }

    public Double getMaxFrequency() {
        return this.maxFrequency;
    }

    public boolean isUnfiltered() {
        return this.unfiltered;
    }

    public int getDistinctSnapshotLength() {
        return this.distinctSnapshotLength;
    }

    SchemaData getNewSchemaData() {
        if (this.mode == DISTINCT) {
            return new SchemaDistinctData(this.distinctSnapshotLength, this.unfiltered);
        }
        if (this.mode == MERGE) {
            return new SchemaMergeData(this.unfiltered);
        }
        if (this.mode == COMMAND && !this.unfiltered) {
            return new SchemaCommandMatchData();
        }
        return new SchemaRawData();
    }

    static int compareModes(Item i1, Item i2) {
        int dataDiff = i1.dataAdapter.compareTo(i2.dataAdapter);
        if (dataDiff != 0) {
            return dataDiff;
        }
        int idDiff = i1.uniqueId - i2.uniqueId;
        if (idDiff != 0) {
            return idDiff;
        }
        int modeDiff = Item.getModeKey(i1.mode) - Item.getModeKey(i2.mode);
        if (modeDiff != 0) {
            return modeDiff;
        }
        if (i1.selector != null && i2.selector != null) {
            int strDiff = i1.selector.compareTo(i2.selector);
            if (strDiff != 0) {
                return strDiff;
            }
        } else {
            if (i1.selector != null) {
                return 1;
            }
            if (i2.selector != null) {
                return -1;
            }
        }
        if (i1.unfiltered && !i2.unfiltered) {
            return 1;
        }
        if (i2.unfiltered && !i1.unfiltered) {
            return -1;
        }
        if (!i1.unfiltered) {
            // empty if block
        }
        if (i1.bufferSize != null && i2.bufferSize != null) {
            int bufDiff = i1.bufferSize - i2.bufferSize;
            if (bufDiff != 0) {
                return bufDiff;
            }
        } else {
            if (i1.bufferSize != null) {
                return 1;
            }
            if (i2.bufferSize != null) {
                return -1;
            }
        }
        if (i1.maxFrequency != null && i2.maxFrequency != null) {
            if (i1.maxFrequency > i2.maxFrequency) {
                return 1;
            }
            if (i1.maxFrequency < i2.maxFrequency) {
                return -1;
            }
        } else {
            if (i1.maxFrequency != null) {
                return 1;
            }
            if (i2.maxFrequency != null) {
                return -1;
            }
        }
        return i1.distinctSnapshotLength - i2.distinctSnapshotLength;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        Item otherItem = (Item)other;
        if (!this.name.equals(otherItem.name)) {
            return false;
        }
        return Item.compareModes(this, otherItem) == 0;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.mode.hashCode();
    }

    public String toString() {
        return this.getName();
    }

    String toFullString() {
        return this.getMode() + " item " + this.getName();
    }
}

