/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.ls_proxy;

import com.lightstreamer.ls_proxy.UpdateListener;

class FieldData {
    private int listenersCount = 0;
    private String fieldName;
    private String value = null;
    private boolean active = false;
    private boolean changing = false;

    FieldData(String fieldName) {
        this.fieldName = fieldName;
    }

    String getName() {
        return this.fieldName;
    }

    void addListener(UpdateListener listener) {
        ++this.listenersCount;
    }

    void removeListener(UpdateListener listener) {
        --this.listenersCount;
    }

    boolean isUsed() {
        return this.listenersCount > 0;
    }

    String getValue() {
        return this.value;
    }

    boolean update(String newValue) {
        boolean changed = this.value == null || newValue == null ? this.value != null || newValue != null : !this.value.equals(newValue);
        this.value = newValue;
        return changed;
    }

    boolean isActive(boolean alsoPotentially) {
        if (alsoPotentially) {
            return this.active || this.changing;
        }
        return this.active;
    }

    boolean isSynched() {
        return this.isUsed() == this.isActive(false);
    }

    void prepareForSubscr() {
        this.changing = !this.isSynched();
    }

    boolean isChanging() {
        return this.changing;
    }

    void confirmSubscr() {
        if (this.changing) {
            boolean bl = this.active = !this.active;
            if (!this.active) {
                this.value = null;
            }
            this.changing = false;
        }
    }

    void clearSubscr() {
        this.active = false;
        this.value = null;
        this.changing = false;
    }
}

