/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.ls_proxy;

import com.lightstreamer.ls_client.ConnectionInfo;
import com.lightstreamer.ls_proxy.ConnectException;
import com.lightstreamer.ls_proxy.ConnectionException;
import com.lightstreamer.ls_proxy.ConnectionStateManager;
import com.lightstreamer.ls_proxy.LSProxy;
import com.lightstreamer.ls_proxy.ProxyInfo;
import com.lightstreamer.ls_proxy.PushErrorListener;
import com.lightstreamer.ls_proxy.PushException;
import java.util.logging.Level;
import java.util.logging.Logger;

class ConnectionStrategyManager {
    private final ProxyInfo strategyInfo;
    private final PushErrorListener errorListener;
    private final LSProxy performer;
    private final ConnectionStateManager connManager;
    private static Logger connLogger = Logger.getLogger("com.lightstreamer.ls_proxy.connection");

    ConnectionStrategyManager(LSProxy performer, ProxyInfo info, PushErrorListener errorListener, ConnectionStateManager connManager) {
        this.performer = performer;
        this.strategyInfo = (ProxyInfo)info.clone();
        this.errorListener = errorListener;
        this.connManager = connManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onPushFailure(int phase, PushException e) {
        ConnectionStateManager connectionStateManager = this.connManager;
        synchronized (connectionStateManager) {
            if (!this.connManager.checkPhase(phase)) {
                return;
            }
            connLogger.warning("Streaming failure");
            connLogger.log(Level.FINER, "Streaming failure", e);
            this.performer.stopPushConnection();
            if (this.strategyInfo.onFailedConnectionRetry) {
                connLogger.info("Retry on streaming failure");
                this.errorListener.onConnectionRetry(e);
                try {
                    this.retryConnection(this.connManager.getCurrConnInfo());
                    this.errorListener.onReconnection();
                    connLogger.info("Reconnection successful");
                    return;
                }
                catch (PushException e1) {
                    connLogger.warning("Reconnection failure");
                    connLogger.log(Level.FINER, "Reconnection failure", e1);
                    if (this.strategyInfo.connectionRetryTimeoutMillis <= 0L) {
                        connLogger.info("Give up on reconnection failure");
                        this.errorListener.onFailedReconnection(e1);
                        return;
                    }
                }
            } else {
                connLogger.info("Give up on connection failure");
                this.errorListener.onFailedConnection(e);
                return;
            }
            phase = this.connManager.getPhase();
        }
        while (true) {
            try {
                Thread.sleep(this.strategyInfo.connectionRetryTimeoutMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            connectionStateManager = this.connManager;
            synchronized (connectionStateManager) {
                if (!this.connManager.checkPhase(phase)) {
                    connLogger.info("Leaving reconnection loop");
                    this.errorListener.onReconnectionAbandoned();
                    return;
                }
                try {
                    connLogger.info("Retry after reconnection failure");
                    this.retryConnection(this.connManager.getCurrConnInfo());
                    this.errorListener.onReconnection();
                    connLogger.info("Reconnection successful");
                    return;
                }
                catch (PushException e1) {
                    connLogger.warning("Reconnection attempt failure");
                    connLogger.log(Level.FINER, "Reconnection attempt failure", e1);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onPushEnd(int phase, int cause) {
        ConnectionStateManager connectionStateManager = this.connManager;
        synchronized (connectionStateManager) {
            if (!this.connManager.checkPhase(phase)) {
                return;
            }
            connLogger.warning("Streaming forcibly terminated by the Server");
            connLogger.log(Level.FINER, "Streaming terminated: " + cause);
            this.performer.stopPushConnection();
            connLogger.info("Closing on connection forcibly terminated by the Server");
            this.errorListener.onClosedConnection(cause);
        }
    }

    void onConnectionFailure(ConnectException e, ConnectionInfo info) throws PushException {
        throw e;
    }

    private void retryConnection(ConnectionInfo info) throws PushException {
        try {
            this.performer.internalStartPushConnection(info);
            return;
        }
        catch (PushException e) {
            throw e;
        }
        catch (Throwable e) {
            connLogger.warning("Unexpected error while reconnecting");
            connLogger.log(Level.FINER, "Unexpected error while reconnecting", e);
            ConnectionException exc = new ConnectionException(6, e.getMessage());
            throw new PushException(exc);
        }
    }

    private boolean isAnswerTimeout(PushException e) {
        try {
            e.rethrow();
        }
        catch (ConnectionException e1) {
            if (e1.getErrorCode() == 4) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

