/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.ls_proxy;

import com.lightstreamer.ls_client.ConnectionConstraints;
import com.lightstreamer.ls_client.ConnectionInfo;
import com.lightstreamer.ls_proxy.ConnectException;
import com.lightstreamer.ls_proxy.ConnectionException;
import com.lightstreamer.ls_proxy.ConnectionHandler;
import com.lightstreamer.ls_proxy.PushStatusListener;
import java.util.logging.Logger;

class ConnectionStateManager {
    private final int OFF = -1;
    private final int CONNECTING = 0;
    private final int ON = 1;
    private int state = -1;
    private ConnectException lastConnectionException;
    private ConnectionInfo currConnectionInfo;
    private final Mutex handlerMutex = new Mutex();
    private final ConnectionHandler connHandler;
    private final PushStatusListener statusListener;
    private static Logger connLogger = Logger.getLogger("com.lightstreamer.ls_proxy.connection");

    ConnectionStateManager(ConnectionHandler connHandler, PushStatusListener statusListener) {
        this.connHandler = connHandler;
        this.statusListener = statusListener;
    }

    final boolean isConnected() {
        return this.connHandler.isConnected();
    }

    final boolean isPolling() {
        return this.connHandler.isPolling();
    }

    final boolean checkPhase(int phaseToCheck) {
        return phaseToCheck == this.connHandler.getPhase();
    }

    final int getPhase() {
        return this.connHandler.getPhase();
    }

    final synchronized ConnectionInfo getCurrConnInfo() {
        return this.currConnectionInfo;
    }

    synchronized boolean allowsConnection(ConnectionInfo info) {
        if (this.state != -1 && !this.currConnectionInfo.equals(info)) {
            connLogger.fine("Disconnection of previous connection needed for " + info);
            return false;
        }
        return true;
    }

    synchronized boolean connect(ConnectionInfo info, final ConnectionListener listener) throws ConnectException {
        connLogger.fine("Connection attempt for " + info);
        if (this.state != -1 && !this.currConnectionInfo.equals(info)) {
            ConnectionException exc = new ConnectionException(5);
            throw new ConnectException(this.getPhase(), exc);
        }
        if (this.state == 1) {
            connLogger.fine("Already connected for " + info);
            return false;
        }
        if (this.state == 0) {
            connLogger.fine("Joining current connection attempt for " + this.currConnectionInfo);
            this.waitCurrentConnectionAttempt();
            return false;
        }
        if (this.state == -1) {
            this.handlerMutex.acquire();
            final ConnectionInfo newInfo = (ConnectionInfo)info.clone();
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        ConnectionStateManager.this.startConnection(newInfo, listener);
                    }
                    finally {
                        ConnectionStateManager.this.handlerMutex.release();
                    }
                }
            }.start();
            this.state = 0;
            try {
                this.statusListener.onConnecting();
            }
            catch (Throwable t) {
                // empty catch block
            }
            this.currConnectionInfo = newInfo;
            this.waitCurrentConnectionAttempt();
            return true;
        }
        return false;
    }

    synchronized void changeConnectionConstraints(ConnectionConstraints constraints) {
        connLogger.fine("Changing constraints for " + this.currConnectionInfo + " to " + constraints);
        if (this.currConnectionInfo == null) {
            connLogger.fine("Connection not initialized; no constraints changes applied");
            return;
        }
        if (this.currConnectionInfo.constraints.equals(constraints)) {
            connLogger.fine("No constraints changes needed");
            return;
        }
        this.currConnectionInfo.constraints = (ConnectionConstraints)constraints.clone();
        if (this.state == 1) {
            connLogger.fine("Constraints change needed");
            this.connHandler.doConstrain(this.currConnectionInfo.constraints);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void disconnect() {
        connLogger.fine("Disconnection attempt for " + this.currConnectionInfo);
        while (this.state == 0) {
            this.connHandler.giveupConnecting();
            try {
                this.wait();
            }
            catch (InterruptedException e) {}
        }
        if (this.state == -1) {
            // empty if block
        }
        this.handlerMutex.acquire();
        try {
            this.connHandler.stopConnection();
            this.connHandler.destroyConnection();
        }
        finally {
            this.handlerMutex.release();
        }
        this.state = -1;
        try {
            this.statusListener.onDisconnected();
        }
        catch (Throwable t) {
            // empty catch block
        }
        ConnectionException exc = new ConnectionException(3);
        this.lastConnectionException = new ConnectException(this.getPhase(), exc);
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startConnection(ConnectionInfo info, ConnectionListener listener) {
        try {
            this.connHandler.prepareConnection(info);
            ConnectionStateManager connectionStateManager = this;
            synchronized (connectionStateManager) {
                listener.onNewConnection();
                this.connHandler.startConnection();
                this.state = 1;
                try {
                    if (this.isPolling()) {
                        this.statusListener.onPolling();
                    } else {
                        this.statusListener.onStreaming();
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
                if (!this.currConnectionInfo.constraints.equals(info.constraints)) {
                    connLogger.fine("Constraints update needed");
                    this.connHandler.doConstrain(this.currConnectionInfo.constraints);
                }
                this.notifyAll();
            }
        }
        catch (ConnectException e) {
            ConnectionStateManager connectionStateManager = this;
            synchronized (connectionStateManager) {
                this.state = -1;
                try {
                    this.statusListener.onDisconnected();
                }
                catch (Throwable t) {
                    // empty catch block
                }
                this.lastConnectionException = e;
                this.notifyAll();
            }
        }
        catch (Throwable e) {
            ConnectionStateManager connectionStateManager = this;
            synchronized (connectionStateManager) {
                this.state = -1;
                try {
                    this.statusListener.onDisconnected();
                }
                catch (Throwable t) {
                    // empty catch block
                }
                ConnectionException exc = new ConnectionException(6, e.getMessage());
                this.lastConnectionException = new ConnectException(this.getPhase(), exc);
                this.notifyAll();
            }
        }
    }

    private void waitCurrentConnectionAttempt() throws ConnectException {
        while (this.state == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.state == 1) {
            connLogger.fine("Connection attempt successful for " + this.currConnectionInfo);
        } else if (this.state == -1) {
            connLogger.fine("Connection attempt unsuccessful for " + this.currConnectionInfo);
            throw this.lastConnectionException;
        }
    }

    private static class Mutex {
        private boolean used = false;

        private Mutex() {
        }

        public synchronized void acquire() {
            while (this.used) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.used = true;
        }

        public synchronized void release() {
            this.used = false;
            this.notifyAll();
        }
    }

    static interface ConnectionListener {
        public void onNewConnection();
    }
}

