/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.ls_proxy;

import com.lightstreamer.ls_client.ConnectionConstraints;
import com.lightstreamer.ls_client.ConnectionInfo;
import com.lightstreamer.ls_client.ConnectionListener;
import com.lightstreamer.ls_client.LSClient;
import com.lightstreamer.ls_client.PushConnException;
import com.lightstreamer.ls_client.PushServerException;
import com.lightstreamer.ls_client.PushUserException;
import com.lightstreamer.ls_client.SubscribedTableKey;
import com.lightstreamer.ls_proxy.ConnectException;
import com.lightstreamer.ls_proxy.ConnectionException;
import com.lightstreamer.ls_proxy.Item;
import com.lightstreamer.ls_proxy.PushException;
import com.lightstreamer.ls_proxy.PushListener;
import com.lightstreamer.ls_proxy.SubscrHandler;
import java.util.logging.Logger;

class ConnectionHandler {
    private final long connectionTimeoutMillis;
    private final PushListener eventsListener;
    private boolean connected = false;
    private boolean giveupPending = false;
    private Outcome monitorPending = null;
    private int phase = 0;
    private SubscrHandler subscrHelper;
    private SubscrHandler batchContext = null;
    private ExtendedConnectionListener pushServerListener = null;
    private LSClient pushServerClient = null;
    private static Logger connLogger = Logger.getLogger("com.lightstreamer.ls_proxy.connection");

    ConnectionHandler(PushListener listener, long connectionTimeoutMillis) {
        this.eventsListener = listener;
        this.connectionTimeoutMillis = connectionTimeoutMillis;
        this.subscrHelper = new SubscrHandler(this.phase, null, this.eventsListener);
    }

    final synchronized boolean isConnected() {
        return this.connected;
    }

    final boolean isPolling() {
        return this.pushServerListener.isPolling();
    }

    final synchronized int getPhase() {
        return this.phase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void prepareConnection(final ConnectionInfo info) throws ConnectException {
        final Outcome outcome = new Outcome();
        final LSClient newPushServerClient = new LSClient();
        final ExtendedConnectionListener newPushServerListener = new ExtendedConnectionListener();
        Object object = this;
        synchronized (object) {
            if (this.giveupPending) {
                ConnectionException exc = new ConnectionException(2);
                throw new ConnectException(this.phase, exc);
            }
            outcome.refPhase = this.phase;
            this.monitorPending = outcome;
        }
        new Thread("Background connection opening"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    connLogger.finer("Opening new connection");
                    newPushServerClient.openConnection(info, newPushServerListener);
                    Outcome outcome2 = outcome;
                    synchronized (outcome2) {
                        if (outcome.consumed) {
                            connLogger.finer("Connection no longer required; closing");
                            newPushServerClient.closeConnection();
                        }
                        outcome.completed = true;
                        outcome.notify();
                    }
                }
                catch (PushConnException e) {
                    Outcome outcome3 = outcome;
                    synchronized (outcome3) {
                        outcome.error = new ConnectException(outcome.refPhase, e);
                        outcome.notify();
                    }
                }
                catch (PushServerException e) {
                    Outcome outcome4 = outcome;
                    synchronized (outcome4) {
                        outcome.error = new ConnectException(outcome.refPhase, e);
                        outcome.notify();
                    }
                }
                catch (PushUserException e) {
                    Outcome outcome5 = outcome;
                    synchronized (outcome5) {
                        outcome.error = new ConnectException(outcome.refPhase, e);
                        outcome.notify();
                    }
                }
            }
        }.start();
        object = outcome;
        synchronized (object) {
            long now = System.currentTimeMillis();
            long limit = now + this.connectionTimeoutMillis;
            while (!outcome.completed && outcome.error == null && now < limit) {
                try {
                    outcome.wait(limit - now);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                now = System.currentTimeMillis();
            }
            ConnectionHandler e = this;
            synchronized (e) {
                this.monitorPending = null;
            }
            outcome.consumed = true;
            if (!outcome.completed) {
                ConnectionException exc;
                newPushServerListener.fail();
                if (outcome.error != null) {
                    connLogger.finer("Failed to open new connection");
                    throw outcome.error;
                }
                if (newPushServerListener.isEstablished()) {
                    connLogger.finer("Timeout while listening to the new connection");
                    exc = new ConnectionException(4);
                    throw new ConnectException(outcome.refPhase, exc);
                }
                connLogger.finer("Timeout while opening new connection");
                exc = new ConnectionException(1);
                throw new ConnectException(outcome.refPhase, exc);
            }
            connLogger.finer("Opened new connection");
            this.pushServerClient = newPushServerClient;
            this.pushServerListener = newPushServerListener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void giveupConnecting() {
        Outcome currOutcome;
        Object object = this;
        synchronized (object) {
            this.giveupPending = true;
            currOutcome = this.monitorPending;
        }
        if (currOutcome != null) {
            object = currOutcome;
            synchronized (object) {
                if (!currOutcome.consumed) {
                    connLogger.finer("Give up opening a new connection");
                }
                currOutcome.consumed = true;
                ConnectionException exc = new ConnectionException(2);
                currOutcome.error = new ConnectException(currOutcome.refPhase, exc);
                currOutcome.notify();
            }
        }
    }

    synchronized void startConnection() {
        ++this.phase;
        this.connected = true;
        this.subscrHelper = new SubscrHandler(this.phase, this.pushServerClient, this.eventsListener);
        this.pushServerListener.open(this.phase);
    }

    synchronized void stopConnection() {
        this.connected = false;
        ++this.phase;
        this.subscrHelper = new SubscrHandler(this.phase, null, this.eventsListener);
        this.giveupPending = false;
    }

    void destroyConnection() {
        if (this.pushServerClient != null) {
            final LSClient oldPushServerClient = this.pushServerClient;
            this.pushServerClient = null;
            new Thread("Background connection close"){

                public void run() {
                    connLogger.finer("Closing connection");
                    oldPushServerClient.closeConnection();
                }
            }.start();
        }
    }

    synchronized void prepareBatch() {
        this.subscrHelper.prepareBatch();
        this.batchContext = this.subscrHelper;
    }

    synchronized void doSubscr(Item[] items, String[] fields) {
        if (this.batchContext == null || this.batchContext != this.subscrHelper) {
            // empty if block
        }
        this.subscrHelper.doSubscr(items, fields);
    }

    synchronized void doResubscr(Item[] items, SubscribedTableKey[] tableKeys, String[] fields) throws SubscrHandler.TableKeyException {
        if (this.batchContext == null || this.batchContext != this.subscrHelper) {
            // empty if block
        }
        this.subscrHelper.doResubscr(items, tableKeys, fields);
    }

    synchronized void doDelete(Item[] items, SubscribedTableKey[] tableKeys) throws SubscrHandler.TableKeyException {
        if (this.batchContext == null || this.batchContext != this.subscrHelper) {
            // empty if block
        }
        this.subscrHelper.doDelete(items, tableKeys);
    }

    synchronized void doConstrain(ConnectionConstraints constraints) {
        this.subscrHelper.doConstrain(constraints);
    }

    synchronized void completeBatch() {
        this.batchContext.completeBatch();
        this.batchContext = null;
    }

    private class ExtendedConnectionListener
    implements ConnectionListener {
        private int currPhase;
        private boolean established = false;
        private boolean started = false;
        private boolean polling = true;
        private boolean opened = false;
        private boolean failed = false;

        private ExtendedConnectionListener() {
        }

        private boolean checkForwarding() {
            while (!this.opened && !this.failed) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return this.opened;
        }

        public synchronized void open(int phase) {
            while (!this.started && !this.failed) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.opened = true;
            this.currPhase = phase;
            this.notifyAll();
        }

        public synchronized void fail() {
            this.failed = true;
            this.notifyAll();
        }

        public synchronized boolean isEstablished() {
            return this.established;
        }

        public synchronized boolean isPolling() {
            return this.polling;
        }

        public synchronized void onConnectionEstablished() {
            this.established = true;
        }

        public synchronized void onSessionStarted(boolean isPolling) {
            this.started = true;
            this.polling = isPolling;
            this.notifyAll();
        }

        public void onNewBytes(long bytes) {
            ConnectionHandler.this.eventsListener.onNewBytes(bytes);
        }

        public synchronized void onDataError(PushServerException e) {
            if (this.checkForwarding()) {
                ConnectionHandler.this.eventsListener.onPushFailure(this.currPhase, new PushException(e));
            }
        }

        public synchronized void onEnd(int cause) {
            if (this.checkForwarding()) {
                ConnectionHandler.this.eventsListener.onPushEnd(this.currPhase, cause);
            }
        }

        public synchronized void onActivityWarning(boolean warningOn) {
            if (this.checkForwarding()) {
                ConnectionHandler.this.eventsListener.onActivityWarning(this.currPhase, warningOn);
            }
        }

        public void onClose() {
        }

        public synchronized void onFailure(PushServerException e) {
            if (this.checkForwarding()) {
                ConnectionHandler.this.eventsListener.onPushFailure(this.currPhase, new PushException(e));
            }
        }

        public synchronized void onFailure(PushConnException e) {
            if (this.checkForwarding()) {
                ConnectionHandler.this.eventsListener.onPushFailure(this.currPhase, new PushException(e));
            }
        }
    }

    private static class Outcome {
        public int refPhase;
        public boolean consumed = false;
        public boolean completed = false;
        public ConnectException error = null;

        private Outcome() {
        }
    }
}

