/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.ls_proxy;

public class ConnectionException
extends Exception {
    public static final int SERVER_TIMEOUT = 1;
    public static final int GIVEN_UP = 2;
    public static final int OBSOLETE_REQUEST = 3;
    public static final int ANSWER_TIMEOUT = 4;
    public static final int INCOMPATIBLE_REQUEST = 5;
    public static final int UNEXPECTED_ERROR = 6;
    private int errorCode;
    private static final String[] defaultMsgs = new String[]{"Unspecified error", "Server Connection Timeout", "Connection given up", "Connection request was obsolete", "Server answer timeout", "Parameters incompatible with current connection", "Unexpected error while connecting"};

    public ConnectionException(int errorCode) {
        super(ConnectionException.getMsg(errorCode, null));
        this.errorCode = errorCode;
    }

    public ConnectionException(int errorCode, String extraMsg) {
        super(ConnectionException.getMsg(errorCode, extraMsg));
        this.errorCode = errorCode;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    private static String getMsg(int errorCode, String extraMsg) {
        String msg = defaultMsgs[0];
        if (errorCode > 0 && errorCode < defaultMsgs.length) {
            msg = defaultMsgs[errorCode];
        }
        if (extraMsg != null) {
            msg = msg + ": " + extraMsg;
        }
        return msg;
    }
}

