/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.ls_proxy;

import com.lightstreamer.ls_proxy.BandwidthEvent;
import com.lightstreamer.ls_proxy.BandwidthListener;
import com.lightstreamer.ls_proxy.ConnectionHandler;
import com.lightstreamer.ls_proxy.MiniMap;
import java.util.Timer;
import java.util.TimerTask;

class BWMonitor {
    private final ConnectionHandler subscrHandler;
    private long newBytes;
    private long lastCheck;
    private double lastBW = 0.0;
    private final MiniMap listeners = new MiniMap();
    private Timer monitor = null;
    private final long monitorPeriodMillis;

    BWMonitor(long monitorPeriodMillis, ConnectionHandler subscrHandler) {
        this.subscrHandler = subscrHandler;
        this.monitorPeriodMillis = monitorPeriodMillis;
    }

    private static boolean checkTimer(Timer timer) {
        if (timer == null) {
            return false;
        }
        TimerTask probeTask = new TimerTask(){

            public void run() {
            }
        };
        try {
            timer.schedule(probeTask, 1000L);
        }
        catch (IllegalStateException e) {
            return false;
        }
        return true;
    }

    synchronized void ensureRunning() {
        if (this.monitorPeriodMillis > 0L && !BWMonitor.checkTimer(this.monitor)) {
            this.monitor = new Timer(true);
            TimerTask task = new TimerTask(){

                public void run() {
                    try {
                        BWMonitor.this.signalBW();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            this.lastCheck = System.currentTimeMillis();
            this.newBytes = 0L;
            this.monitor.scheduleAtFixedRate(task, this.monitorPeriodMillis, this.monitorPeriodMillis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addListener(BandwidthListener bwListener) {
        MiniMap miniMap = this.listeners;
        synchronized (miniMap) {
            BWListenerData data = (BWListenerData)this.listeners.get(bwListener);
            if (data != null) {
                ++data.count;
            } else {
                this.listeners.put(bwListener, new BWListenerData(bwListener));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeListener(BandwidthListener bwListener) {
        MiniMap miniMap = this.listeners;
        synchronized (miniMap) {
            BWListenerData data = (BWListenerData)this.listeners.get(bwListener);
            --data.count;
            if (data.count == 0) {
                this.listeners.remove(bwListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalBW() {
        double bw = this.computeBW();
        boolean pushing = this.subscrHandler != null ? this.subscrHandler.isConnected() : false;
        BandwidthEvent event = new BandwidthEvent(pushing, bw);
        MiniMap miniMap = this.listeners;
        synchronized (miniMap) {
            for (BWListenerData data : this.listeners.values()) {
                try {
                    data.listener.bwUpdate(event);
                }
                catch (Throwable t) {}
            }
        }
    }

    private synchronized double computeBW() {
        long bytes = this.newBytes;
        this.newBytes = 0L;
        long checkTime = this.lastCheck;
        this.lastCheck = System.currentTimeMillis();
        double secs = (double)(this.lastCheck - checkTime) / 1000.0;
        this.lastBW = (double)(bytes * 8L) / 1000.0 / secs;
        return this.lastBW;
    }

    synchronized void addBytes(long count) {
        this.newBytes += count;
    }

    private static class BWListenerData {
        public BandwidthListener listener;
        public int count;

        public BWListenerData(BandwidthListener listener) {
            this.listener = listener;
            this.count = 1;
        }
    }
}

