/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.ls_client;

import com.lightstreamer.ls_client.ExtendedTableInfo;
import com.lightstreamer.ls_client.FullTableManager;
import com.lightstreamer.ls_client.HandyTableListener;
import com.lightstreamer.ls_client.PushServerException;
import com.lightstreamer.ls_client.ServerUpdateEvent;
import com.lightstreamer.ls_client.TableManager;
import java.util.logging.Logger;

class VirtualTableManager
implements TableManager {
    private ExtendedTableInfo table;
    private FullTableManager managerWithListener = null;
    private static Logger actionsLogger = Logger.getLogger("com.lightstreamer.ls_client.actions");

    VirtualTableManager(ExtendedTableInfo table, HandyTableListener listener) {
        this.table = (ExtendedTableInfo)table.clone();
        this.managerWithListener = new FullTableManager(table, listener, false);
    }

    public void doUpdate(ServerUpdateEvent values) throws PushServerException {
        throw new PushServerException(12);
    }

    public void notifyUnsub() {
    }

    public String getGroup() {
        return this.table.group;
    }

    public String getMode() {
        return this.table.mode;
    }

    public String getSchema() {
        return this.table.schema;
    }

    public String getDataAdapter() {
        return this.table.dataAdapter;
    }

    public String getSelector() {
        return this.table.selector;
    }

    public boolean isSnapshot() {
        return this.table.snapshot;
    }

    public Integer getDistinctSnapshotLength() {
        return this.table.distinctSnapshotLength;
    }

    public Integer getStart() {
        return this.table.start;
    }

    public Integer getEnd() {
        return this.table.end;
    }

    public Integer getMaxBufferSize() {
        return this.table.bufferSize;
    }

    public Double getMaxFrequency() {
        return this.table.maxFrequency;
    }

    public boolean isUnfiltered() {
        return this.table.unfiltered;
    }

    public int getNumItems() {
        return this.table.items.length;
    }

    public String getItemName(int i) {
        return this.table.items[i];
    }

    public MonoTableManager getItemManager(int i) {
        return new MonoTableManager(i);
    }

    public String toString() {
        return this.getMode() + " items [" + this.getGroup() + "] with fields [" + this.getSchema() + "]";
    }

    private class MonoTableManager
    implements TableManager {
        private int itemIndex;

        public MonoTableManager(int itemIndex) {
            this.itemIndex = itemIndex;
        }

        public String getGroup() {
            return ((VirtualTableManager)VirtualTableManager.this).table.items[this.itemIndex];
        }

        public String getMode() {
            return VirtualTableManager.this.getMode();
        }

        public String getSchema() {
            return VirtualTableManager.this.getSchema();
        }

        public String getDataAdapter() {
            return ((VirtualTableManager)VirtualTableManager.this).table.dataAdapter;
        }

        public String getSelector() {
            return ((VirtualTableManager)VirtualTableManager.this).table.selector;
        }

        public boolean isSnapshot() {
            return VirtualTableManager.this.isSnapshot();
        }

        public Integer getDistinctSnapshotLength() {
            return VirtualTableManager.this.getDistinctSnapshotLength();
        }

        public Integer getStart() {
            return null;
        }

        public Integer getEnd() {
            return null;
        }

        public Integer getMaxBufferSize() {
            return VirtualTableManager.this.getMaxBufferSize();
        }

        public Double getMaxFrequency() {
            return VirtualTableManager.this.getMaxFrequency();
        }

        public boolean isUnfiltered() {
            return VirtualTableManager.this.isUnfiltered();
        }

        public void doUpdate(ServerUpdateEvent values) throws PushServerException {
            int itemPos = values.getItemCode();
            if (itemPos != 1) {
                throw new PushServerException(2);
            }
            VirtualTableManager.this.managerWithListener.processUpdate(values, this.itemIndex + 1, this.itemIndex);
        }

        public void notifyUnsub() {
            int itemPos = this.itemIndex + 1;
            String itemName = ((VirtualTableManager)VirtualTableManager.this).table.items[this.itemIndex];
            VirtualTableManager.this.managerWithListener.notifyUnsubForItem(itemPos, itemName);
        }

        public String toString() {
            return this.getMode() + " item " + this.getGroup() + " with fields [" + this.getSchema() + "]";
        }
    }
}

