/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.ls_client;

import com.lightstreamer.ls_client.FullTableManager;
import com.lightstreamer.ls_client.ServerUpdateEvent;
import com.lightstreamer.ls_client.UpdateInfo;
import java.util.Map;

class UpdateInfoImpl
implements UpdateInfo {
    private final FullTableManager.ItemInfo info;
    private final String[] prevState;
    private final String[] updEvent;
    private final boolean isSnapshot;

    UpdateInfoImpl(FullTableManager.ItemInfo info, String[] prevState, String[] updEvent, boolean isSnapshot) {
        this.info = info;
        this.prevState = prevState;
        this.updEvent = updEvent;
        this.isSnapshot = isSnapshot;
    }

    public int getItemPos() {
        return this.info.pos;
    }

    public String getItemName() {
        return this.info.name;
    }

    public boolean isValueChanged(int fieldPos) {
        return this.updEvent[this.getIndex(fieldPos)] != ServerUpdateEvent.UNCHANGED;
    }

    public boolean isValueChanged(String fieldName) {
        return this.updEvent[this.getIndex(fieldName)] != ServerUpdateEvent.UNCHANGED;
    }

    public String getNewValue(int fieldPos) {
        int index = this.getIndex(fieldPos);
        String val = this.updEvent[index];
        if (val != ServerUpdateEvent.UNCHANGED) {
            return val;
        }
        return this.prevState[index];
    }

    public String getNewValue(String fieldName) {
        int index = this.getIndex(fieldName);
        String val = this.updEvent[index];
        if (val != ServerUpdateEvent.UNCHANGED) {
            return val;
        }
        return this.prevState[index];
    }

    public String getOldValue(int fieldPos) {
        return this.prevState[this.getIndex(fieldPos)];
    }

    public String getOldValue(String fieldName) {
        return this.prevState[this.getIndex(fieldName)];
    }

    public int getNumFields() {
        return this.prevState.length;
    }

    public boolean isSnapshot() {
        return this.isSnapshot;
    }

    private int getIndex(int fieldPos) throws IllegalArgumentException {
        if (fieldPos <= 0 || fieldPos > this.prevState.length) {
            throw new IllegalArgumentException();
        }
        return fieldPos - 1;
    }

    private int getIndex(String fieldName) throws IllegalArgumentException {
        Map indexMap = this.info.getFieldIndexMap();
        if (indexMap == null) {
            throw new IllegalArgumentException();
        }
        Integer index = (Integer)indexMap.get(fieldName);
        if (index == null) {
            throw new IllegalArgumentException();
        }
        return index;
    }

    public String toString() {
        int last = this.updEvent.length - 1;
        if (last < 0) {
            return "[]";
        }
        StringBuffer b = new StringBuffer();
        b.append("[ ");
        int i = 0;
        while (true) {
            String val;
            if ((val = this.updEvent[i]) == ServerUpdateEvent.UNCHANGED) {
                b.append('(');
                b.append(this.prevState[i]);
                b.append(')');
            } else {
                b.append(val);
            }
            if (i == last) {
                b.append(" ]");
                return b.toString();
            }
            b.append(", ");
            ++i;
        }
    }
}

