/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.ls_client;

import com.lightstreamer.ls_client.SubscrException;

public class SimpleTableInfo
implements Cloneable {
    public static final String MERGE = "MERGE";
    public static final String DISTINCT = "DISTINCT";
    public static final String RAW = "RAW";
    public static final String COMMAND = "COMMAND";
    final String group;
    final String mode;
    final String schema;
    String dataAdapter = null;
    String selector = null;
    final boolean snapshot;
    Integer distinctSnapshotLength = null;
    Integer start = null;
    Integer end = null;
    Integer bufferSize = null;
    Double maxFrequency = null;
    boolean unfiltered = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SimpleTableInfo(String group, String mode, String schema, boolean snap) throws SubscrException {
        this.group = group;
        this.mode = mode;
        this.schema = schema;
        if (snap) {
            if (!mode.equals(MERGE) && !mode.equals(DISTINCT) && !mode.equals(COMMAND)) throw new SubscrException("Snapshot ineffective for mode " + mode);
            this.snapshot = true;
            return;
        } else {
            this.snapshot = false;
        }
    }

    public String getGroup() {
        return this.group;
    }

    public String getMode() {
        return this.mode;
    }

    public String getSchema() {
        return this.schema;
    }

    public boolean isSnapshot() {
        return this.snapshot;
    }

    public void setDataAdapter(String dataAdapter) {
        this.dataAdapter = dataAdapter;
    }

    public String getDataAdapter() {
        return this.dataAdapter;
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }

    public String getSelector() {
        return this.selector;
    }

    public void setRange(int start, int end) {
        this.start = new Integer(start);
        this.end = new Integer(end);
    }

    public int getStart() {
        return this.start != null ? this.start : 0;
    }

    public int getEnd() {
        return this.end != null ? this.end : 0;
    }

    public void setRequestedBufferSize(int bufferSize) throws SubscrException {
        if (!this.mode.equals(MERGE) && !this.mode.equals(DISTINCT)) {
            throw new SubscrException("Buffer size ineffective for mode " + this.mode);
        }
        this.bufferSize = new Integer(bufferSize);
    }

    public int getBufferSize() {
        return this.bufferSize != null ? this.bufferSize : -1;
    }

    public void setRequestedMaxFrequency(double maxFrequency) throws SubscrException {
        if (!(this.mode.equals(MERGE) || this.mode.equals(DISTINCT) || this.mode.equals(COMMAND))) {
            throw new SubscrException("Max frequency ineffective for mode " + this.mode);
        }
        this.maxFrequency = new Double(maxFrequency);
    }

    public double getRequestedMaxFrequency() {
        return this.maxFrequency != null ? this.maxFrequency : 0.0;
    }

    public void requestUnfilteredDispatching() throws SubscrException {
        if (!(this.mode.equals(MERGE) || this.mode.equals(DISTINCT) || this.mode.equals(COMMAND))) {
            throw new SubscrException("Unfiltered dispatching cannot be specified for mode " + this.mode);
        }
        this.unfiltered = true;
    }

    public boolean isUnfilteredDispatching() {
        return this.unfiltered;
    }

    public void setRequestedDistinctSnapshotLength(int snapshotLength) throws SubscrException {
        if (this.mode.equals(DISTINCT)) {
            if (!this.snapshot) {
                throw new SubscrException("Snapshot not requested for the item");
            }
        } else {
            throw new SubscrException("Snapshot length ineffective for mode " + this.mode);
        }
        this.distinctSnapshotLength = new Integer(snapshotLength);
    }

    public int getDistinctSnapshotLength() {
        return this.distinctSnapshotLength != null ? this.distinctSnapshotLength : 0;
    }

    boolean hasUnfilteredData() {
        if (this.mode.equals(RAW) || this.unfiltered) {
            return true;
        }
        return this.mode.equals(COMMAND);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

