/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.ls_client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ServerUpdateEvent {
    static final String UNCHANGED = new String("UNCHANGED");
    private String tableCode = null;
    private String itemCode = null;
    private ArrayList<String> values = null;
    private boolean eos = false;
    private int overflow = 0;
    private int messageProg = 0;
    private String messageSequence = null;
    private int errorCode = 0;
    private String errorMessage = null;

    ServerUpdateEvent(String tableCode, String itemCode) {
        this.tableCode = tableCode;
        this.itemCode = itemCode;
        this.values = new ArrayList();
    }

    ServerUpdateEvent(String tableCode, String itemCode, boolean eos) {
        this.tableCode = tableCode;
        this.itemCode = itemCode;
        this.eos = eos;
        if (!eos) {
            this.values = new ArrayList();
        }
    }

    ServerUpdateEvent(String tableCode, String itemCode, int overflow) {
        this.tableCode = tableCode;
        this.itemCode = itemCode;
        this.overflow = overflow;
    }

    ServerUpdateEvent(String messageSequence, int messageProg) {
        this.messageSequence = messageSequence;
        this.messageProg = messageProg;
    }

    ServerUpdateEvent(String messageSequence, int messageProg, int errorCode, String errorMessage) {
        this.messageSequence = messageSequence;
        this.messageProg = messageProg;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    boolean isTableUpdate() {
        return this.tableCode != null;
    }

    Integer getTableCode() {
        if (this.tableCode == null) {
            return null;
        }
        return new Integer(this.tableCode);
    }

    Integer getItemCode() {
        if (this.itemCode == null) {
            return null;
        }
        return new Integer(this.itemCode);
    }

    int getOverflow() {
        return this.overflow;
    }

    boolean isEOS() {
        return this.eos;
    }

    void addValue(String value) {
        this.values.add(value);
    }

    int getSize() {
        return this.values.size();
    }

    String getValue(int pos) {
        return this.values.get(pos);
    }

    Map<String, String> getMap(String[] fieldNames) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < fieldNames.length; ++i) {
            String value = this.values.get(i);
            if (value == UNCHANGED) continue;
            map.put(fieldNames[i], value);
        }
        return map;
    }

    String[] getArray() {
        String[] array = new String[this.values.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.values.get(i);
        }
        return array;
    }

    int getMessageProg() {
        return this.messageProg;
    }

    String getMessageSequence() {
        return this.messageSequence;
    }

    int getErrorCode() {
        return this.errorCode;
    }

    String getErrorMessage() {
        return this.errorMessage;
    }

    public String toString() {
        if (this.isTableUpdate()) {
            return "event for item n\u00b0" + this.itemCode + " in table n\u00b0" + this.tableCode + " with values " + this.values;
        }
        return "event for message n\u00b0" + this.messageProg + " in sequence " + this.messageSequence + " with error message (if any): " + this.errorMessage;
    }
}

