/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.ls_client;

import com.lightstreamer.ls_client.BatchMonitor;
import com.lightstreamer.ls_client.ConnectionConstraints;
import com.lightstreamer.ls_client.ConnectionInfo;
import com.lightstreamer.ls_client.HttpProvider;
import com.lightstreamer.ls_client.MessageManager;
import com.lightstreamer.ls_client.MessageParallelizer;
import com.lightstreamer.ls_client.PhaseException;
import com.lightstreamer.ls_client.PushConnException;
import com.lightstreamer.ls_client.PushEndException;
import com.lightstreamer.ls_client.PushLengthException;
import com.lightstreamer.ls_client.PushServerException;
import com.lightstreamer.ls_client.PushServerProxy;
import com.lightstreamer.ls_client.PushUserException;
import com.lightstreamer.ls_client.SequenceHandler;
import com.lightstreamer.ls_client.SequencesHandler;
import com.lightstreamer.ls_client.ServerUpdateEvent;
import com.lightstreamer.ls_client.SubscrException;
import com.lightstreamer.ls_client.SubscribedTableKey;
import com.lightstreamer.ls_client.SubscriptionConstraints;
import com.lightstreamer.ls_client.TableManager;
import com.lightstreamer.ls_client.VirtualTableManager;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

class ServerManager {
    private final ActivityController activityController;
    private final PushServerProxy localPushServerProxy;
    private final ServerListener serverListener;
    private final HashMap<Integer, TableManager> tables = new HashMap();
    private final ConnectionInfo connInfo;
    private final BatchMonitor batchMonitor = new BatchMonitor();
    private final BatchMonitor mexBatchMonitor = new BatchMonitor();
    private final SequencesHandler sequencesHandler = new SequencesHandler();
    private final MessageParallelizer mexParallelizer = new MessageParallelizer(this.mexBatchMonitor, this);
    private static Logger streamLogger = Logger.getLogger("com.lightstreamer.ls_client.stream");
    private static Logger sessionLogger = Logger.getLogger("com.lightstreamer.ls_client.session");
    private static Logger actionsLogger = Logger.getLogger("com.lightstreamer.ls_client.actions");
    private static Logger protLogger = Logger.getLogger("com.lightstreamer.ls_client.protocol");
    private static Timer activityTimer;
    private static final Executor notificationsSender;

    static final ExecutorService createSingleThreadExecutor(final String name) {
        return Executors.newSingleThreadExecutor(new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, name);
                t.setDaemon(true);
                return t;
            }
        });
    }

    ServerManager(ConnectionInfo info, ServerListener asyncListener) throws PushConnException {
        this.connInfo = info;
        this.localPushServerProxy = new PushServerProxy(info);
        this.activityController = new ActivityController();
        this.serverListener = asyncListener;
        ServerManager.prepareTimers();
    }

    void connect() throws PushConnException, PushServerException, PushUserException {
        boolean badEnd = true;
        this.activityController.startConnection(true);
        InputStream stream = null;
        try {
            stream = this.localPushServerProxy.connectForSession();
            this.serverListener.onConnectionEstablished();
            this.localPushServerProxy.startSession(stream);
            this.serverListener.onSessionStarted(this.localPushServerProxy.getSessionId(), this.connInfo.isPolling, this.localPushServerProxy.getControlLink());
            badEnd = false;
        }
        catch (PhaseException e) {
        }
        catch (PushConnException e) {
            actionsLogger.finer("Notifying an exception on the current connection");
            this.serverListener.onConnectException(new Exception(e));
            throw e;
        }
        catch (PushServerException e) {
            actionsLogger.finer("Notifying an exception on the current connection");
            this.serverListener.onConnectException(new Exception(e));
            throw e;
        }
        catch (PushUserException e) {
            actionsLogger.finer("Notifying an exception on the current connection");
            this.serverListener.onConnectException(new Exception(e));
            throw e;
        }
        finally {
            this.activityController.stopConnection();
            if (badEnd) {
                streamLogger.finer("Closing create connection");
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (Throwable t) {
                    streamLogger.log(Level.FINER, "Error closing create connection", t);
                }
            }
        }
    }

    void start() {
        SessionActivityManager myActivity = new SessionActivityManager();
        myActivity.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TableManager[] close() {
        TableManager[] zombieTables;
        this.activityController.onCloseRequested();
        HashMap<Integer, TableManager> hashMap = this.tables;
        synchronized (hashMap) {
            zombieTables = this.tables.values().toArray(new TableManager[0]);
            this.tables.clear();
        }
        this.abortPendingMessages();
        sessionLogger.fine("Terminating session " + this.localPushServerProxy.getSessionId());
        this.localPushServerProxy.dispose(true);
        this.closeBatch();
        this.closeMessageBatch();
        if (actionsLogger.isLoggable(Level.FINE)) {
            for (int i = 0; i < zombieTables.length; ++i) {
                actionsLogger.fine("Discarded " + zombieTables[i] + " from session " + this.localPushServerProxy.getSessionId());
            }
        }
        return zombieTables;
    }

    void sendMessage(String message) throws PhaseException, PushConnException, PushServerException, PushUserException {
        this.localPushServerProxy.sendMessage(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int sendMessage(MessageManager message, boolean sendAsynchronously) throws PhaseException, PushConnException, PushServerException, PushUserException, SubscrException {
        int prog = 0;
        SequencesHandler sequencesHandler = this.sequencesHandler;
        synchronized (sequencesHandler) {
            prog = this.sequencesHandler.getSequence(message.getSequence()).enqueue(message);
        }
        if (sendAsynchronously) {
            if (!this.mexBatchMonitor.isUnlimited()) {
                this.batchMessageRequests(0);
            }
            this.mexParallelizer.enqueueMessage(message, prog);
            return prog;
        }
        this.sendMessage(message, prog);
        return prog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendMessage(MessageManager message, int prog) throws PhaseException, PushConnException, PushServerException, PushUserException, SubscrException {
        boolean ok = false;
        Exception problem = null;
        try {
            this.localPushServerProxy.requestSendMessage(message, prog, this.mexBatchMonitor);
            ok = true;
        }
        catch (PhaseException e) {
            problem = e;
            throw e;
        }
        catch (PushConnException e) {
            problem = e;
            throw e;
        }
        catch (PushServerException e) {
            problem = e;
            throw e;
        }
        catch (PushUserException e) {
            problem = e;
            throw e;
        }
        catch (SubscrException e) {
            problem = e;
            throw e;
        }
        finally {
            if (!ok) {
                actionsLogger.fine("Undoing sending of " + message + " to session " + this.localPushServerProxy.getSessionId());
                SequencesHandler sequencesHandler = this.sequencesHandler;
                synchronized (sequencesHandler) {
                    SequenceHandler seq = this.sequencesHandler.getSequence(message.getSequence());
                    if (message != null) {
                        this.serverListener.onMessageOutcome(message, seq, null, problem);
                    }
                }
            }
        }
    }

    void changeConstraints(ConnectionConstraints constraints) throws PhaseException, PushConnException, PushServerException {
        this.localPushServerProxy.requestNewConstraints(constraints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SubscribedTableKey subscrTable(TableManager table, boolean batchable) throws PhaseException, PushConnException, PushServerException, PushUserException, SubscrException {
        SubscribedTableKey subscrKey;
        actionsLogger.fine("Adding " + table + " to session " + this.localPushServerProxy.getSessionId());
        HashMap<Integer, TableManager> hashMap = this.tables;
        synchronized (hashMap) {
            subscrKey = this.localPushServerProxy.getTableCode();
            this.tables.put(subscrKey.getKeyValue(), table);
        }
        boolean ok = false;
        try {
            this.localPushServerProxy.requestSubscr(table, subscrKey, batchable ? this.batchMonitor : null);
            ok = true;
        }
        finally {
            if (!ok) {
                actionsLogger.fine("Undoing add of " + table + " to session " + this.localPushServerProxy.getSessionId());
                HashMap<Integer, TableManager> hashMap2 = this.tables;
                synchronized (hashMap2) {
                    this.tables.remove(subscrKey.getKeyValue());
                }
            }
        }
        return subscrKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SubscribedTableKey[] subscrItems(VirtualTableManager table, boolean batchable) throws PhaseException, PushConnException, PushServerException, PushUserException, SubscrException {
        if (table.getNumItems() == 0) {
            if (batchable) {
                this.unbatchRequest();
            }
            return new SubscribedTableKey[0];
        }
        SubscribedTableKey[] subscrKeys = new SubscribedTableKey[table.getNumItems()];
        actionsLogger.fine("Adding " + table + " to session " + this.localPushServerProxy.getSessionId());
        HashMap<Integer, TableManager> hashMap = this.tables;
        synchronized (hashMap) {
            for (int i = 0; i < table.getNumItems(); ++i) {
                subscrKeys[i] = this.localPushServerProxy.getTableCode();
                this.tables.put(subscrKeys[i].getKeyValue(), table.getItemManager(i));
            }
        }
        boolean ok = false;
        try {
            this.localPushServerProxy.requestItemsSubscr(table, subscrKeys, batchable ? this.batchMonitor : null);
            ok = true;
        }
        finally {
            if (!ok) {
                actionsLogger.fine("Undoing add of " + table + " to session " + this.localPushServerProxy.getSessionId());
                HashMap<Integer, TableManager> hashMap2 = this.tables;
                synchronized (hashMap2) {
                    for (int i = 0; i < subscrKeys.length; ++i) {
                        this.tables.remove(subscrKeys[i].getKeyValue());
                    }
                }
            }
        }
        return subscrKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TableManager[] findTables(SubscribedTableKey[] subscrKeys) {
        TableManager[] infos = new TableManager[subscrKeys.length];
        HashMap<Integer, TableManager> hashMap = this.tables;
        synchronized (hashMap) {
            for (int i = 0; i < subscrKeys.length; ++i) {
                Integer key = subscrKeys[i].getKeyValue();
                infos[i] = key != null ? this.tables.get(subscrKeys[i].getKeyValue()) : null;
            }
        }
        return infos;
    }

    void constrainTables(SubscribedTableKey[] subscrKeys, SubscriptionConstraints constraints) throws PhaseException, PushConnException, PushServerException, SubscrException {
        if (subscrKeys.length == 0) {
            return;
        }
        this.localPushServerProxy.constrainSubscrs(subscrKeys, constraints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TableManager[] detachTables(SubscribedTableKey[] subscrKeys) {
        TableManager[] infos = new TableManager[subscrKeys.length];
        HashMap<Integer, TableManager> hashMap = this.tables;
        synchronized (hashMap) {
            for (int i = 0; i < subscrKeys.length; ++i) {
                Integer key = subscrKeys[i].getKeyValue();
                infos[i] = key != null ? this.tables.remove(subscrKeys[i].getKeyValue()) : null;
            }
        }
        if (actionsLogger.isLoggable(Level.FINE)) {
            for (int i = 0; i < subscrKeys.length; ++i) {
                if (infos[i] == null) continue;
                actionsLogger.fine("Removed " + infos[i] + " from session " + this.localPushServerProxy.getSessionId());
            }
        }
        return infos;
    }

    void unsubscrTables(SubscribedTableKey[] subscrKeys, boolean batchable) throws PhaseException, PushConnException, PushServerException, SubscrException {
        if (subscrKeys.length == 0) {
            if (batchable) {
                this.unbatchRequest();
            }
            return;
        }
        this.localPushServerProxy.delSubscrs(subscrKeys, batchable ? this.batchMonitor : null);
    }

    void batchRequests(int batchSize) throws PhaseException {
        this.batchRequests(batchSize, this.batchMonitor, false);
    }

    void batchMessageRequests(int batchSize) throws PhaseException {
        this.batchRequests(batchSize, this.mexBatchMonitor, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void batchRequests(int batchSize, BatchMonitor monitor, boolean messageBatch) throws PhaseException {
        BatchMonitor batchMonitor = monitor;
        synchronized (batchMonitor) {
            if (monitor.isFilled()) {
                if (messageBatch) {
                    this.localPushServerProxy.startMessageBatch();
                } else {
                    this.localPushServerProxy.startBatch();
                }
                if (batchSize <= 0) {
                    actionsLogger.finer("Starting a new batch for unlimited requests in session " + this.localPushServerProxy.getSessionId());
                } else {
                    actionsLogger.finer("Starting a new batch for " + batchSize + " requests in session " + this.localPushServerProxy.getSessionId());
                }
            } else if (batchSize <= 0) {
                actionsLogger.finer("Extending the current batch with unlimited requests in session " + this.localPushServerProxy.getSessionId());
            } else {
                actionsLogger.finer("Extending the current batch with " + batchSize + " requests in session " + this.localPushServerProxy.getSessionId());
            }
            monitor.expand(batchSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unbatchRequest() {
        BatchMonitor batchMonitor = this.batchMonitor;
        synchronized (batchMonitor) {
            if (!this.batchMonitor.isFilled()) {
                this.batchMonitor.useOne();
                if (this.batchMonitor.isFilled()) {
                    actionsLogger.finer("Shrinking and executing the current batch in session " + this.localPushServerProxy.getSessionId());
                    this.localPushServerProxy.closeBatch();
                } else {
                    actionsLogger.finer("Shrinking the current batch in session " + this.localPushServerProxy.getSessionId());
                }
            }
        }
    }

    void closeMessageBatch() {
        this.closeBatch(this.mexBatchMonitor, true);
    }

    void closeBatch() {
        this.closeBatch(this.batchMonitor, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeBatch(BatchMonitor monitor, boolean messageBatch) {
        BatchMonitor batchMonitor = monitor;
        synchronized (batchMonitor) {
            actionsLogger.finer("Executing the current batch in session " + this.localPushServerProxy.getSessionId());
            if (messageBatch) {
                this.localPushServerProxy.closeMessageBatch();
            } else {
                this.localPushServerProxy.closeBatch();
            }
            monitor.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableManager getUpdatedTable(ServerUpdateEvent values) {
        HashMap<Integer, TableManager> hashMap = this.tables;
        synchronized (hashMap) {
            return this.tables.get(values.getTableCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void abortPendingMessages() {
        SequencesHandler sequencesHandler = this.sequencesHandler;
        synchronized (sequencesHandler) {
            Iterator<Map.Entry<String, SequenceHandler>> sequences = this.sequencesHandler.reset();
            while (sequences.hasNext()) {
                SequenceHandler sequence = sequences.next().getValue();
                Iterator<Map.Entry<Integer, MessageManager>> toAbort = sequence.iterator();
                while (toAbort.hasNext()) {
                    MessageManager mexToAbort = toAbort.next().getValue();
                    if (mexToAbort.hasOutcome()) continue;
                    this.serverListener.onMessageOutcome(mexToAbort, sequence, null, null);
                }
            }
            this.serverListener.onEndMessages();
        }
    }

    private static synchronized void prepareTimers() {
        if (!ServerManager.checkTimer(activityTimer)) {
            activityTimer = new Timer(true);
        }
    }

    private static boolean checkTimer(Timer timer) {
        if (timer == null) {
            return false;
        }
        TimerTask probeTask = new TimerTask(){

            public void run() {
            }
        };
        try {
            timer.schedule(probeTask, 1000L);
        }
        catch (IllegalStateException e) {
            return false;
        }
        return true;
    }

    private void tableUpdate(ServerUpdateEvent values) {
        TableManager table = this.getUpdatedTable(values);
        if (table == null) {
            if (!this.localPushServerProxy.isTableCodeConsumed(values.getTableCode())) {
                this.serverListener.onDataError(new PushServerException(1));
            }
        } else {
            this.serverListener.onUpdate(table, values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void messageUpdate(ServerUpdateEvent values) {
        if (values.getErrorCode() == 39) {
            this.expandMultipleMessageUpdate(values);
        } else {
            SequencesHandler sequencesHandler = this.sequencesHandler;
            synchronized (sequencesHandler) {
                SequenceHandler seq = this.sequencesHandler.getSequence(values.getMessageSequence());
                MessageManager message = seq.getMessage(values.getMessageProg());
                if (message == null) {
                    this.serverListener.onDataError(new PushServerException(13));
                } else {
                    this.serverListener.onMessageOutcome(message, seq, values, null);
                }
            }
        }
    }

    private void expandMultipleMessageUpdate(ServerUpdateEvent values) {
        int losts = 0;
        boolean ok = false;
        try {
            losts = Integer.parseInt(values.getErrorMessage());
            ok = true;
        }
        catch (NumberFormatException nfe) {
            this.serverListener.onDataError(new PushServerException(7));
        }
        if (ok && losts > 0) {
            for (int next = values.getMessageProg() - losts + 1; next <= values.getMessageProg(); ++next) {
                this.messageUpdate(new ServerUpdateEvent(values.getMessageSequence(), next, 38, "Message discarded"));
            }
        }
    }

    boolean waitEvent(ActivityController activityController) throws PushLengthException {
        try {
            ServerUpdateEvent values;
            try {
                values = this.localPushServerProxy.waitUpdate(activityController);
            }
            catch (PushServerException e) {
                protLogger.log(Level.FINER, "Error in received data", e);
                sessionLogger.severe("Error while listening for data in session " + this.localPushServerProxy.getSessionId());
                this.serverListener.onDataError(e);
                return true;
            }
            if (values != null) {
                if (values.isTableUpdate()) {
                    this.tableUpdate(values);
                } else {
                    this.messageUpdate(values);
                }
                long letti = this.localPushServerProxy.getTotalBytes();
                this.serverListener.onNewBytes(letti - activityController.giaLetti);
                activityController.giaLetti = letti;
            }
            return true;
        }
        catch (PushConnException e) {
            streamLogger.log(Level.FINER, "Error in connection", e);
            sessionLogger.severe("Error while listening for data in session " + this.localPushServerProxy.getSessionId());
            this.serverListener.onFailure(e);
            return false;
        }
        catch (PushEndException e) {
            streamLogger.log(Level.FINER, "Forced connection end", e);
            if (activityController.isCloseUnexpected()) {
                sessionLogger.severe("Connection forcibly closed by the Server in session " + this.localPushServerProxy.getSessionId());
            }
            this.serverListener.onEnd(e.getEndCause());
            return false;
        }
        catch (PhaseException e) {
            sessionLogger.fine("Listening loop closed for session " + this.localPushServerProxy.getSessionId());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean rebind(ActivityController activityController) {
        activityController.startConnection(false);
        try {
            this.localPushServerProxy.resyncSession();
            boolean bl = true;
            return bl;
        }
        catch (PushEndException e) {
            streamLogger.log(Level.FINER, "Forced connection end", e);
            sessionLogger.severe("Connection forcibly closed by the Server while trying to rebind to session " + this.localPushServerProxy.getSessionId());
            this.serverListener.onEnd(e.getEndCause());
        }
        catch (PushServerException e) {
            protLogger.log(Level.FINER, "Error in rebinding to the session", e);
            sessionLogger.severe("Error while trying to rebind to session " + this.localPushServerProxy.getSessionId());
            this.serverListener.onFailure(e);
        }
        catch (PushConnException e) {
            streamLogger.log(Level.FINER, "Error in connection", e);
            sessionLogger.severe("Error while trying to rebind to session " + this.localPushServerProxy.getSessionId());
            this.serverListener.onFailure(e);
        }
        catch (PhaseException e) {
            sessionLogger.fine("Listening loop closed for session " + this.localPushServerProxy.getSessionId());
        }
        finally {
            activityController.stopConnection();
        }
        return false;
    }

    static {
        notificationsSender = ServerManager.createSingleThreadExecutor("Session events queue");
    }

    static interface ServerListener {
        public void onConnectionEstablished();

        public void onSessionStarted(String var1, boolean var2, String var3);

        public boolean onUpdate(TableManager var1, ServerUpdateEvent var2);

        public boolean onMessageOutcome(MessageManager var1, SequenceHandler var2, ServerUpdateEvent var3, Exception var4);

        public void onEndMessages();

        public boolean onNewBytes(long var1);

        public void onStreamingReturned();

        public boolean onActivityWarning(boolean var1);

        public boolean onDataError(PushServerException var1);

        public boolean onEnd(int var1);

        public boolean onReconnectTimeout();

        public void onConnectTimeout();

        public void onConnectException(Exception var1);

        public boolean onFailure(PushServerException var1);

        public boolean onFailure(PushConnException var1);

        public boolean onClose();
    }

    class ActivityController {
        private long lastActivity;
        private boolean warningPending;
        private boolean connectionCheck;
        private boolean isFirstConn;
        private boolean streamingConfirmed;
        private boolean streamingNotified = false;
        private boolean expectingInterruptedConnection = false;
        private int phase = 1;
        private long giaLetti = 0L;

        public ActivityController() {
            this.streamingConfirmed = ((ServerManager)ServerManager.this).connInfo.isPolling;
        }

        public synchronized void onConnectionReturned() {
            if (!((ServerManager)ServerManager.this).connInfo.isPolling && this.streamingConfirmed && !this.streamingNotified) {
                this.onStreamingResponse();
                this.streamingNotified = true;
            }
            this.startKeepalives();
        }

        public synchronized void startKeepalives() {
            this.warningPending = false;
            this.connectionCheck = false;
            this.lastActivity = 0L;
            ++this.phase;
            long checkTime = ServerManager.this.localPushServerProxy.getKeepaliveMillis() + ((ServerManager)ServerManager.this).connInfo.probeWarningMillis;
            this.launch(checkTime, this.phase);
        }

        public synchronized void onActivity() {
            if (this.warningPending) {
                this.onActivityWarning(false);
                this.warningPending = false;
                this.lastActivity = 0L;
                ++this.phase;
                long checkTime = ServerManager.this.localPushServerProxy.getKeepaliveMillis() + ((ServerManager)ServerManager.this).connInfo.probeWarningMillis;
                this.launch(checkTime, this.phase);
            } else {
                this.lastActivity = System.currentTimeMillis();
            }
        }

        public synchronized void onCloseRequested() {
            this.expectingInterruptedConnection = true;
        }

        public synchronized boolean isCloseUnexpected() {
            return !this.expectingInterruptedConnection;
        }

        public synchronized void stopKeepalives() {
            this.onActivity();
            ++this.phase;
        }

        public synchronized void startConnection(boolean isFirstConnect) {
            long checkTime;
            this.connectionCheck = true;
            this.isFirstConn = isFirstConnect;
            ++this.phase;
            if (!isFirstConnect) {
                checkTime = ((ServerManager)ServerManager.this).connInfo.reconnectionTimeoutMillis;
                if (((ServerManager)ServerManager.this).connInfo.isPolling) {
                    checkTime += ((ServerManager)ServerManager.this).connInfo.pollingIdleMillis;
                } else if (!this.streamingConfirmed) {
                    checkTime = ((ServerManager)ServerManager.this).connInfo.streamingTimeoutMillis;
                }
            } else {
                if (((ServerManager)ServerManager.this).connInfo.isPolling) {
                    return;
                }
                if (!this.streamingConfirmed) {
                    checkTime = ((ServerManager)ServerManager.this).connInfo.streamingTimeoutMillis;
                } else {
                    return;
                }
            }
            this.launch(checkTime, this.phase);
        }

        public synchronized void stopConnection() {
            if (!this.isFirstConn) {
                if (!((ServerManager)ServerManager.this).connInfo.isPolling && !this.streamingConfirmed) {
                    this.streamingConfirmed = true;
                }
            } else if (!((ServerManager)ServerManager.this).connInfo.isPolling && !this.streamingConfirmed) {
                this.streamingConfirmed = true;
            }
            ++this.phase;
        }

        public synchronized void onTimeout(int refPhase) {
            if (refPhase != this.phase) {
                return;
            }
            if (this.connectionCheck) {
                this.onConnectionTimeout(this.isFirstConn);
                ++this.phase;
            } else if (this.warningPending) {
                this.onNoActivity();
                ++this.phase;
            } else if (this.lastActivity == 0L) {
                this.onActivityWarning(true);
                this.warningPending = true;
                long checkTime = ((ServerManager)ServerManager.this).connInfo.probeTimeoutMillis;
                this.launch(checkTime, this.phase);
            } else {
                long checkTime = ServerManager.this.localPushServerProxy.getKeepaliveMillis() + ((ServerManager)ServerManager.this).connInfo.probeWarningMillis;
                long limit = this.lastActivity + checkTime;
                long left = limit - System.currentTimeMillis();
                this.lastActivity = 0L;
                if (left > 0L) {
                    this.launch(left, refPhase);
                } else {
                    this.onTimeout(refPhase);
                }
            }
        }

        private void launch(long millis, final int currPhase) {
            activityTimer.schedule(new TimerTask(){

                public void run() {
                    ActivityController.this.onTimeout(currPhase);
                }
            }, millis);
        }

        private void onStreamingResponse() {
            notificationsSender.execute(new Runnable(){

                public void run() {
                    actionsLogger.finer("Notifying return on the current connection");
                    ServerManager.this.serverListener.onStreamingReturned();
                }
            });
        }

        private void onNoActivity() {
            notificationsSender.execute(new Runnable(){

                public void run() {
                    PushServerException exc = new PushServerException(10);
                    boolean notLate = ServerManager.this.serverListener.onFailure(exc);
                    if (notLate) {
                        sessionLogger.fine("Terminating session " + ServerManager.this.localPushServerProxy.getSessionId() + " because of an activity timeout");
                        ServerManager.this.localPushServerProxy.dispose(true);
                    }
                }
            });
        }

        private void onConnectionTimeout(final boolean isFirstConn) {
            notificationsSender.execute(new Runnable(){

                public void run() {
                    if (isFirstConn) {
                        actionsLogger.finer("Notifying a timeout check on the current connection");
                        ServerManager.this.serverListener.onConnectTimeout();
                    } else {
                        boolean notLate = ServerManager.this.serverListener.onReconnectTimeout();
                        if (notLate) {
                            sessionLogger.fine("Terminating session " + ServerManager.this.localPushServerProxy.getSessionId() + " because of a reconnection timeout");
                            ServerManager.this.localPushServerProxy.dispose(true);
                        }
                    }
                }
            });
        }

        private void onActivityWarning(final boolean warningOn) {
            notificationsSender.execute(new Runnable(){

                public void run() {
                    boolean notLate = ServerManager.this.serverListener.onActivityWarning(warningOn);
                    if (notLate) {
                        if (warningOn) {
                            sessionLogger.fine("Session " + ServerManager.this.localPushServerProxy.getSessionId() + " stalled");
                        } else {
                            sessionLogger.fine("Session " + ServerManager.this.localPushServerProxy.getSessionId() + " no longer stalled");
                        }
                    }
                }
            });
        }
    }

    class SessionActivityManager {
        private boolean terminated = false;

        SessionActivityManager() {
        }

        void start() {
            ServerManager.this.activityController.onConnectionReturned();
            sessionLogger.fine("Listening for updates on session " + ServerManager.this.localPushServerProxy.getSessionId());
            new Thread("Lightstreamer listening thread"){

                public void run() {
                    SessionActivityManager.this.runSession();
                }
            }.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean runEvent() throws PushLengthException {
            if (this.terminated) {
                return false;
            }
            try {
                if (!ServerManager.this.waitEvent(ServerManager.this.activityController)) {
                    this.terminated = true;
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            catch (PushLengthException e) {
                throw e;
            }
            catch (Throwable e) {
                this.terminated = true;
                PushServerException exc = new PushServerException(12, e);
                protLogger.log(Level.FINER, "Error in received data", e);
                sessionLogger.severe("Unrecoverable error while listening to data in session " + ServerManager.this.localPushServerProxy.getSessionId());
                ServerManager.this.serverListener.onFailure(exc);
                boolean bl = false;
                return bl;
            }
            finally {
                if (this.terminated) {
                    ServerManager.this.serverListener.onClose();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean resumeSession(long holdingMillis) {
            if (this.terminated) {
                return false;
            }
            if (holdingMillis > 0L) {
                try {
                    Thread.sleep(holdingMillis);
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
            }
            try {
                if (!ServerManager.this.rebind(ServerManager.this.activityController)) {
                    this.terminated = true;
                    boolean e1 = false;
                    return e1;
                }
                ServerManager.this.activityController.onConnectionReturned();
                boolean e1 = true;
                return e1;
            }
            catch (Throwable e) {
                this.terminated = true;
                PushServerException exc = new PushServerException(12, e);
                protLogger.log(Level.FINER, "Error in received data", e);
                sessionLogger.severe("Unrecoverable error while trying to rebind to session " + ServerManager.this.localPushServerProxy.getSessionId());
                ServerManager.this.serverListener.onFailure(exc);
                boolean bl = false;
                return bl;
            }
            finally {
                if (this.terminated) {
                    ServerManager.this.serverListener.onClose();
                }
            }
        }

        private void runSession() {
            HttpProvider.AsyncStream asyncStream = ServerManager.this.localPushServerProxy.getAsyncStream();
            if (asyncStream != null) {
                HttpProvider.LineConsumer consumer = new HttpProvider.LineConsumer(){

                    public boolean consume() {
                        try {
                            return SessionActivityManager.this.runEvent();
                        }
                        catch (PushLengthException e) {
                            new Thread("Lightstreamer rebinding thread"){

                                public void run() {
                                    if (SessionActivityManager.this.resumeSession(e.getHoldingMillis())) {
                                        SessionActivityManager.this.runSession();
                                    }
                                }
                            }.start();
                            return false;
                        }
                    }
                };
                asyncStream.startAsync(consumer);
            } else {
                while (true) {
                    try {
                        while (this.runEvent()) {
                        }
                    }
                    catch (PushLengthException e) {
                        if (this.resumeSession(e.getHoldingMillis())) continue;
                    }
                    break;
                }
            }
        }
    }
}

