/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.ls_client;

import com.lightstreamer.ls_client.BatchManager;
import com.lightstreamer.ls_client.BatchMonitor;
import com.lightstreamer.ls_client.BatchingHttpProvider;
import com.lightstreamer.ls_client.ConnectionConstraints;
import com.lightstreamer.ls_client.ConnectionInfo;
import com.lightstreamer.ls_client.HttpProvider;
import com.lightstreamer.ls_client.MessageManager;
import com.lightstreamer.ls_client.MyLineReader;
import com.lightstreamer.ls_client.PushConnException;
import com.lightstreamer.ls_client.PushEndException;
import com.lightstreamer.ls_client.PushLengthException;
import com.lightstreamer.ls_client.PushServerException;
import com.lightstreamer.ls_client.PushServerProxy;
import com.lightstreamer.ls_client.PushUserException;
import com.lightstreamer.ls_client.ServerUpdateEvent;
import com.lightstreamer.ls_client.SubscrException;
import com.lightstreamer.ls_client.SubscriptionConstraints;
import com.lightstreamer.ls_client.TableManager;
import com.lightstreamer.ls_client.VirtualTableManager;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PushServerTranslator {
    private final ConnectionInfo info;
    private final BatchManager batchManager = new BatchManager();
    private final BatchManager mexBatchManager = new BatchManager();
    private static Logger streamLogger = Logger.getLogger("com.lightstreamer.ls_client.stream");
    private static Logger protLogger = Logger.getLogger("com.lightstreamer.ls_client.protocol");

    PushServerTranslator(ConnectionInfo info) throws PushConnException {
        int realLen;
        ConnectionInfo localInfo = (ConnectionInfo)info.clone();
        if (localInfo.pushServerUrl == null) {
            throw new PushConnException("Connection property 'pushServerUrl' not set");
        }
        while (localInfo.pushServerUrl.endsWith("/")) {
            realLen = localInfo.pushServerUrl.length() - 1;
            localInfo.pushServerUrl = localInfo.pushServerUrl.substring(0, realLen);
        }
        if (localInfo.pushServerControlUrl != null) {
            while (localInfo.pushServerControlUrl.endsWith("/")) {
                realLen = localInfo.pushServerControlUrl.length() - 1;
                localInfo.pushServerControlUrl = localInfo.pushServerControlUrl.substring(0, realLen);
            }
        }
        this.info = localInfo;
    }

    InputStream callSession() throws PushServerException, PushUserException, PushConnException {
        HashMap<String, String> params = new HashMap<String, String>();
        if (this.info.user != null) {
            params.put("LS_user", this.info.user);
        }
        if (this.info.password != null) {
            params.put("LS_password", this.info.password);
        }
        params.put("LS_adapter_set", this.info.getAdapterSet());
        PushServerTranslator.addConnectionProperties(params, this.info);
        PushServerTranslator.addConstraints(params, this.info.constraints);
        String connectionUrl = this.info.pushServerUrl + "/lightstreamer/create_session.txt";
        HttpProvider provider = new HttpProvider(connectionUrl);
        protLogger.fine("Opening stream connection");
        if (protLogger.isLoggable(Level.FINER)) {
            protLogger.finer("Connection params: " + params);
        }
        return provider.doPost(params, true);
    }

    InputStream callResync(PushServerProxy.PushServerProxyInfo pushInfo, ConnectionConstraints newConstraints) throws PushServerException, PushUserException, PushConnException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("LS_session", pushInfo.sessionId);
        if (newConstraints != null) {
            this.info.constraints = (ConnectionConstraints)newConstraints.clone();
        }
        PushServerTranslator.addConnectionProperties(params, this.info);
        PushServerTranslator.addConstraints(params, this.info.constraints);
        String rebindUrl = pushInfo.rebindAddress + "/lightstreamer/bind_session.txt";
        HttpProvider provider = new HttpProvider(rebindUrl);
        protLogger.fine("Opening stream connection to rebind current session");
        if (protLogger.isLoggable(Level.FINER)) {
            protLogger.finer("Rebinding params: " + params);
        }
        return provider.doPost(params, true);
    }

    private static void addConstraints(HashMap<String, String> params, ConnectionConstraints constraints) {
        if (constraints.maxBandwidth != null) {
            params.put("LS_requested_max_bandwidth", constraints.maxBandwidth.toString());
        }
    }

    private static void addConnectionProperties(HashMap<String, String> params, ConnectionInfo properties) {
        if (properties.contentLength > 0L) {
            params.put("LS_content_length", Long.toString(properties.contentLength));
        }
        if (properties.keepaliveMillis > 0L) {
            params.put("LS_keepalive_millis", Long.toString(properties.keepaliveMillis));
        }
        if (properties.isPolling) {
            params.put("LS_polling", "true");
            if (properties.pollingMillis > 0L) {
                params.put("LS_polling_millis", Long.toString(properties.pollingMillis));
            } else {
                params.put("LS_polling_millis", "0");
            }
            if (properties.pollingIdleMillis > 0L) {
                params.put("LS_idle_millis", Long.toString(properties.pollingIdleMillis));
            }
        }
        params.put("LS_report_info", "true");
    }

    PushServerProxy.PushServerProxyInfo readSessionId(MyLineReader pushStream) throws PushServerException, PushConnException {
        String sessionId = null;
        String controlHost = null;
        String controlAddress = null;
        String rebindAddress = null;
        String controlLink = null;
        long keepaliveMillis = 0L;
        protLogger.fine("Reading stream connection info");
        while (true) {
            String str = pushStream.readLine();
            streamLogger.finest("Read info line: " + str);
            if (str == null) {
                throw new PushServerException(4);
            }
            if (str.trim().equals("")) break;
            if (str.startsWith("SessionId:")) {
                sessionId = str.substring("SessionId:".length());
                continue;
            }
            if (str.startsWith("ControlAddress:")) {
                controlHost = str.substring("ControlAddress:".length());
                continue;
            }
            if (str.startsWith("KeepaliveMillis:")) {
                String keepaliveMillisStr = str.substring("KeepaliveMillis:".length());
                try {
                    keepaliveMillis = Long.parseLong(keepaliveMillisStr);
                }
                catch (NumberFormatException e) {
                    throw new PushServerException(7);
                }
            }
            if (str.startsWith("MaxBandwidth:")) continue;
            if (str.startsWith("RequestLimit:")) {
                int requestLimit;
                String requestLimitStr = str.substring("RequestLimit:".length());
                try {
                    requestLimit = Integer.parseInt(requestLimitStr);
                }
                catch (NumberFormatException e) {
                    throw new PushServerException(7);
                }
                streamLogger.finer("Using " + requestLimit + " as the request maximum length");
                this.batchManager.setLimit(requestLimit);
                this.mexBatchManager.setLimit(requestLimit);
                continue;
            }
            protLogger.fine("Discarded unknown property: " + str);
        }
        if (sessionId == null) {
            throw new PushServerException(7);
        }
        controlAddress = this.info.pushServerControlUrl != null ? this.info.pushServerControlUrl : this.info.pushServerUrl;
        rebindAddress = this.info.pushServerUrl;
        if (controlHost != null) {
            controlLink = controlHost;
            try {
                if (this.info.enableControlLinkHandling) {
                    URL ca = new URL(controlAddress);
                    URL real_ca = new URL(ca.getProtocol(), controlHost, ca.getPort(), ca.getFile());
                    controlAddress = real_ca.toExternalForm();
                    URL ra = new URL(rebindAddress);
                    URL real_ra = new URL(ra.getProtocol(), controlHost, ra.getPort(), ra.getFile());
                    rebindAddress = real_ra.toExternalForm();
                }
            }
            catch (IOException e) {
                throw new PushConnException(e);
            }
        }
        PushServerProxy.PushServerProxyInfo pspInfo = new PushServerProxy.PushServerProxyInfo(sessionId, controlAddress, rebindAddress, controlLink, keepaliveMillis);
        if (protLogger.isLoggable(Level.FINER)) {
            protLogger.finer("Using info: " + pspInfo);
        }
        return pspInfo;
    }

    void callSendMessageRequest(PushServerProxy.PushServerProxyInfo pushInfo, String message) throws PushServerException, PushUserException, PushConnException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("LS_session", pushInfo.sessionId);
        params.put("LS_message", message);
        String controlUrl = pushInfo.controlAddress + "/lightstreamer/send_message.txt";
        MyLineReader answer = this.mexBatchManager.getNotBatchedAnswer(controlUrl, params);
        try {
            this.checkAnswer(answer);
        }
        catch (PushEndException e) {
            throw new PushServerException(7);
        }
        finally {
            try {
                streamLogger.finer("Closing message connection");
                answer.close();
            }
            catch (Throwable t) {
                streamLogger.log(Level.FINER, "Error closing message connection", t);
            }
        }
    }

    void callGuaranteedSendMessageRequest(PushServerProxy.PushServerProxyInfo pushInfo, String messageProg, MessageManager message, BatchMonitor batch) throws PushServerException, PushUserException, PushConnException, SubscrException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("LS_session", pushInfo.sessionId);
        params.put("LS_message", message.getMessage());
        params.put("LS_sequence", message.getSequence());
        params.put("LS_msg_prog", messageProg);
        if (message.getDelayTimeout() > -1) {
            params.put("LS_max_wait", String.valueOf(message.getDelayTimeout()));
        }
        this.doControlRequest(pushInfo, params, "/lightstreamer/send_message.txt", batch, this.mexBatchManager);
    }

    void callDestroyRequest(PushServerProxy.PushServerProxyInfo pushInfo) throws PushServerException, PushUserException, PushConnException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("LS_session", pushInfo.sessionId);
        params.put("LS_op", "destroy");
        String controlUrl = pushInfo.controlAddress + "/lightstreamer/control.txt";
        MyLineReader answer = this.batchManager.getNotBatchedAnswer(controlUrl, params);
        try {
            this.checkAnswer(answer);
        }
        catch (PushEndException e) {
            throw new PushServerException(7);
        }
        finally {
            try {
                streamLogger.finer("Closing destroy connection");
                answer.close();
            }
            catch (Throwable t) {
                streamLogger.log(Level.FINER, "Error closing destroy connection", t);
            }
        }
    }

    void callConstrainRequest(PushServerProxy.PushServerProxyInfo pushInfo, ConnectionConstraints newConstraints) throws PushServerException, PushUserException, PushConnException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("LS_session", pushInfo.sessionId);
        params.put("LS_op", "constrain");
        this.info.constraints = (ConnectionConstraints)newConstraints.clone();
        PushServerTranslator.addConstraints(params, this.info.constraints);
        String controlUrl = pushInfo.controlAddress + "/lightstreamer/control.txt";
        MyLineReader answer = this.batchManager.getNotBatchedAnswer(controlUrl, params);
        try {
            this.checkAnswer(answer);
        }
        catch (PushEndException e) {
            throw new PushServerException(7);
        }
        finally {
            try {
                streamLogger.finer("Closing constrain connection");
                answer.close();
            }
            catch (Throwable t) {
                streamLogger.log(Level.FINER, "Error closing constrain connection", t);
            }
        }
    }

    void callTableRequest(PushServerProxy.PushServerProxyInfo pushInfo, String tableCode, TableManager table, BatchMonitor batch) throws PushServerException, PushUserException, PushConnException, SubscrException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("LS_session", pushInfo.sessionId);
        params.put("LS_op", "add");
        params.put("LS_table", tableCode);
        params.put("LS_id", table.getGroup());
        params.put("LS_mode", table.getMode());
        params.put("LS_schema", table.getSchema());
        if (table.getDataAdapter() != null) {
            params.put("LS_data_adapter", table.getDataAdapter());
        }
        if (table.getSelector() != null) {
            params.put("LS_selector", table.getSelector());
        }
        if (table.isSnapshot()) {
            if (table.getDistinctSnapshotLength() != null) {
                params.put("LS_Snapshot", table.getDistinctSnapshotLength().toString());
            } else {
                params.put("LS_Snapshot", "true");
            }
        }
        if (table.getStart() != null) {
            params.put("LS_start", table.getStart().toString());
        }
        if (table.getEnd() != null) {
            params.put("LS_end", table.getEnd().toString());
        }
        if (table.isUnfiltered()) {
            params.put("LS_requested_max_frequency", "unfiltered");
        } else if (table.getMaxFrequency() != null) {
            params.put("LS_requested_max_frequency", table.getMaxFrequency().toString());
        }
        if (table.getMaxBufferSize() != null) {
            params.put("LS_requested_buffer_size", table.getMaxBufferSize().toString());
        }
        this.doControlRequest(pushInfo, params, batch);
    }

    void callItemsRequest(PushServerProxy.PushServerProxyInfo pushInfo, String[] tableCodes, VirtualTableManager table, BatchMonitor batch) throws PushServerException, PushUserException, PushConnException, SubscrException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("LS_session", pushInfo.sessionId);
        params.put("LS_op", "add");
        params.put("LS_mode", table.getMode());
        params.put("LS_schema", table.getSchema());
        if (table.getDataAdapter() != null) {
            params.put("LS_data_adapter", table.getDataAdapter());
        }
        for (int i = 0; i < table.getNumItems(); ++i) {
            params.put("LS_table" + (i + 1), tableCodes[i]);
            params.put("LS_id" + (i + 1), table.getItemName(i));
            if (table.getSelector() != null) {
                params.put("LS_selector" + (i + 1), table.getSelector());
            }
            if (table.isSnapshot()) {
                if (table.getDistinctSnapshotLength() != null) {
                    params.put("LS_Snapshot" + (i + 1), table.getDistinctSnapshotLength().toString());
                } else {
                    params.put("LS_Snapshot" + (i + 1), "true");
                }
            }
            if (table.isUnfiltered()) {
                params.put("LS_requested_max_frequency" + (i + 1), "unfiltered");
            } else if (table.getMaxFrequency() != null) {
                params.put("LS_requested_max_frequency" + (i + 1), table.getMaxFrequency().toString());
            }
            if (table.getMaxBufferSize() == null) continue;
            params.put("LS_requested_buffer_size" + (i + 1), table.getMaxBufferSize().toString());
        }
        this.doControlRequest(pushInfo, params, batch);
    }

    void callReconf(PushServerProxy.PushServerProxyInfo pushInfo, String[] tableCodes, SubscriptionConstraints constraints) throws PushServerException, PushUserException, PushConnException, SubscrException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("LS_session", pushInfo.sessionId);
        params.put("LS_op", "reconf");
        for (int i = 0; i < tableCodes.length; ++i) {
            params.put("LS_table" + (i + 1), tableCodes[i]);
        }
        if (constraints.maxFrequency == null) {
            return;
        }
        params.put("LS_requested_max_frequency", constraints.maxFrequency.toString());
        this.doControlRequest(pushInfo, params, null);
    }

    void callDelete(PushServerProxy.PushServerProxyInfo pushInfo, String[] tableCodes, BatchMonitor batch) throws PushServerException, PushUserException, PushConnException, SubscrException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("LS_session", pushInfo.sessionId);
        params.put("LS_op", "delete");
        for (int i = 0; i < tableCodes.length; ++i) {
            params.put("LS_table" + (i + 1), tableCodes[i]);
        }
        this.doControlRequest(pushInfo, params, batch);
    }

    private void doControlRequest(PushServerProxy.PushServerProxyInfo pushInfo, HashMap<String, String> params, BatchMonitor batch) throws PushServerException, PushUserException, PushConnException, SubscrException {
        this.doControlRequest(pushInfo, params, "/lightstreamer/control.txt", batch, this.batchManager);
    }

    private void doControlRequest(PushServerProxy.PushServerProxyInfo pushInfo, HashMap<String, String> params, String commandPath, BatchMonitor batch, BatchManager selectedBatchManager) throws PushServerException, PushUserException, PushConnException, SubscrException {
        String controlUrl = pushInfo.controlAddress + commandPath;
        MyLineReader answer = batch != null ? selectedBatchManager.getAnswer(controlUrl, params, batch) : selectedBatchManager.getNotBatchedAnswer(controlUrl, params);
        try {
            this.checkAnswer(answer);
        }
        catch (PushEndException e) {
            throw new PushServerException(7);
        }
        finally {
            try {
                if (!(answer instanceof BatchingHttpProvider.BatchedLineReader)) {
                    streamLogger.finer("Closing control connection");
                }
                answer.close();
            }
            catch (Throwable t) {
                streamLogger.log(Level.FINER, "Error closing control connection", t);
            }
        }
    }

    void startControlBatch(PushServerProxy.PushServerProxyInfo pushInfo) {
        String controlUrl = pushInfo.controlAddress + "/lightstreamer/control.txt";
        this.batchManager.startBatch(controlUrl);
    }

    void startMessageBatch(PushServerProxy.PushServerProxyInfo pushInfo) {
        String controlUrl = pushInfo.controlAddress + "/lightstreamer/send_message.txt";
        this.mexBatchManager.startBatch(controlUrl);
    }

    void closeControlBatch() {
        this.batchManager.closeBatch();
    }

    void closeMessageBatch() {
        this.mexBatchManager.closeBatch();
    }

    void abortBatches() {
        this.batchManager.abortBatch();
        this.mexBatchManager.abortBatch();
    }

    void checkAnswer(MyLineReader answer) throws PushConnException, PushServerException, PushUserException, PushEndException {
        String notif = answer.readLine();
        streamLogger.finest("Read answer: " + notif);
        if (notif == null) {
            throw new PushServerException(6);
        }
        if (notif.equals("OK")) {
            protLogger.fine("Request successful");
            return;
        }
        if (notif.equals("ERROR")) {
            int errCode;
            String code = answer.readLine();
            streamLogger.finest("Read error code: " + code);
            if (code == null) {
                throw new PushServerException(4);
            }
            String msg = answer.readLine();
            streamLogger.finest("Read error message: " + msg);
            if (msg == null) {
                msg = "Request refused";
            }
            try {
                errCode = Integer.parseInt(code);
            }
            catch (NumberFormatException e) {
                protLogger.log(Level.FINER, "Error in received answer", e);
                throw new PushServerException(5, code);
            }
            throw new PushUserException(errCode, msg);
        }
        if (notif.equals("END")) {
            String endCodeStr = answer.readLine();
            if (endCodeStr == null || endCodeStr.length() == 0) {
                streamLogger.finest("Read end with no code");
                throw new PushEndException();
            }
            try {
                int endCode = Integer.parseInt(endCodeStr);
                streamLogger.finest("Read end with code: " + endCode);
                throw new PushEndException(endCode);
            }
            catch (NumberFormatException e) {
                protLogger.log(Level.FINER, "Error in received answer", e);
                throw new PushServerException(5, endCodeStr);
            }
        }
        if (notif.equals("SYNC ERROR")) {
            throw new PushServerException(8);
        }
        throw new PushServerException(5, notif);
    }

    String waitCommand(MyLineReader pushStream) throws PushConnException, PushLengthException, PushServerException, PushEndException {
        String pushData = pushStream.readLine();
        if (streamLogger.isLoggable(Level.FINEST)) {
            streamLogger.finest("Read data: " + pushData);
        }
        if (pushData == null) {
            throw new PushConnException("Connection end");
        }
        if (pushData.length() == 0) {
            protLogger.warning("Unexpected empty line; ignored");
            return null;
        }
        if (pushData.equals("PROBE")) {
            protLogger.finest("Got probe event");
            return null;
        }
        if (pushData.startsWith("LOOP")) {
            long holdingMillis;
            String holdingMillisStr = pushData.substring("LOOP".length());
            if (holdingMillisStr.length() == 0) {
                holdingMillis = 0L;
            } else {
                if (holdingMillisStr.charAt(0) != ' ') {
                    throw new PushServerException(5, pushData);
                }
                try {
                    holdingMillis = Long.parseLong(holdingMillisStr.substring(1));
                }
                catch (NumberFormatException e) {
                    throw new PushServerException(5, pushData);
                }
            }
            if (holdingMillis == 0L) {
                protLogger.fine("Got notification for response content length reached");
            } else {
                protLogger.finer("Poll completed; next in " + holdingMillis + " ms");
            }
            throw new PushLengthException(holdingMillis);
        }
        if (pushData.startsWith("END")) {
            String endCodeStr = pushData.substring("END".length());
            if (endCodeStr.length() == 0) {
                protLogger.fine("Got notification for server originated connection closure with no code");
                throw new PushEndException();
            }
            if (endCodeStr.charAt(0) != ' ') {
                throw new PushServerException(5, pushData);
            }
            try {
                int endCode = Integer.parseInt(endCodeStr.substring(1));
                protLogger.fine("Got notification for server originated connection closure with code " + endCode);
                throw new PushEndException(endCode);
            }
            catch (NumberFormatException e) {
                throw new PushServerException(5, pushData);
            }
        }
        return pushData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    ServerUpdateEvent parsePushData(String pushData) throws PushServerException {
        event = null;
        if (pushData.startsWith("MSG")) {
            splitted = pushData.split(",", 6);
            ok = false;
            try {
                if (splitted != null && splitted.length == 4 && splitted[3].equals("DONE")) {
                    event = new ServerUpdateEvent(splitted[1], Integer.parseInt(splitted[2]));
                    ok = true;
                }
                if (splitted == null || splitted.length != 6 || !splitted[3].equals("ERR")) ** GOTO lbl68
                event = new ServerUpdateEvent(splitted[1], Integer.parseInt(splitted[2]), Integer.parseInt(splitted[4]), splitted[5]);
                ok = true;
            }
            catch (NumberFormatException nfe) {
                if (ok) ** GOTO lbl68
                throw new PushServerException(5, pushData);
            }
            finally {
                if (!ok) {
                    throw new PushServerException(5, pushData);
                }
            }
        } else {
            start = pushData.indexOf(124);
            infoCode = null;
            if (start == -1) {
                infoSep = pushData.lastIndexOf(44);
                if (infoSep == -1) {
                    throw new PushServerException(5, pushData);
                }
                itemCode = pushData.substring(0, infoSep);
                infoCode = pushData.substring(infoSep + 1);
            } else {
                itemCode = pushData.substring(0, start);
            }
            sep = itemCode.indexOf(44);
            if (sep == -1) {
                throw new PushServerException(5, pushData);
            }
            tableCode = itemCode.substring(0, sep);
            itemCode = itemCode.substring(sep + 1);
            if (infoCode != null) {
                if (infoCode.equals("EOS")) {
                    return new ServerUpdateEvent(tableCode, itemCode, true);
                }
                if (infoCode.startsWith("OV")) {
                    try {
                        over = infoCode.substring("OV".length());
                        overflow = Integer.parseInt(over);
                        return new ServerUpdateEvent(tableCode, itemCode, overflow);
                    }
                    catch (Exception e) {
                        throw new PushServerException(5, pushData);
                    }
                }
                throw new PushServerException(5, pushData);
            }
            event = new ServerUpdateEvent(tableCode, itemCode);
            while (start < pushData.length()) {
                pos = pushData.indexOf(124, start + 1);
                if (pos == -1) {
                    pos = pushData.length();
                }
                if (pos == start + 1) {
                    event.addValue(ServerUpdateEvent.UNCHANGED);
                } else {
                    value = pushData.substring(start + 1, pos);
                    if (value.length() == 1 && value.charAt(0) == '$') {
                        event.addValue("");
                    } else if (value.length() == 1 && value.charAt(0) == '#') {
                        event.addValue(null);
                    } else if (value.charAt(0) == '$' || value.charAt(0) == '#') {
                        event.addValue(PushServerTranslator.deUNIcode(value.substring(1)));
                    } else {
                        event.addValue(PushServerTranslator.deUNIcode(value));
                    }
                }
                start = pos;
            }
        }
lbl68:
        // 5 sources

        if (PushServerTranslator.protLogger.isLoggable(Level.FINEST)) {
            PushServerTranslator.protLogger.finest("Read " + event);
        }
        return event;
    }

    private static String deUNIcode(String src) throws PushServerException {
        int i;
        int len = src.length();
        char[] chars = src.toCharArray();
        StringBuffer trg = new StringBuffer(len);
        int base = 0;
        while (true) {
            for (i = base; i < len && chars[i] != '\\'; ++i) {
            }
            if (i >= len) break;
            if (i + 6 <= len && chars[i + 1] == 'u') {
                String hex = new String(chars, i + 2, 4);
                try {
                    int val = Integer.parseInt(hex, 16);
                    chars[i] = (char)val;
                }
                catch (Exception e) {
                    protLogger.log(Level.FINER, "Encoding error in received answer");
                    throw new PushServerException(5, src);
                }
            } else {
                protLogger.log(Level.FINER, "Encoding error in received answer");
                throw new PushServerException(5, src);
            }
            trg.append(chars, base, i + 1 - base);
            base = i + 6;
        }
        trg.append(chars, base, i - base);
        return trg.toString();
    }
}

