/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.ls_client;

import com.lightstreamer.ls_client.BatchMonitor;
import com.lightstreamer.ls_client.ConnectionConstraints;
import com.lightstreamer.ls_client.ConnectionInfo;
import com.lightstreamer.ls_client.HttpProvider;
import com.lightstreamer.ls_client.MessageManager;
import com.lightstreamer.ls_client.MyLineReader;
import com.lightstreamer.ls_client.PhaseException;
import com.lightstreamer.ls_client.PushConnException;
import com.lightstreamer.ls_client.PushEndException;
import com.lightstreamer.ls_client.PushLengthException;
import com.lightstreamer.ls_client.PushServerException;
import com.lightstreamer.ls_client.PushServerTranslator;
import com.lightstreamer.ls_client.PushUserException;
import com.lightstreamer.ls_client.ServerManager;
import com.lightstreamer.ls_client.ServerUpdateEvent;
import com.lightstreamer.ls_client.SubscrException;
import com.lightstreamer.ls_client.SubscribedTableKey;
import com.lightstreamer.ls_client.SubscriptionConstraints;
import com.lightstreamer.ls_client.TableManager;
import com.lightstreamer.ls_client.VirtualTableManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

class PushServerProxy {
    private final PushServerTranslator serverTranslator;
    private PushServerProxyInfo serverInfo = null;
    private InputStream pushLowLevelStream = null;
    private MyLineReader pushStream = null;
    private boolean streamCompleted = false;
    private boolean closed = true;
    private long totalBytes = 0L;
    private static int currCode = 0;
    private static Object codes = new Object();
    private static Logger streamLogger = Logger.getLogger("com.lightstreamer.ls_client.stream");
    private static Logger sessionLogger = Logger.getLogger("com.lightstreamer.ls_client.session");
    private static Logger protLogger = Logger.getLogger("com.lightstreamer.ls_client.protocol");

    PushServerProxy(ConnectionInfo info) throws PushConnException {
        this.serverTranslator = new PushServerTranslator(info);
    }

    synchronized long getTotalBytes() {
        return this.totalBytes;
    }

    String getSessionId() {
        return this.serverInfo.sessionId;
    }

    public String getControlLink() {
        return this.serverInfo.controlLink;
    }

    long getKeepaliveMillis() {
        return this.serverInfo.keepaliveMillis;
    }

    HttpProvider.AsyncStream getAsyncStream() {
        if (this.pushLowLevelStream instanceof HttpProvider.AsyncStream) {
            return (HttpProvider.AsyncStream)((Object)this.pushLowLevelStream);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InputStream connectForSession() throws PushConnException, PhaseException, PushServerException, PushUserException {
        InputStream stream;
        sessionLogger.fine("Connecting for a new session");
        try {
            stream = this.serverTranslator.callSession();
        }
        catch (PushConnException e) {
            sessionLogger.fine("Unsuccessful connection for new session");
            sessionLogger.log(Level.FINER, "Unsuccessful connection for new session", e);
            throw e;
        }
        boolean late = false;
        PushServerProxy pushServerProxy = this;
        synchronized (pushServerProxy) {
            if (!this.closed) {
                late = true;
            }
        }
        if (late) {
            sessionLogger.fine("Connection started but no longer requested");
            try {
                streamLogger.finer("Closing stream connection");
                stream.close();
            }
            catch (Throwable t) {
                streamLogger.log(Level.FINER, "Error closing the stream connection", t);
            }
            throw new PhaseException();
        }
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startSession(InputStream stream) throws PushConnException, PhaseException, PushServerException, PushUserException {
        MyLineReader answer = null;
        PushServerProxyInfo info = null;
        sessionLogger.fine("Starting new session");
        try {
            answer = stream instanceof HttpProvider.AsyncStream ? ((HttpProvider.AsyncStream)((Object)stream)).getLineReader() : new MyLineReader(stream, 8192);
            this.serverTranslator.checkAnswer(answer);
            info = this.serverTranslator.readSessionId(answer);
        }
        catch (PushEndException e) {
            throw new PushServerException(7);
        }
        catch (PushConnException e) {
            sessionLogger.fine("Unsuccessful start of new session");
            sessionLogger.log(Level.FINER, "Unsuccessful start of new session", e);
            throw e;
        }
        boolean late = false;
        PushServerProxy pushServerProxy = this;
        synchronized (pushServerProxy) {
            if (!this.closed) {
                late = true;
            } else {
                this.pushLowLevelStream = stream;
                this.pushStream = answer;
                this.streamCompleted = false;
                this.serverInfo = info;
                this.closed = false;
            }
        }
        if (late) {
            sessionLogger.fine("Session started but no longer requested");
            this.disposeStreams(stream, answer, info);
            throw new PhaseException();
        }
        sessionLogger.fine("Started session " + this.serverInfo.sessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SubscribedTableKey getTableCode() {
        Object object = codes;
        synchronized (object) {
            Integer newCode = new Integer(++currCode);
            return new SubscribedTableKey(newCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isTableCodeConsumed(Integer tableCode) {
        Object object = codes;
        synchronized (object) {
            int code = tableCode;
            return code > 0 && code <= currCode;
        }
    }

    void sendMessage(String message) throws PhaseException, PushConnException, PushServerException, PushUserException {
        this.check();
        this.serverTranslator.callSendMessageRequest(this.serverInfo, message);
        this.check();
    }

    void requestSendMessage(MessageManager message, int prog, BatchMonitor batch) throws PhaseException, PushConnException, PushServerException, PushUserException, SubscrException {
        this.check();
        this.serverTranslator.callGuaranteedSendMessageRequest(this.serverInfo, String.valueOf(prog), message, batch);
        this.check();
    }

    void requestNewConstraints(ConnectionConstraints constraints) throws PhaseException, PushConnException, PushServerException {
        this.check();
        try {
            this.serverTranslator.callConstrainRequest(this.serverInfo, constraints);
        }
        catch (PushUserException e) {
            protLogger.log(Level.FINER, "Refused constraints request", e);
            throw new PushServerException(9);
        }
        this.check();
    }

    void requestSubscr(TableManager table, SubscribedTableKey subscrKey, BatchMonitor batch) throws PhaseException, PushConnException, PushServerException, PushUserException, SubscrException {
        String tableCode = subscrKey.getKeyValue().toString();
        this.check();
        this.serverTranslator.callTableRequest(this.serverInfo, tableCode, table, batch);
        this.check();
    }

    void requestItemsSubscr(VirtualTableManager table, SubscribedTableKey[] subscrKeys, BatchMonitor batch) throws PhaseException, PushConnException, PushServerException, PushUserException, SubscrException {
        String[] tableCodes = new String[subscrKeys.length];
        for (int i = 0; i < subscrKeys.length; ++i) {
            tableCodes[i] = subscrKeys[i].getKeyValue().toString();
        }
        this.check();
        this.serverTranslator.callItemsRequest(this.serverInfo, tableCodes, table, batch);
        this.check();
    }

    void constrainSubscrs(SubscribedTableKey[] subscrKeys, SubscriptionConstraints constraints) throws PhaseException, PushConnException, PushServerException, SubscrException {
        String[] tableCodes = new String[subscrKeys.length];
        for (int i = 0; i < subscrKeys.length; ++i) {
            tableCodes[i] = subscrKeys[i].getKeyValue().toString();
        }
        this.check();
        try {
            this.serverTranslator.callReconf(this.serverInfo, tableCodes, constraints);
        }
        catch (PushUserException e) {
            if (e.getErrorCode() == 13) {
                throw new PushServerException(14);
            }
            protLogger.log(Level.FINER, "Refused reconf request", e);
            throw new PushServerException(9);
        }
        this.check();
    }

    void delSubscrs(SubscribedTableKey[] subscrKeys, BatchMonitor batch) throws PhaseException, PushConnException, PushServerException, SubscrException {
        String[] tableCodes = new String[subscrKeys.length];
        for (int i = 0; i < subscrKeys.length; ++i) {
            tableCodes[i] = subscrKeys[i].getKeyValue().toString();
        }
        this.check();
        try {
            this.serverTranslator.callDelete(this.serverInfo, tableCodes, batch);
        }
        catch (PushUserException e) {
            protLogger.log(Level.FINER, "Refused delete request", e);
            throw new PushServerException(9);
        }
        this.check();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resyncSession() throws PhaseException, PushConnException, PushServerException, PushEndException {
        InputStream stream = null;
        MyLineReader answer = null;
        PushServerProxyInfo info = null;
        this.check();
        sessionLogger.fine("Rebinding session " + this.serverInfo.sessionId);
        try {
            stream = this.serverTranslator.callResync(this.serverInfo, null);
            answer = stream instanceof HttpProvider.AsyncStream ? ((HttpProvider.AsyncStream)((Object)stream)).getLineReader() : new MyLineReader(stream, 8192);
            this.serverTranslator.checkAnswer(answer);
            info = this.serverTranslator.readSessionId(answer);
        }
        catch (PushUserException e1) {
            sessionLogger.fine("Refused resync request" + this.serverInfo.sessionId);
            protLogger.log(Level.FINER, "Refused resync request", e1);
            throw new PushServerException(9);
        }
        catch (PushConnException e) {
            sessionLogger.fine("Unsuccessful rebinding of session " + this.serverInfo.sessionId);
            sessionLogger.log(Level.FINER, "Unsuccessful rebinding of session " + this.serverInfo.sessionId, e);
            throw e;
        }
        boolean late = false;
        PushServerProxy pushServerProxy = this;
        synchronized (pushServerProxy) {
            if (!this.closed) {
                this.dispose(false);
                this.pushLowLevelStream = stream;
                this.pushStream = answer;
                this.streamCompleted = false;
                this.serverInfo = info;
            } else {
                late = true;
            }
        }
        if (late) {
            sessionLogger.fine("Rebind successful but no longer requested");
            this.disposeStreams(stream, answer, null);
            throw new PhaseException();
        }
        sessionLogger.fine("Rebind successful on session " + this.serverInfo.sessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String waitCommand(ServerManager.ActivityController activityController) throws PhaseException, PushConnException, PushServerException, PushLengthException, PushEndException {
        MyLineReader currStream;
        PushServerProxy pushServerProxy = this;
        synchronized (pushServerProxy) {
            this.check();
            currStream = this.pushStream;
        }
        try {
            String pushData = this.serverTranslator.waitCommand(currStream);
            activityController.onActivity();
            return pushData;
        }
        catch (PushEndException e) {
            PushServerProxy pushServerProxy2 = this;
            synchronized (pushServerProxy2) {
                this.check();
                this.streamCompleted = true;
            }
            throw e;
        }
        catch (PushLengthException e) {
            this.check();
            activityController.stopKeepalives();
            throw e;
        }
        catch (PushConnException e) {
            PushServerProxy pushServerProxy3 = this;
            synchronized (pushServerProxy3) {
                this.check();
                this.streamCompleted = true;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServerUpdateEvent waitUpdate(ServerManager.ActivityController activityController) throws PushConnException, PushServerException, PhaseException, PushLengthException, PushEndException {
        ServerUpdateEvent event;
        this.check();
        String pushData = this.waitCommand(activityController);
        if (pushData == null) {
            return null;
        }
        try {
            event = this.serverTranslator.parsePushData(pushData);
        }
        catch (PushServerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PushServerException(12, (Throwable)e);
        }
        PushServerProxy pushServerProxy = this;
        synchronized (pushServerProxy) {
            this.totalBytes += (long)(pushData.length() + 2);
        }
        this.check();
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose(boolean alsoCloseSession) {
        InputStream oldLowLevelStream = null;
        MyLineReader oldStream = null;
        boolean oldStreamCompleted = false;
        PushServerProxyInfo currServerInfo = null;
        boolean late = false;
        PushServerProxy pushServerProxy = this;
        synchronized (pushServerProxy) {
            if (!this.closed) {
                oldLowLevelStream = this.pushLowLevelStream;
                oldStream = this.pushStream;
                oldStreamCompleted = this.streamCompleted;
                currServerInfo = this.serverInfo;
                this.pushLowLevelStream = null;
                this.pushStream = null;
                this.streamCompleted = false;
                if (alsoCloseSession) {
                    this.closed = true;
                    this.serverTranslator.abortBatches();
                }
            } else {
                late = true;
            }
        }
        if (!late) {
            boolean force;
            boolean bl = force = alsoCloseSession && !oldStreamCompleted;
            if (force) {
                this.disposeStreams(oldLowLevelStream, oldStream, currServerInfo);
            } else {
                this.disposeStreams(oldLowLevelStream, oldStream, null);
            }
        } else {
            sessionLogger.fine("Session " + this.getSessionId() + " already terminated");
        }
    }

    private void disposeStreams(final InputStream closingLowLevelStream, final MyLineReader closingStream, PushServerProxyInfo closingInfo) {
        new Thread("Connection close activity"){

            public void run() {
                try {
                    closingLowLevelStream.close();
                }
                catch (IOException e) {
                    streamLogger.log(Level.FINER, "Error closing the connection", e);
                }
                catch (NumberFormatException nfe) {
                    if (!PushServerProxy.this.isDalvik()) {
                        throw nfe;
                    }
                    streamLogger.log(Level.FINER, "Error closing the connection (NFE, Dalvik bug?)", nfe);
                }
                catch (NullPointerException npe) {
                    if (!PushServerProxy.this.isDalvik()) {
                        throw npe;
                    }
                    streamLogger.log(Level.FINER, "Error closing the connection (NPE, Dalvik bug?)", npe);
                }
                catch (Throwable t) {
                    streamLogger.log(Level.FINER, "Unexpected error closing the connection", t);
                }
                try {
                    streamLogger.finer("Closing stream connection");
                    closingStream.close();
                }
                catch (IOException e) {
                    streamLogger.log(Level.FINER, "Error closing the stream connection", e);
                }
                catch (NumberFormatException nfe) {
                    if (!PushServerProxy.this.isDalvik()) {
                        throw nfe;
                    }
                    streamLogger.log(Level.FINER, "Error closing the connection (NFE, Dalvik bug?)", nfe);
                }
                catch (NullPointerException npe) {
                    if (!PushServerProxy.this.isDalvik()) {
                        throw npe;
                    }
                    streamLogger.log(Level.FINER, "Error closing the connection (NPE, Dalvik bug?)", npe);
                }
                catch (Throwable t) {
                    streamLogger.log(Level.FINER, "Unexpected error closing the stream connection", t);
                }
            }
        }.start();
        if (closingInfo != null) {
            new ServerSessionDestroy(closingInfo).start();
        }
    }

    boolean isDalvik() {
        String osname = null;
        try {
            osname = System.getProperty("java.vm.name");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (osname != null) {
            return osname.equals("Dalvik");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startBatch() throws PhaseException {
        PushServerProxy pushServerProxy = this;
        synchronized (pushServerProxy) {
            this.check();
            this.serverTranslator.startControlBatch(this.serverInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startMessageBatch() throws PhaseException {
        PushServerProxy pushServerProxy = this;
        synchronized (pushServerProxy) {
            this.check();
            this.serverTranslator.startMessageBatch(this.serverInfo);
        }
    }

    void closeBatch() {
        this.serverTranslator.closeControlBatch();
    }

    void closeMessageBatch() {
        this.serverTranslator.closeMessageBatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void check() throws PhaseException {
        PushServerProxy pushServerProxy = this;
        synchronized (pushServerProxy) {
            if (this.closed) {
                throw new PhaseException();
            }
        }
    }

    static class PushServerProxyInfo {
        public final String sessionId;
        public final String controlLink;
        public final String controlAddress;
        public final String rebindAddress;
        public final long keepaliveMillis;

        public PushServerProxyInfo(String sessionId, String controlAddress, String rebindAddress, String controlLink, long keepaliveMillis) {
            this.sessionId = sessionId;
            this.controlAddress = controlAddress;
            this.rebindAddress = rebindAddress;
            this.keepaliveMillis = keepaliveMillis;
            this.controlLink = controlLink;
        }

        public String toString() {
            return "[ Session ID: " + this.sessionId + " - Control Address to be used: " + this.controlAddress + " - Rebind Address to be used: " + this.rebindAddress + " - Keepalive millis: " + this.keepaliveMillis + "]";
        }
    }

    private class ServerSessionDestroy
    extends Thread {
        private PushServerProxyInfo closingServerInfo;

        ServerSessionDestroy(PushServerProxyInfo closingServerInfo) {
            this.closingServerInfo = closingServerInfo;
        }

        public void run() {
            try {
                PushServerProxy.this.serverTranslator.callDestroyRequest(this.closingServerInfo);
            }
            catch (PushServerException pse) {
            }
            catch (PushUserException pue) {
            }
            catch (PushConnException pushConnException) {
                // empty catch block
            }
        }
    }
}

