/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.ls_client;

public class PushServerException
extends Exception {
    public static final int TABLE_ERROR = 1;
    public static final int ITEMS_ERROR = 2;
    public static final int FIELDS_ERROR = 3;
    public static final int UNEXPECTED_END = 4;
    public static final int SYNTAX_ERROR = 5;
    public static final int NO_ANSWER = 6;
    public static final int PROTOCOL_ERROR = 7;
    public static final int SYNC_ERROR = 8;
    public static final int SERVER_REFUSAL = 9;
    public static final int SERVER_TIMEOUT = 10;
    public static final int RECONNECTION_TIMEOUT = 11;
    public static final int UNEXPECTED_ERROR = 12;
    public static final int MESSAGE_ERROR = 13;
    public static final int MAXFREQ_ERROR = 14;
    private static final String[] defaultMsgs = new String[]{"Unspecified error", "Wrong table number", "Wrong item number", "Wrong number of fields", "Answer was interrupted", "Incorrect answer", "No answer", "Unexpected answer", "Session not found", "Server refusal", "No data from server", "No more answer from server", "Unexpected error", "Wrong message sequence or progressive number", "Maximum frequency cannot be set"};
    private int errorCode;

    public PushServerException(int errorCode, String extraMsg) {
        super(PushServerException.getMsg(errorCode, extraMsg));
        this.errorCode = errorCode;
    }

    public PushServerException(int errorCode) {
        super(PushServerException.getMsg(errorCode, null));
        this.errorCode = errorCode;
    }

    public PushServerException(int errorCode, Throwable cause) {
        super(PushServerException.getMsg(errorCode, cause.getMessage()), cause);
        this.errorCode = errorCode;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    private static String getMsg(int errorCode, String extraMsg) {
        String msg = defaultMsgs[0];
        if (errorCode > 0 && errorCode < defaultMsgs.length) {
            msg = defaultMsgs[errorCode];
        }
        if (extraMsg != null) {
            msg = msg + ": " + extraMsg;
        }
        return msg;
    }
}

