/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.ls_client;

import com.lightstreamer.ls_client.ConnectionListener;
import com.lightstreamer.ls_client.ExtConnectionListener;
import com.lightstreamer.ls_client.ExtendedConnectionListener;
import com.lightstreamer.ls_client.HttpProvider;
import com.lightstreamer.ls_client.LSClient;
import com.lightstreamer.ls_client.MessageManager;
import com.lightstreamer.ls_client.PushConnException;
import com.lightstreamer.ls_client.PushServerException;
import com.lightstreamer.ls_client.SequenceHandler;
import com.lightstreamer.ls_client.ServerManager;
import com.lightstreamer.ls_client.ServerUpdateEvent;
import com.lightstreamer.ls_client.TableManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;

class MyServerListener
implements ServerManager.ServerListener {
    private static String NO_EXT_ONSESSION = "Couldn't find the expected \"onSessionStartedExt\" method; using \"onSessionStarted\"";
    private static String NO_NEW_ONSESSION = "Couldn't find the new public \"onSessionStarted\" implementation, falling back to the old version";
    private static String NO_ANY_ONSESSION = "Couldn't find any onSessionStarted implementation";
    private final LSClient owner;
    private final int initialPhase;
    private final ConnectionListener initialListener;
    private boolean failed = false;
    private static Logger actionsLogger = Logger.getLogger("com.lightstreamer.ls_client.actions");
    private static final Object sharedSendersLock = new Object();
    private static ExecutorService mySharedCallbackSender;
    private static ExecutorService mySharedMessageCallbackSender;
    private final ExecutorService myCallbackSender;
    private final ExecutorService myMessageCallbackSender;
    private final boolean extendedSessionInfo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MyServerListener(LSClient owner, ConnectionListener initialListener, int initialPhase) {
        this.owner = owner;
        this.initialListener = initialListener;
        this.initialPhase = initialPhase;
        if (HttpProvider.asyncEnablable) {
            HttpProvider.checkAsyncProp();
        }
        if (HttpProvider.asyncEnabled) {
            Object object = sharedSendersLock;
            synchronized (object) {
                if (mySharedCallbackSender == null) {
                    mySharedCallbackSender = ServerManager.createSingleThreadExecutor("Shared notifications queue");
                    mySharedMessageCallbackSender = ServerManager.createSingleThreadExecutor("Shared messages notifications queue");
                }
                this.myCallbackSender = mySharedCallbackSender;
                this.myMessageCallbackSender = mySharedMessageCallbackSender;
            }
        } else {
            this.myCallbackSender = ServerManager.createSingleThreadExecutor("Notifications queue");
            this.myMessageCallbackSender = ServerManager.createSingleThreadExecutor("Messages notifications queue");
        }
        String extendedSessionInfoValue = null;
        try {
            extendedSessionInfoValue = System.getProperty("lightstreamer.extended_session_info");
        }
        catch (AccessControlException e) {
            // empty catch block
        }
        if (extendedSessionInfoValue != null) {
            this.extendedSessionInfo = extendedSessionInfoValue.equalsIgnoreCase("true");
            if (this.extendedSessionInfo) {
                actionsLogger.log(Level.FINER, "Extended session info enabled");
            }
        } else {
            this.extendedSessionInfo = false;
        }
    }

    public void onConnectionEstablished() {
        this.myCallbackSender.execute(new Runnable(){

            public void run() {
                try {
                    MyServerListener.this.initialListener.onConnectionEstablished();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }

    public void onSessionStarted(final String sessionID, final boolean isPolling, final String controlLink) {
        this.myCallbackSender.execute(new Runnable(){

            public void run() {
                try {
                    if (MyServerListener.this.extendedSessionInfo) {
                        MyServerListener.sendExtendedSessionInfo(MyServerListener.this.initialListener, sessionID, isPolling, controlLink);
                    } else {
                        MyServerListener.sendSessionInfo(MyServerListener.this.initialListener, isPolling, controlLink);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }

    public boolean onUpdate(TableManager table, ServerUpdateEvent values) {
        ConnectionListener activeListener = this.owner.getActiveListener(this.initialPhase);
        if (activeListener != null) {
            try {
                table.doUpdate(values);
            }
            catch (PushServerException e) {
                actionsLogger.log(Level.FINER, "Error in received values", e);
                this.onDataError(e);
            }
            return true;
        }
        return false;
    }

    public boolean onMessageOutcome(MessageManager message, final SequenceHandler sequence, ServerUpdateEvent values, Exception problem) {
        boolean executed = values == null ? message.setAbort(problem) : message.setOutcome(values);
        if (!executed) {
            this.onDataError(new PushServerException(13));
            return false;
        }
        if (message.getSequence().equals("UNORDERED_MESSAGES")) {
            final int num = message.getProg();
            this.myMessageCallbackSender.execute(new Runnable(){

                public void run() {
                    MessageManager mex = sequence.ifHasOutcomeExtractIt(num);
                    if (mex != null) {
                        try {
                            mex.notifyListener();
                        }
                        catch (PushServerException e) {
                            MyServerListener.this.onDataError(e);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
            });
        } else {
            this.myMessageCallbackSender.execute(new Runnable(){

                public void run() {
                    MessageManager mex;
                    while ((mex = sequence.ifFirstHasOutcomeExtractIt()) != null) {
                        try {
                            mex.notifyListener();
                        }
                        catch (PushServerException e) {
                            MyServerListener.this.onDataError(e);
                        }
                        catch (Throwable throwable) {}
                    }
                }
            });
        }
        return true;
    }

    public void onEndMessages() {
        if (this.myMessageCallbackSender != mySharedMessageCallbackSender) {
            this.myMessageCallbackSender.shutdown();
        }
    }

    public synchronized boolean onNewBytes(final long bytes) {
        final ConnectionListener activeListener = this.owner.getActiveListener(this.initialPhase);
        if (activeListener != null && !this.failed) {
            this.myCallbackSender.execute(new Runnable(){

                public void run() {
                    try {
                        activeListener.onNewBytes(bytes);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
            return true;
        }
        return false;
    }

    public synchronized boolean onDataError(final PushServerException e) {
        final ConnectionListener activeListener = this.owner.getActiveListener(this.initialPhase);
        if (activeListener != null && !this.failed) {
            this.myCallbackSender.execute(new Runnable(){

                public void run() {
                    try {
                        activeListener.onDataError(e);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
            return true;
        }
        return false;
    }

    public synchronized void onStreamingReturned() {
        if (this.initialListener instanceof ExtConnectionListener && !this.failed) {
            this.myCallbackSender.execute(new Runnable(){

                public void run() {
                    ((ExtConnectionListener)MyServerListener.this.initialListener).onStreamingReturned();
                }
            });
        }
    }

    public synchronized boolean onEnd(final int cause) {
        final ConnectionListener activeListener = this.owner.getActiveListener(this.initialPhase);
        if (activeListener != null && !this.failed) {
            this.failed = true;
            this.myCallbackSender.execute(new Runnable(){

                public void run() {
                    try {
                        activeListener.onEnd(cause);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
            return true;
        }
        return false;
    }

    public synchronized boolean onActivityWarning(final boolean warningOn) {
        final ConnectionListener activeListener = this.owner.getActiveListener(this.initialPhase);
        if (activeListener != null && !this.failed) {
            this.myCallbackSender.execute(new Runnable(){

                public void run() {
                    try {
                        activeListener.onActivityWarning(warningOn);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
            return true;
        }
        return false;
    }

    public synchronized boolean onReconnectTimeout() {
        final ConnectionListener activeListener = this.owner.getActiveListener(this.initialPhase);
        if (activeListener != null && !this.failed) {
            this.failed = true;
            final PushServerException rte = new PushServerException(11);
            if (activeListener instanceof ExtConnectionListener) {
                this.myCallbackSender.execute(new Runnable(){

                    public void run() {
                        ((ExtConnectionListener)activeListener).onConnectTimeout(rte);
                    }
                });
            } else {
                this.myCallbackSender.execute(new Runnable(){

                    public void run() {
                        try {
                            activeListener.onFailure(rte);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                });
            }
            return true;
        }
        return false;
    }

    public synchronized void onConnectTimeout() {
        if (this.initialListener instanceof ExtConnectionListener && !this.failed) {
            final PushServerException rte = new PushServerException(11);
            this.myCallbackSender.execute(new Runnable(){

                public void run() {
                    ((ExtConnectionListener)MyServerListener.this.initialListener).onConnectTimeout(rte);
                }
            });
        }
    }

    public synchronized void onConnectException(final Exception incapsulatingExc) {
        if (this.initialListener instanceof ExtConnectionListener && !this.failed) {
            this.myCallbackSender.execute(new Runnable(){

                public void run() {
                    try {
                        ((ExtConnectionListener)MyServerListener.this.initialListener).onConnectException(incapsulatingExc);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
        }
    }

    public synchronized boolean onFailure(final PushServerException e) {
        final ConnectionListener activeListener = this.owner.getActiveListener(this.initialPhase);
        if (activeListener != null && !this.failed) {
            this.failed = true;
            this.myCallbackSender.execute(new Runnable(){

                public void run() {
                    try {
                        activeListener.onFailure(e);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
            return true;
        }
        return false;
    }

    public synchronized boolean onFailure(final PushConnException e) {
        final ConnectionListener activeListener = this.owner.getActiveListener(this.initialPhase);
        if (activeListener != null && !this.failed) {
            this.failed = true;
            this.myCallbackSender.execute(new Runnable(){

                public void run() {
                    try {
                        activeListener.onFailure(e);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
            return true;
        }
        return false;
    }

    public boolean onClose() {
        ConnectionListener activeListener = this.owner.getActiveListener(this.initialPhase);
        if (activeListener != null) {
            this.owner.closeConnection();
            return true;
        }
        return false;
    }

    public synchronized void onClosed(final ConnectionListener closedListener) {
        this.failed = true;
        if (closedListener != null) {
            this.myCallbackSender.execute(new Runnable(){

                public void run() {
                    try {
                        closedListener.onClose();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
        }
        if (this.myCallbackSender != mySharedCallbackSender) {
            this.myCallbackSender.shutdown();
        }
    }

    public static void sendExtendedSessionInfo(ConnectionListener listener, String sessionID, boolean isPolling, String controlLink) {
        Method onSessionStartedExt;
        try {
            onSessionStartedExt = listener.getClass().getMethod("onSessionStartedExt", String.class, Boolean.TYPE);
        }
        catch (NoSuchMethodException e) {
            actionsLogger.log(Level.WARNING, NO_EXT_ONSESSION, e);
            MyServerListener.sendSessionInfo(listener, isPolling, controlLink);
            return;
        }
        catch (SecurityException e) {
            actionsLogger.log(Level.WARNING, NO_EXT_ONSESSION, e);
            MyServerListener.sendSessionInfo(listener, isPolling, controlLink);
            return;
        }
        try {
            onSessionStartedExt.invoke((Object)listener, sessionID, new Boolean(isPolling));
        }
        catch (IllegalAccessException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
    }

    public static void sendSessionInfo(ConnectionListener listener, boolean isPolling, String controlLink) {
        if (listener instanceof ExtendedConnectionListener) {
            ((ExtendedConnectionListener)listener).onSessionStarted(isPolling, controlLink);
        } else {
            listener.onSessionStarted(isPolling);
        }
    }
}

