/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.ls_client;

import com.lightstreamer.ls_client.PushConnException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

class MyLineReader {
    private final BufferedReader impl;

    protected MyLineReader() {
        this.impl = null;
    }

    public MyLineReader(InputStream stream, int suggestedBufferSize) {
        this.impl = new BufferedReader(new InputStreamReader(stream), suggestedBufferSize);
    }

    public MyLineReader(Reader reader, int suggestedBufferSize) {
        this.impl = new BufferedReader(reader, suggestedBufferSize);
    }

    public String readLine() throws PushConnException {
        try {
            return this.impl.readLine();
        }
        catch (IOException e) {
            throw new PushConnException(e);
        }
        catch (NumberFormatException nfe) {
            String osname = null;
            try {
                osname = System.getProperty("java.vm.name");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (osname != null && osname.equals("Dalvik")) {
                throw new PushConnException("Connection end (NFE, Dalvik bug?)");
            }
            throw new PushConnException("Unexpected error while reading", nfe);
        }
        catch (Throwable t) {
            throw new PushConnException("Unexpected error while reading", t);
        }
    }

    public void close() throws Throwable {
        this.impl.close();
    }
}

