/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.ls_client;

import com.lightstreamer.ls_client.BatchListener;
import com.lightstreamer.ls_client.BatchMonitor;
import com.lightstreamer.ls_client.MessageManager;
import com.lightstreamer.ls_client.PhaseException;
import com.lightstreamer.ls_client.PushConnException;
import com.lightstreamer.ls_client.PushServerException;
import com.lightstreamer.ls_client.PushUserException;
import com.lightstreamer.ls_client.ServerManager;
import com.lightstreamer.ls_client.SubscrException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

class MessageParallelizer
implements BatchListener {
    private BatchMonitor monitor;
    private ServerManager manager;
    private static final ExecutorService threadPool = Executors.newCachedThreadPool(new ThreadFactory(){

        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "SendMessage thread");
            t.setDaemon(true);
            return t;
        }
    });
    private ConcurrentLinkedQueue<MessageManager> queue = new ConcurrentLinkedQueue();
    private static final int EMPTY = 1;
    private static final int BATCHING = 2;
    private static final int SENDING = 3;
    private int status = 1;
    private int waitingToBeBatched = 0;
    private int batched = 0;

    public MessageParallelizer(BatchMonitor monitor, ServerManager manager) {
        this.monitor = monitor;
        monitor.setListener(this);
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueueMessage(MessageManager message, int prog) throws PhaseException {
        MessageParallelizer messageParallelizer = this;
        synchronized (messageParallelizer) {
            if (this.status == 1) {
                this.status = 2;
            }
            this.queue.add(message);
            ++this.waitingToBeBatched;
            if (this.waitingToBeBatched == 1) {
                this.batchMessage();
            }
        }
    }

    public synchronized void onMessageBatched() {
        --this.waitingToBeBatched;
        ++this.batched;
        this.batchMessage();
        if (this.status == 2) {
            this.prepareCloseBatch();
            this.status = 3;
        }
    }

    synchronized void onProcessed() {
        --this.batched;
        if (this.batched == 0 && this.waitingToBeBatched == 0) {
            this.status = 1;
        } else if (this.batched > 0) {
            this.prepareCloseBatch();
            this.status = 3;
        } else {
            this.status = 2;
        }
    }

    void prepareCloseBatch() {
        threadPool.submit(new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                BatchMonitor batchMonitor = MessageParallelizer.this.monitor;
                synchronized (batchMonitor) {
                    if (!MessageParallelizer.this.monitor.isEmpty()) {
                        MessageParallelizer.this.manager.closeMessageBatch();
                        try {
                            MessageParallelizer.this.manager.batchMessageRequests(0);
                        }
                        catch (PhaseException phaseException) {
                            // empty catch block
                        }
                    }
                }
            }
        });
    }

    synchronized void batchMessage() {
        threadPool.submit(new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                MessageManager message = (MessageManager)MessageParallelizer.this.queue.poll();
                if (message == null) {
                    return;
                }
                try {
                    MessageParallelizer.this.manager.sendMessage(message, message.getProg());
                }
                catch (PhaseException e) {
                }
                catch (PushConnException e) {
                }
                catch (PushServerException e) {
                }
                catch (PushUserException e) {
                }
                catch (SubscrException subscrException) {
                }
                finally {
                    MessageParallelizer.this.onProcessed();
                }
            }
        });
    }
}

