/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.ls_client;

import com.lightstreamer.ls_client.MessageInfo;
import com.lightstreamer.ls_client.PushServerException;
import com.lightstreamer.ls_client.SendMessageListener;
import com.lightstreamer.ls_client.ServerUpdateEvent;

class MessageManager {
    private final MessageInfo message;
    private final SendMessageListener listener;
    private int prog = 0;
    private Exception problem = null;
    private boolean aborted = false;
    private ServerUpdateEvent processed = null;

    MessageManager(MessageInfo message, SendMessageListener listener) {
        this.message = message;
        this.listener = listener;
    }

    synchronized void enqueued(int prog) {
        this.prog = prog;
    }

    synchronized int getProg() {
        return this.prog;
    }

    synchronized int getDelayTimeout() {
        return this.message.getDelayTimeout();
    }

    synchronized String getSequence() {
        return this.message.getSequence();
    }

    synchronized String getMessage() {
        return this.message.getMessage();
    }

    public synchronized boolean setAbort(Exception problem) {
        if (!this.hasOutcome()) {
            this.aborted = true;
            this.problem = problem;
            return true;
        }
        return false;
    }

    public synchronized boolean setOutcome(ServerUpdateEvent values) {
        if (!this.hasOutcome()) {
            this.processed = values;
            return true;
        }
        return false;
    }

    public synchronized boolean hasOutcome() {
        return this.aborted || this.processed != null;
    }

    public synchronized void notifyListener() throws PushServerException {
        if (!this.hasOutcome()) {
            throw new PushServerException(13);
        }
        if (this.listener != null) {
            if (this.aborted) {
                this.listener.onAbort(this.message, this.prog, this.problem);
            } else if (this.processed != null) {
                if (this.processed.getErrorMessage() == null) {
                    this.listener.onProcessed(this.message, this.prog);
                } else {
                    this.listener.onError(this.processed.getErrorCode(), this.processed.getErrorMessage(), this.message, this.prog);
                }
            }
        }
    }
}

