/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.ls_client;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MessageInfo {
    public static final String UNORDERED_MESSAGES = "UNORDERED_MESSAGES";
    private int delayTimeout = -1;
    private String sequence;
    private String message;
    private static final String wrongSeqName = "Sequence name can only contain alphanumeric characters and/or underscores and can't be null nor an empry string";
    private static final String noMessage = "Message cannot be null";
    private static final Pattern ext_alpha_numeric = Pattern.compile("^[a-zA-Z0-9_]*$");

    public MessageInfo(String message, String sequence) {
        this(message, sequence, -1);
    }

    public MessageInfo(String message, String sequence, int delayTimeout) {
        MessageInfo.validateSequence(sequence);
        if (message == null) {
            throw new IllegalArgumentException(noMessage);
        }
        this.message = message;
        this.sequence = sequence;
        this.delayTimeout = delayTimeout;
    }

    private static void validateSequence(String sequence) {
        if (sequence == null || sequence.equals("")) {
            throw new IllegalArgumentException(wrongSeqName);
        }
        Matcher seqMatcher = ext_alpha_numeric.matcher(sequence);
        if (!seqMatcher.matches()) {
            throw new IllegalArgumentException(wrongSeqName);
        }
    }

    public String toString() {
        return this.sequence + "/" + this.delayTimeout + "/" + this.message;
    }

    public int getDelayTimeout() {
        return this.delayTimeout;
    }

    public String getSequence() {
        return this.sequence;
    }

    public String getMessage() {
        return this.message;
    }
}

