/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.ls_client;

import com.lightstreamer.ls_client.ConnectionConstraints;
import com.lightstreamer.ls_client.ConnectionInfo;
import com.lightstreamer.ls_client.ConnectionListener;
import com.lightstreamer.ls_client.ExtConnectionListener;
import com.lightstreamer.ls_client.ExtendedTableInfo;
import com.lightstreamer.ls_client.FullTableManager;
import com.lightstreamer.ls_client.HandyTableListener;
import com.lightstreamer.ls_client.MessageInfo;
import com.lightstreamer.ls_client.MessageManager;
import com.lightstreamer.ls_client.MyServerListener;
import com.lightstreamer.ls_client.PhaseException;
import com.lightstreamer.ls_client.PushConnException;
import com.lightstreamer.ls_client.PushServerException;
import com.lightstreamer.ls_client.PushUserException;
import com.lightstreamer.ls_client.SendMessageListener;
import com.lightstreamer.ls_client.ServerManager;
import com.lightstreamer.ls_client.SimpleTableInfo;
import com.lightstreamer.ls_client.SubscrException;
import com.lightstreamer.ls_client.SubscribedTableKey;
import com.lightstreamer.ls_client.SubscriptionConstraints;
import com.lightstreamer.ls_client.TableManager;
import com.lightstreamer.ls_client.VirtualTableManager;
import java.util.logging.Logger;

public class LSClient {
    private final Object stateMutex = new Object();
    private int phase = 0;
    private ServerManager connManager;
    private ConnectionListener connListener;
    private MyServerListener asyncListener;
    private LSClient subClient = null;
    private static Logger actionsLogger = Logger.getLogger("com.lightstreamer.ls_client.actions");
    private boolean sendMessageAutoBatchingEnabled = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void openConnection(ConnectionInfo info, ConnectionListener listener) throws PushConnException, PushServerException, PushUserException {
        int currPhase;
        Object object = this.stateMutex;
        synchronized (object) {
            this.closeConnection();
            currPhase = ++this.phase;
        }
        ConnectionInfo myInfo = (ConnectionInfo)info.clone();
        if (myInfo.enableStreamSense && !myInfo.isPolling) {
            final LSClient testClient = new LSClient();
            final ExtConnectionListener myListener = new ExtConnectionListener(listener);
            final ConnectionInfo mySubInfo = (ConnectionInfo)myInfo.clone();
            mySubInfo.enableStreamSense = false;
            Thread connector = new Thread(){

                public void run() {
                    try {
                        testClient.openConnection(mySubInfo, myListener);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            connector.start();
            boolean streamTimeout = myListener.waitStreamingTimeoutAnswer();
            if (!streamTimeout) {
                Object object2 = this.stateMutex;
                synchronized (object2) {
                    if (currPhase == this.phase) {
                        this.subClient = testClient;
                        // MONITOREXIT @DISABLED, blocks:[19, 20, 21, 10] lbl20 : MonitorExitStatement: MONITOREXIT : var10_14
                        myListener.flushAndStart();
                        return;
                    }
                    myListener.abort();
                    LSClient.asynchCloseConnection(testClient);
                    return;
                }
            }
            myListener.abort();
            LSClient.asynchCloseConnection(testClient);
            Object object3 = this.stateMutex;
            synchronized (object3) {
                if (currPhase != this.phase) {
                    return;
                }
            }
            LSClient pollClient = new LSClient();
            myInfo.isPolling = true;
            pollClient.openConnection(myInfo, listener);
            Object object4 = this.stateMutex;
            synchronized (object4) {
                if (currPhase == this.phase) {
                    this.subClient = pollClient;
                    return;
                }
                LSClient.asynchCloseConnection(pollClient);
                return;
            }
        }
        MyServerListener serverListener = new MyServerListener(this, listener, currPhase);
        boolean ok = false;
        try {
            ServerManager newManager = new ServerManager(myInfo, serverListener);
            newManager.connect();
            ok = true;
            Object object5 = this.stateMutex;
            synchronized (object5) {
                if (currPhase == this.phase) {
                    this.connListener = listener;
                    this.asyncListener = serverListener;
                    this.connManager = newManager;
                    // MONITOREXIT @DISABLED, blocks:[16, 4, 9] lbl59 : MonitorExitStatement: MONITOREXIT : var8_12
                    newManager.start();
                    return;
                }
                LSClient.closeFlushing(newManager, serverListener, listener);
                return;
            }
        }
        finally {
            if (!ok) {
                serverListener.onClosed(null);
                serverListener.onEndMessages();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection() {
        ConnectionListener activeListener = null;
        ServerManager closingManager = null;
        MyServerListener closeListener = null;
        LSClient closingSubClient = null;
        Object object = this.stateMutex;
        synchronized (object) {
            ++this.phase;
            if (this.subClient != null) {
                closingSubClient = this.subClient;
                this.subClient = null;
            } else if (this.connManager != null) {
                closingManager = this.connManager;
                activeListener = this.connListener;
                closeListener = this.asyncListener;
                this.connManager = null;
                this.connListener = null;
                this.asyncListener = null;
            } else {
                return;
            }
        }
        if (closingSubClient != null) {
            closingSubClient.closeConnection();
        } else {
            LSClient.closeFlushing(closingManager, closeListener, activeListener);
        }
    }

    private static void asynchCloseConnection(final LSClient testClient) {
        Thread closer = new Thread(){

            public void run() {
                testClient.closeConnection();
            }
        };
        closer.start();
    }

    private static void closeFlushing(ServerManager closingManager, MyServerListener closeListener, ConnectionListener activeListener) {
        TableManager[] zombieTables = closingManager.close();
        for (int i = 0; i < zombieTables.length; ++i) {
            TableManager info = zombieTables[i];
            info.notifyUnsub();
        }
        closeListener.onClosed(activeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerManager getConnManager() throws SubscrException {
        Object object = this.stateMutex;
        synchronized (object) {
            if (this.subClient != null) {
                return this.subClient.getConnManager();
            }
            if (this.connManager == null) {
                throw new SubscrException("Connection closed");
            }
            return this.connManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConnectionListener getActiveListener(int currPhase) {
        Object object = this.stateMutex;
        synchronized (object) {
            if (this.subClient != null) {
                return this.subClient.getActiveListener(currPhase);
            }
            if (currPhase == this.phase) {
                return this.connListener;
            }
            return null;
        }
    }

    public void sendMessage(String message) throws PushConnException, PushServerException, PushUserException {
        ServerManager currConnManager;
        try {
            currConnManager = this.getConnManager();
        }
        catch (SubscrException e) {
            return;
        }
        try {
            currConnManager.sendMessage(message);
        }
        catch (PhaseException e) {
            return;
        }
    }

    public int sendMessage(MessageInfo message, SendMessageListener listener) throws PushConnException, PushServerException, PushUserException {
        int prog;
        ServerManager currConnManager;
        try {
            currConnManager = this.getConnManager();
        }
        catch (SubscrException e) {
            return 0;
        }
        try {
            prog = currConnManager.sendMessage(new MessageManager(message, listener), this.sendMessageAutoBatchingEnabled);
        }
        catch (PhaseException e) {
            return 0;
        }
        catch (SubscrException e) {
            return 0;
        }
        return prog;
    }

    public void changeConstraints(ConnectionConstraints constraints) throws PushConnException, PushServerException {
        ServerManager currConnManager;
        try {
            currConnManager = this.getConnManager();
        }
        catch (SubscrException e) {
            return;
        }
        try {
            currConnManager.changeConstraints(constraints);
        }
        catch (PhaseException e) {
            return;
        }
    }

    public SubscribedTableKey subscribeTable(SimpleTableInfo table, HandyTableListener listener, boolean commandLogic) throws SubscrException, PushServerException, PushUserException, PushConnException {
        ServerManager currConnManager = this.getConnManager();
        FullTableManager tableInfo = new FullTableManager(table, listener, commandLogic);
        try {
            return currConnManager.subscrTable(tableInfo, true);
        }
        catch (PhaseException e) {
            throw new SubscrException("Connection closed");
        }
    }

    public SubscribedTableKey subscribeTable(ExtendedTableInfo table, HandyTableListener listener, boolean commandLogic) throws SubscrException, PushServerException, PushUserException, PushConnException {
        ServerManager currConnManager = this.getConnManager();
        FullTableManager tableInfo = new FullTableManager(table, listener, commandLogic);
        try {
            return currConnManager.subscrTable(tableInfo, true);
        }
        catch (PhaseException e) {
            throw new SubscrException("Connection closed");
        }
    }

    public SubscribedTableKey[] subscribeItems(ExtendedTableInfo items, HandyTableListener listener) throws SubscrException, PushServerException, PushUserException, PushConnException {
        ServerManager currConnManager = this.getConnManager();
        VirtualTableManager tableInfo = new VirtualTableManager(items, listener);
        try {
            return currConnManager.subscrItems(tableInfo, true);
        }
        catch (PhaseException e) {
            throw new SubscrException("Connection closed");
        }
    }

    public void changeSubscription(SubscribedTableKey tableKey, SubscriptionConstraints constraints) throws SubscrException, PushServerException, PushConnException {
        ServerManager currConnManager = this.getConnManager();
        SubscribedTableKey[] tableKeys = new SubscribedTableKey[]{tableKey};
        TableManager[] infos = currConnManager.findTables(tableKeys);
        if (infos[0] == null) {
            return;
        }
        try {
            currConnManager.constrainTables(tableKeys, constraints);
        }
        catch (PhaseException e) {
            throw new SubscrException("Connection closed");
        }
    }

    public void changeSubscriptions(SubscribedTableKey[] tableKeys, SubscriptionConstraints constraints) throws SubscrException, PushServerException, PushConnException {
        ServerManager currConnManager = this.getConnManager();
        TableManager[] infos = currConnManager.findTables(tableKeys);
        int found = 0;
        for (int i = 0; i < infos.length; ++i) {
            if (infos[i] == null) continue;
            ++found;
        }
        if (found == 0) {
            return;
        }
        SubscribedTableKey[] foundTableKeys = new SubscribedTableKey[found];
        int curr = 0;
        for (int i = 0; i < infos.length; ++i) {
            if (infos[i] == null) continue;
            foundTableKeys[curr] = tableKeys[i];
            ++curr;
        }
        try {
            currConnManager.constrainTables(foundTableKeys, constraints);
        }
        catch (PhaseException e) {
            throw new SubscrException("Connection closed");
        }
    }

    public void unsubscribeTable(SubscribedTableKey tableKey) throws SubscrException, PushServerException, PushConnException {
        ServerManager currConnManager = this.getConnManager();
        SubscribedTableKey[] tableKeys = new SubscribedTableKey[]{tableKey};
        TableManager[] infos = currConnManager.detachTables(tableKeys);
        if (infos[0] == null) {
            try {
                currConnManager.unsubscrTables(new SubscribedTableKey[0], true);
            }
            catch (PhaseException e) {
                // empty catch block
            }
            throw new SubscrException("Table not found");
        }
        infos[0].notifyUnsub();
        try {
            currConnManager.unsubscrTables(tableKeys, true);
        }
        catch (PhaseException e) {
            throw new SubscrException("Connection closed");
        }
    }

    public void unsubscribeTables(SubscribedTableKey[] tableKeys) throws SubscrException, PushServerException, PushConnException {
        ServerManager currConnManager = this.getConnManager();
        TableManager[] infos = currConnManager.detachTables(tableKeys);
        int found = 0;
        for (int i = 0; i < infos.length; ++i) {
            if (infos[i] == null) continue;
            infos[i].notifyUnsub();
            ++found;
        }
        if (found == 0) {
            // empty if block
        }
        SubscribedTableKey[] foundTableKeys = new SubscribedTableKey[found];
        int curr = 0;
        for (int i = 0; i < infos.length; ++i) {
            if (infos[i] == null) continue;
            foundTableKeys[curr] = tableKeys[i];
            ++curr;
        }
        try {
            currConnManager.unsubscrTables(foundTableKeys, true);
        }
        catch (PhaseException e) {
            throw new SubscrException("Connection closed");
        }
    }

    public void forceUnsubscribeTable(SubscribedTableKey tableKey) throws SubscrException, PushServerException, PushConnException {
        ServerManager currConnManager = this.getConnManager();
        if (tableKey.getKeyValue() == null) {
            return;
        }
        SubscribedTableKey[] tableKeys = new SubscribedTableKey[]{tableKey};
        try {
            currConnManager.unsubscrTables(tableKeys, false);
        }
        catch (PhaseException e) {
            throw new SubscrException("Connection closed");
        }
    }

    public void batchRequests(int batchSize) throws SubscrException {
        ServerManager currConnManager = this.getConnManager();
        try {
            currConnManager.batchRequests(batchSize);
        }
        catch (PhaseException e) {
            throw new SubscrException("Connection closed");
        }
    }

    public void unbatchRequest() {
        try {
            ServerManager currConnManager = this.getConnManager();
            currConnManager.unbatchRequest();
        }
        catch (SubscrException e) {
            actionsLogger.finer("Unbatch request received with no open session");
        }
    }

    public void closeBatch() {
        try {
            ServerManager currConnManager = this.getConnManager();
            currConnManager.closeBatch();
        }
        catch (SubscrException e) {
            actionsLogger.finer("Unbatch request received with no open session");
        }
    }
}

