/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.ls_client;

import com.lightstreamer.ls_client.MyLineReader;
import com.lightstreamer.ls_client.PushConnException;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.URLEncoder;
import java.security.AccessControlException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HttpProvider {
    private String address;
    private String request;
    public static volatile boolean asyncEnablable = true;
    public static volatile boolean asyncEnabled = false;
    private static volatile Method asyncConnfactoryMethod = null;
    private static Logger streamLogger = Logger.getLogger("com.lightstreamer.ls_client.stream");
    private static Logger protLogger = Logger.getLogger("com.lightstreamer.ls_client.protocol");

    private static String getProp(String name) {
        try {
            return System.getProperty("lightstreamer.client." + name);
        }
        catch (AccessControlException e) {
            return null;
        }
    }

    public static synchronized void checkAsyncProp() {
        if (!asyncEnablable) {
            return;
        }
        String async = HttpProvider.getProp("asyncIO");
        if (async == null) {
            asyncEnabled = false;
            asyncEnablable = false;
        } else if (async.equalsIgnoreCase("true")) {
            asyncEnabled = true;
            asyncEnablable = false;
        } else {
            asyncEnabled = false;
            asyncEnablable = true;
        }
    }

    HttpProvider(String address) {
        this.address = address;
    }

    protected boolean addLine(HashMap<String, String> params, int limit) throws PushConnException {
        String parameters = this.hashToString(params);
        String newRequest = this.request == null ? parameters : this.request + "\r\n" + parameters;
        if (limit > 0 && newRequest.length() > limit) {
            return false;
        }
        this.request = newRequest;
        return true;
    }

    private HttpURLConnection sendPost() throws Throwable {
        String connTimeout;
        streamLogger.finer("Opening connection to " + this.address);
        URL url = new URL(this.address);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        if (connection == null) {
            streamLogger.finer("Failed connection to " + this.address);
            throw new IOException("Connection failed");
        }
        connection.setRequestMethod("POST");
        connection.setUseCaches(false);
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setAllowUserInteraction(false);
        String readTimeout = HttpProvider.getProp("defaultReadTimeout");
        if (readTimeout != null) {
            try {
                int timeout = Integer.parseInt(readTimeout);
                connection.setReadTimeout(timeout);
            }
            catch (NumberFormatException e) {
                streamLogger.warning("Default read timeout property incorrect");
            }
        }
        if ((connTimeout = HttpProvider.getProp("defaultConnectTimeout")) != null) {
            try {
                int timeout = Integer.parseInt(connTimeout);
                connection.setConnectTimeout(timeout);
            }
            catch (NumberFormatException e) {
                streamLogger.warning("Default connect timeout property incorrect");
            }
        }
        DataOutputStream out = new DataOutputStream(connection.getOutputStream());
        if (this.request != null) {
            if (streamLogger.isLoggable(Level.FINEST)) {
                streamLogger.finest("Posting data: " + this.request);
            }
            out.writeBytes(this.request);
        }
        out.flush();
        out.close();
        return connection;
    }

    private AsyncConnection sendPostForAsync() throws Throwable {
        AsyncConnection connection;
        streamLogger.finer("Opening connection to " + this.address);
        URL url = new URL(this.address);
        InetSocketAddress isa = new InetSocketAddress(url.getHost(), url.getPort());
        try {
            if (asyncConnfactoryMethod == null) {
                String name = this.getClass().getPackage().getName() + ".MyAsyncConnectionProxy";
                Class<?> asyncConnProxyClass = Class.forName(name);
                asyncConnfactoryMethod = asyncConnProxyClass.getDeclaredMethod("getInstance", new Class[0]);
            }
            Object asyncConnProxy = asyncConnfactoryMethod.invoke(null, new Object[0]);
            connection = (AsyncConnection)asyncConnProxy;
        }
        catch (Throwable t) {
            throw new IOException("Asynchronous sockets handlers not included");
        }
        connection.connect(isa);
        DataOutputStream out = new DataOutputStream(connection.getOutputStream());
        out.writeBytes("POST " + url.getPath() + " HTTP/1.0\r\n");
        out.writeBytes("content-length: " + this.request.length() + "\r\n");
        out.writeBytes("\r\n");
        if (streamLogger.isLoggable(Level.FINEST)) {
            streamLogger.finest("Posting data: " + this.request);
        }
        out.writeBytes(this.request);
        out.flush();
        return connection;
    }

    InputStream doPost(HashMap<String, String> params, boolean forData) throws PushConnException {
        this.addLine(params, 0);
        return this.connectAndGetAnswer(forData);
    }

    protected InputStream connectAndGetAnswer(boolean forData) throws PushConnException {
        AsyncConnection connection;
        if (forData && asyncEnablable) {
            HttpProvider.checkAsyncProp();
        }
        if (!forData || !asyncEnabled) {
            HttpURLConnection connection2;
            try {
                connection2 = this.sendPost();
            }
            catch (IOException e) {
                throw new PushConnException(e);
            }
            catch (Throwable t) {
                throw new PushConnException("Unexpected error while connecting", t);
            }
            try {
                return connection2.getInputStream();
            }
            catch (IOException e) {
                connection2.disconnect();
                throw new PushConnException(e);
            }
            catch (Throwable t) {
                throw new PushConnException("Unexpected error while connecting", t);
            }
        }
        try {
            connection = this.sendPostForAsync();
        }
        catch (IOException e) {
            throw new PushConnException(e);
        }
        catch (Throwable t) {
            throw new PushConnException("Unexpected error while connecting", t);
        }
        try {
            return connection.getInputStream();
        }
        catch (IOException e) {
            try {
                connection.disconnect();
            }
            catch (IOException e1) {
                protLogger.log(Level.FINE, "Error while disconnecting upon connection issues", e1);
            }
            throw new PushConnException(e);
        }
        catch (Throwable t) {
            throw new PushConnException("Unexpected error while connecting", t);
        }
    }

    private String hashToString(HashMap<String, String> parameters) throws PushConnException {
        StringBuffer out = new StringBuffer();
        for (String name : parameters.keySet()) {
            String value = parameters.get(name);
            if (value == null) {
                value = "";
            }
            try {
                value = URLEncoder.encode(value, "UTF-8");
            }
            catch (Throwable t) {
                protLogger.log(Level.FINER, "Error sending command", t);
                throw new PushConnException("Encoding error");
            }
            if (out.length() != 0) {
                out.append("&");
            }
            out.append(name);
            out.append("=");
            out.append(value);
        }
        return out.toString();
    }

    static interface LineConsumer {
        public boolean consume();
    }

    static interface AsyncStream {
        public MyLineReader getLineReader();

        public void startAsync(LineConsumer var1);
    }

    static interface AsyncConnection {
        public void connect(InetSocketAddress var1) throws IOException;

        public InputStream getInputStream() throws IOException;

        public OutputStream getOutputStream() throws IOException;

        public void disconnect() throws IOException;
    }
}

