/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.ls_client;

import com.lightstreamer.ls_client.ExtendedTableInfo;
import com.lightstreamer.ls_client.HandyTableListener;
import com.lightstreamer.ls_client.PushServerException;
import com.lightstreamer.ls_client.ServerUpdateEvent;
import com.lightstreamer.ls_client.SimpleTableInfo;
import com.lightstreamer.ls_client.TableManager;
import com.lightstreamer.ls_client.UpdateInfoImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

class FullTableManager
implements TableManager {
    private final SimpleTableInfo baseInfo;
    private final ExtendedTableInfo extInfo;
    private final HandyTableListener listener;
    private final boolean isCommandLogic;
    private final Map fieldIndexMap;
    private final ArrayList itemInfos = new ArrayList();
    private boolean unsubscrDone = false;
    private static Logger actionsLogger = Logger.getLogger("com.lightstreamer.ls_client.actions");

    FullTableManager(SimpleTableInfo table, HandyTableListener listener, boolean doCommandLogic) {
        this.baseInfo = (SimpleTableInfo)table.clone();
        this.isCommandLogic = doCommandLogic;
        if (table instanceof ExtendedTableInfo) {
            this.extInfo = (ExtendedTableInfo)this.baseInfo;
            this.fieldIndexMap = new HashMap(){
                {
                    for (int i = 0; i < ((FullTableManager)FullTableManager.this).extInfo.fields.length; ++i) {
                        this.put(((FullTableManager)FullTableManager.this).extInfo.fields[i], new Integer(i));
                    }
                }
            };
        } else {
            this.extInfo = null;
            this.fieldIndexMap = null;
        }
        this.listener = listener;
    }

    public void doUpdate(ServerUpdateEvent values) throws PushServerException {
        int itemPos = values.getItemCode();
        int itemIndex = itemPos - 1;
        this.processUpdate(values, itemPos, itemIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpdate(ServerUpdateEvent values, int itemPos, int itemIndex) throws PushServerException {
        ItemInfo info;
        String itemName = null;
        if (this.extInfo != null) {
            if (itemIndex < 0 || itemIndex >= this.extInfo.items.length) {
                throw new PushServerException(2);
            }
            itemName = this.extInfo.items[itemIndex];
        }
        ArrayList arrayList = this.itemInfos;
        synchronized (arrayList) {
            if (this.unsubscrDone) {
                return;
            }
            while (this.itemInfos.size() <= itemIndex) {
                this.itemInfos.add(null);
            }
            info = (ItemInfo)this.itemInfos.get(itemIndex);
            if (info == null) {
                info = this.isCommandLogic ? new CommandLogicItemInfo(itemPos, itemName) : new ItemInfo(itemPos, itemName);
                this.itemInfos.set(itemIndex, info);
            }
        }
        if (values.isEOS()) {
            info.snapshotPending = false;
            try {
                this.listener.onSnapshotEnd(itemPos, itemName);
            }
            catch (Throwable t) {}
        } else if (values.getOverflow() > 0) {
            if (!this.baseInfo.hasUnfilteredData()) {
                throw new PushServerException(7);
            }
            actionsLogger.warning("Got notification of updates lost for item " + info);
            try {
                this.listener.onRawUpdatesLost(itemPos, itemName, values.getOverflow());
            }
            catch (Throwable t) {}
        } else {
            if (this.extInfo != null && values.getSize() != this.extInfo.fields.length) {
                throw new PushServerException(3);
            }
            Object[] update = values.getArray();
            if (actionsLogger.isLoggable(Level.FINEST)) {
                actionsLogger.finest("Got event for item " + info + " with values " + Arrays.toString(update));
            }
            boolean isSnapshot = info.snapshotPending;
            String[] prevState = info.update((String[])update);
            if (prevState == null) {
                return;
            }
            UpdateInfoImpl updInfo = new UpdateInfoImpl(info, prevState, (String[])update, isSnapshot);
            if (actionsLogger.isLoggable(Level.FINEST)) {
                actionsLogger.finest("Notifying event for item " + info + " with values " + updInfo);
            }
            try {
                this.listener.onUpdate(itemPos, itemName, updInfo);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyUnsub() {
        ItemInfo[] infos;
        ArrayList arrayList = this.itemInfos;
        synchronized (arrayList) {
            infos = this.itemInfos.toArray(new ItemInfo[0]);
            this.unsubscrDone = true;
        }
        for (int i = 0; i < infos.length; ++i) {
            if (infos[i] == null) continue;
            this.notifyUnsubForItem(infos[i].pos, infos[i].name);
        }
        try {
            this.listener.onUnsubscrAll();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void notifyUnsubForItem(int itemPos, String itemName) {
        try {
            this.listener.onUnsubscr(itemPos, itemName);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getGroup() {
        return this.baseInfo.group;
    }

    public String getMode() {
        return this.baseInfo.mode;
    }

    public String getSchema() {
        return this.baseInfo.schema;
    }

    public String getDataAdapter() {
        return this.baseInfo.dataAdapter;
    }

    public String getSelector() {
        return this.baseInfo.selector;
    }

    public boolean isSnapshot() {
        return this.baseInfo.snapshot;
    }

    public Integer getDistinctSnapshotLength() {
        return this.baseInfo.distinctSnapshotLength;
    }

    public Integer getStart() {
        return this.baseInfo.start;
    }

    public Integer getEnd() {
        return this.baseInfo.end;
    }

    public Integer getMaxBufferSize() {
        return this.baseInfo.bufferSize;
    }

    public Double getMaxFrequency() {
        return this.baseInfo.maxFrequency;
    }

    public boolean isUnfiltered() {
        return this.baseInfo.unfiltered;
    }

    public String toString() {
        return this.getMode() + " table [" + this.getGroup() + " ; " + this.getSchema() + "]";
    }

    class CommandLogicItemInfo
    extends ItemInfo {
        private final int keyIndex;
        private final int commandIndex;
        private HashMap keyStates;

        public CommandLogicItemInfo(int pos, String name) {
            super(pos, name);
            this.keyStates = new HashMap();
            if (FullTableManager.this.extInfo != null) {
                Integer keyIndexVal = (Integer)FullTableManager.this.fieldIndexMap.get("key");
                Integer commandIndexVal = (Integer)FullTableManager.this.fieldIndexMap.get("command");
                this.keyIndex = keyIndexVal == null ? -1 : keyIndexVal;
                this.commandIndex = commandIndexVal == null ? -1 : commandIndexVal;
            } else {
                this.keyIndex = 0;
                this.commandIndex = 1;
            }
        }

        public String[] update(String[] event) {
            super.update(event);
            String ADD = "ADD";
            String UPDATE = "UPDATE";
            String DELETE = "DELETE";
            String key = null;
            if (this.keyIndex >= 0 && this.keyIndex < this.currState.length) {
                key = this.currState[this.keyIndex];
            } else {
                actionsLogger.warning("key field not subscribed for item " + this + " - null key forced for command logic");
            }
            String command = null;
            if (this.commandIndex >= 0 && this.commandIndex < this.currState.length) {
                command = this.currState[this.commandIndex];
                if (command == null) {
                    actionsLogger.warning("No value found for command field for item " + this + " - trying to add/update for command logic");
                } else if (command.equals(DELETE)) {
                    command = DELETE;
                } else if (command.equals(ADD)) {
                    command = ADD;
                } else if (command.equals(UPDATE)) {
                    command = UPDATE;
                } else {
                    actionsLogger.warning("Invalid value for command field for item " + this + " - trying to add/update for command logic");
                }
            } else {
                actionsLogger.warning("command field not subscribed for item " + this + " - trying to add/update for command logic");
            }
            String[] keyState = (String[])this.keyStates.get(key);
            if (command == DELETE) {
                if (actionsLogger.isLoggable(Level.FINEST)) {
                    actionsLogger.finest("Processing DELETE event in COMMAND logic for item " + this + " and key " + key);
                }
                if (keyState == null) {
                    actionsLogger.warning("Unexpected DELETE command for item " + this + " - discarding the command");
                    return null;
                }
                this.keyStates.remove(key);
                for (int i = 0; i < this.currState.length; ++i) {
                    event[i] = i == this.keyIndex ? ServerUpdateEvent.UNCHANGED : (i == this.commandIndex ? DELETE : null);
                }
                return keyState;
            }
            if (actionsLogger.isLoggable(Level.FINEST)) {
                actionsLogger.finest("Processing ADD/UPDATE event in COMMAND logic for item " + this + " and key " + key);
            }
            if (keyState == null) {
                if (command == UPDATE) {
                    actionsLogger.warning("Unexpected UPDATE command for item " + this + " - command changed into ADD");
                }
                for (int i = 0; i < this.currState.length; ++i) {
                    event[i] = i == this.commandIndex ? ADD : this.currState[i];
                }
                this.keyStates.put(key, event);
                return new String[this.currState.length];
            }
            if (command == ADD) {
                actionsLogger.warning("Unexpected ADD command for item " + this + " - command changed into UPDATE");
            }
            for (int i = 0; i < this.currState.length; ++i) {
                event[i] = i == this.keyIndex ? ServerUpdateEvent.UNCHANGED : (i == this.commandIndex ? (keyState[i] == ADD ? UPDATE : ServerUpdateEvent.UNCHANGED) : (this.currState[i] == null && keyState[i] == null ? ServerUpdateEvent.UNCHANGED : (this.currState[i] == null || keyState[i] == null ? this.currState[i] : (this.currState[i].equals(keyState[i]) ? ServerUpdateEvent.UNCHANGED : this.currState[i]))));
            }
            if (command == UPDATE) {
                this.keyStates.put(key, this.currState);
            } else {
                String[] newState = new String[this.currState.length];
                for (int i = 0; i < this.currState.length; ++i) {
                    newState[i] = i == this.commandIndex ? UPDATE : this.currState[i];
                }
                this.keyStates.put(key, newState);
            }
            return keyState;
        }
    }

    class ItemInfo {
        public final int pos;
        public final String name;
        public boolean snapshotPending;
        protected String[] currState;

        public ItemInfo(int pos, String name) {
            this.pos = pos;
            this.name = name;
            this.snapshotPending = ((FullTableManager)FullTableManager.this).baseInfo.snapshot;
        }

        public String[] update(String[] event) {
            if (this.currState == null) {
                this.currState = new String[event.length];
            }
            String[] prevState = this.currState;
            this.currState = new String[this.currState.length];
            for (int i = 0; i < this.currState.length; ++i) {
                this.currState[i] = event[i] != ServerUpdateEvent.UNCHANGED ? event[i] : prevState[i];
            }
            if (this.snapshotPending && ((FullTableManager)FullTableManager.this).baseInfo.mode.equals("MERGE")) {
                this.snapshotPending = false;
            }
            return prevState;
        }

        public Map getFieldIndexMap() {
            return FullTableManager.this.fieldIndexMap;
        }

        public String toString() {
            if (this.name != null) {
                return this.name;
            }
            return Integer.toString(this.pos);
        }
    }
}

